/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="PERS_PERSON t LEFT JOIN PERS_POSITION p ON t.POSITION_ID=p.ID")
@OrderBy(after="t.CREATE_TIME DESC")
public class PersPersonPinItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID", equalTag="=")
    private String id;
    @Column(name="t.PIN")
    private String pin;
    @Column(name="t.PHOTO_PATH")
    private String photoPath;
    @Condition(value="t.ID", equalTag="in")
    private String inId;
    @Condition(value="t.ID", equalTag="not in")
    private String notInId;
    @Condition(value="t.PIN", equalTag="in")
    private String inPin;
    @Condition(value="t.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="t.GENDER", equalTag="=")
    private String gender;
    @Condition(value="t.EMAIL", equalTag="like")
    private String email;
    @Column(name="t.MOBILE_PHONE")
    private String mobilePhone;
    @Condition(value="t.EXCEPTION_FLAG", equalTag="=")
    private Short exceptionFlag;
    @Condition(value="t.ID IN (SELECT c.PERSON_ID FROM PERS_CARD c WHERE c.CARD_NO LIKE ''%{0}%'')")
    private String likeCardNo;
    private String deptName;
    private String deptId;
    private String verifyMode;
    @Column(name="p.NAME")
    private String positionName;

    public PersPersonPinItem() {
    }

    public PersPersonPinItem(Boolean equals) {
        super(equals);
    }

    public PersPersonPinItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PersPersonPinItem(String id, String pin) {
        this.id = id;
        this.pin = pin;
    }

    public String getId() {
        return this.id;
    }

    public String getPin() {
        return this.pin;
    }

    public String getPhotoPath() {
        return this.photoPath;
    }

    public String getInId() {
        return this.inId;
    }

    public String getNotInId() {
        return this.notInId;
    }

    public String getInPin() {
        return this.inPin;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getGender() {
        return this.gender;
    }

    public String getEmail() {
        return this.email;
    }

    public String getMobilePhone() {
        return this.mobilePhone;
    }

    public Short getExceptionFlag() {
        return this.exceptionFlag;
    }

    public String getLikeCardNo() {
        return this.likeCardNo;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getVerifyMode() {
        return this.verifyMode;
    }

    public String getPositionName() {
        return this.positionName;
    }

    public PersPersonPinItem setId(String id) {
        this.id = id;
        return this;
    }

    public PersPersonPinItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public PersPersonPinItem setPhotoPath(String photoPath) {
        this.photoPath = photoPath;
        return this;
    }

    public PersPersonPinItem setInId(String inId) {
        this.inId = inId;
        return this;
    }

    public PersPersonPinItem setNotInId(String notInId) {
        this.notInId = notInId;
        return this;
    }

    public PersPersonPinItem setInPin(String inPin) {
        this.inPin = inPin;
        return this;
    }

    public PersPersonPinItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PersPersonPinItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PersPersonPinItem setGender(String gender) {
        this.gender = gender;
        return this;
    }

    public PersPersonPinItem setEmail(String email) {
        this.email = email;
        return this;
    }

    public PersPersonPinItem setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    public PersPersonPinItem setExceptionFlag(Short exceptionFlag) {
        this.exceptionFlag = exceptionFlag;
        return this;
    }

    public PersPersonPinItem setLikeCardNo(String likeCardNo) {
        this.likeCardNo = likeCardNo;
        return this;
    }

    public PersPersonPinItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PersPersonPinItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PersPersonPinItem setVerifyMode(String verifyMode) {
        this.verifyMode = verifyMode;
        return this;
    }

    public PersPersonPinItem setPositionName(String positionName) {
        this.positionName = positionName;
        return this;
    }

    public String toString() {
        return "PersPersonPinItem(id=" + this.getId() + ", pin=" + this.getPin() + ", photoPath=" + this.getPhotoPath() + ", inId=" + this.getInId() + ", notInId=" + this.getNotInId() + ", inPin=" + this.getInPin() + ", inDeptId=" + this.getInDeptId() + ", likeName=" + this.getLikeName() + ", gender=" + this.getGender() + ", email=" + this.getEmail() + ", mobilePhone=" + this.getMobilePhone() + ", exceptionFlag=" + this.getExceptionFlag() + ", likeCardNo=" + this.getLikeCardNo() + ", deptName=" + this.getDeptName() + ", deptId=" + this.getDeptId() + ", verifyMode=" + this.getVerifyMode() + ", positionName=" + this.getPositionName() + ")";
    }
}

