/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccTransactionTodayRemote;
import com.zkteco.zkbiosecurity.acc.service.AccTransactionService;
import com.zkteco.zkbiosecurity.acc.vo.AccTransactionTodayItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccTransactionTodayController
extends ExportController
implements AccTransactionTodayRemote {
    @Autowired
    private AccTransactionService accTransactionService;

    @RequiresPermissions(value={"acc:transactionToday"})
    public ModelAndView index() {
        return new ModelAndView("acc/transactionToday/accTransactionToday");
    }

    @RequiresPermissions(value={"acc:transactionToday:refresh"})
    public DxGrid list(AccTransactionTodayItem condition) {
        condition.setStartTime(DateUtil.getTodayBeginTime());
        condition.setEndTime(DateUtil.getTodayEndTime());
        Pager pager = this.accTransactionService.loadTodayTransactionByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"acc:transactionToday:del"})
    public ZKResultMsg del(String ids) {
        this.accTransactionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:transactionToday:del"})
    @LogRequest(module="acc_module", object="acc_trans_today", opType="common_op_clearData", opContent="common_op_clearData")
    public ZKResultMsg clearData() {
        this.accTransactionService.deleteAllDataByToday();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:transactionToday:export"})
    @LogRequest(module="acc_module", object="acc_trans_today", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        AccTransactionTodayItem accTransactionTodayItem = new AccTransactionTodayItem();
        this.setConditionValue((BaseItem)accTransactionTodayItem);
        accTransactionTodayItem.setStartTime(DateUtil.getTodayBeginTime());
        accTransactionTodayItem.setEndTime(DateUtil.getTodayEndTime());
        accTransactionTodayItem.setAreaNameIn(this.accTransactionService.getAreaNamesBySessionId(request.getSession().getId()));
        accTransactionTodayItem.setDeptCodeIn(this.accTransactionService.getDeptCodesBySessionId(request.getSession().getId()));
        List itemList = this.accTransactionService.getItemData(AccTransactionTodayItem.class, (BaseItem)accTransactionTodayItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, AccTransactionTodayItem.class);
    }
}

