/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.ProxySelector;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.swing.JFrame;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.JNLPAuthenticator;
import net.sourceforge.jnlp.util.logging.JavaConsole;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.applet.AppletPanel;
import sun.applet.AppletSecurityContextManager;
import sun.applet.PluginAppletSecurityContext;
import sun.applet.PluginAppletViewer;
import sun.applet.PluginCallRequestFactory;
import sun.applet.PluginCookieManager;
import sun.applet.PluginDebug;
import sun.applet.PluginProxySelector;
import sun.applet.PluginStreamHandler;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.net.www.protocol.http.Handler;

public class PluginMain {
    private static final String theVersion = System.getProperty("java.version");

    private static void installDummyJavascriptProtocolHandler() {
        try {
            Field handlersField = URL.class.getDeclaredField("handlers");
            handlersField.setAccessible(true);
            Map handlers = (Map)handlersField.get(null);
            handlers.put("javascript", new Handler());
        }
        catch (Exception e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Unable to install 'javascript:' URL protocol handler!");
            OutputController.getLogger().log(e);
        }
    }

    public static void main(String[] args) throws IOException {
        OutputController.getLogger().log("startup arguments: ");
        for (int i = 0; i < args.length; ++i) {
            String string = args[i];
            OutputController.getLogger().log(i + ": " + string);
        }
        if (AppContext.getAppContext() == null) {
            SunToolkit.createNewAppContext();
        }
        PluginMain.installDummyJavascriptProtocolHandler();
        if (args.length < 2 || !new File(args[0]).exists() || !new File(args[1]).exists()) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Invalid pipe names provided. Refusing to proceed.");
            JNLPRuntime.exit(1);
        }
        DeploymentConfiguration.move14AndOlderFilesTo15StructureCatched();
        if (JavaConsole.isEnabled()) {
            if (args.length < 3 || !new File(args[2]).exists()) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Warning, although console is on, plugin debug connection do not exists. No plugin information will be displayed in console (only java ones).");
            } else {
                JavaConsole.getConsole().createPluginReader(new File(args[2]));
            }
        }
        try {
            PluginStreamHandler streamHandler = PluginMain.connect(args[0], args[1]);
            PluginMain.initSecurityContext(streamHandler);
            PluginAppletViewer.setStreamhandler(streamHandler);
            PluginAppletViewer.setPluginCallRequestFactory(new PluginCallRequestFactory());
            PluginMain.init();
            streamHandler.startProcessing();
            PluginMain.setCookieHandler(streamHandler);
            JavaConsole.getConsole().setClassLoaderInfoProvider(new JavaConsole.ClassLoaderInfoProvider(){

                @Override
                public Map<String, String> getLoaderInfo() {
                    return PluginAppletSecurityContext.getLoaderInfo();
                }
            });
        }
        catch (Exception e) {
            OutputController.getLogger().log(e);
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Something very bad happened. I don't know what to do, so I am going to exit :(");
            JNLPRuntime.exit(1);
        }
    }

    public static void initSecurityContext(PluginStreamHandler streamHandler) {
        PluginAppletSecurityContext sc = new PluginAppletSecurityContext(0);
        sc.prePopulateLCClasses();
        PluginAppletSecurityContext.setStreamhandler(streamHandler);
        AppletSecurityContextManager.addContext(0, sc);
    }

    private PluginMain() {
    }

    private static PluginStreamHandler connect(String inPipe, String outPipe) {
        PluginStreamHandler streamHandler = null;
        try {
            streamHandler = new PluginStreamHandler(new FileInputStream(inPipe), new FileOutputStream(outPipe));
            PluginDebug.debug("Streams initialized");
        }
        catch (IOException ioe) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ioe);
        }
        return streamHandler;
    }

    private static void init() {
        Properties avProps = new Properties();
        avProps.put("browser", "sun.applet.AppletViewer");
        avProps.put("browser.version", "1.06");
        avProps.put("browser.vendor", "Sun Microsystems Inc.");
        avProps.put("http.agent", "Java(tm) 2 SDK, Standard Edition v" + theVersion);
        avProps.put("package.restrict.definition.java", "true");
        avProps.put("package.restrict.definition.sun", "true");
        avProps.put("java.version.applet", "true");
        avProps.put("java.vendor.applet", "true");
        avProps.put("java.vendor.url.applet", "true");
        avProps.put("java.class.version.applet", "true");
        avProps.put("os.name.applet", "true");
        avProps.put("os.version.applet", "true");
        avProps.put("os.arch.applet", "true");
        avProps.put("file.separator.applet", "true");
        avProps.put("path.separator.applet", "true");
        avProps.put("line.separator.applet", "true");
        avProps.put("javaplugin.nodotversion", "160_17");
        avProps.put("javaplugin.version", "1.6.0_17");
        avProps.put("javaplugin.vm.options", "");
        Properties sysProps = System.getProperties();
        Enumeration<?> e = sysProps.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = sysProps.getProperty(key);
            avProps.setProperty(key, val);
        }
        System.setProperties(avProps);
        boolean installAuthenticator = Boolean.valueOf(JNLPRuntime.getConfiguration().getProperty("deployment.security.authenticator"));
        if (installAuthenticator) {
            Authenticator.setDefault(new JNLPAuthenticator());
        }
        ProxySelector.setDefault(new PluginProxySelector(JNLPRuntime.getConfiguration()));
    }

    private static void setCookieHandler(PluginStreamHandler streamHandler) {
        PluginCookieManager ckManager = new PluginCookieManager(streamHandler);
        CookieHandler.setDefault(ckManager);
    }

    public static JFrame javawsHtmlMain(PluginBridge pb, URL html) {
        PluginAppletViewer.setStreamhandler(PluginStreamHandler.DummyHandler);
        PluginMain.initSecurityContext(PluginStreamHandler.DummyHandler);
        AppletPanel p = PluginAppletViewer.initialize(pb.getParams(), 0L, html, 0, pb);
        JFrame f = new JFrame();
        f.setSize(p.getAppletWidth(), p.getAppletHeight());
        f.add((Component)p);
        return f;
    }
}

