/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;
import java.util.Map;
import java.util.UUID;

@From(after="ATT_LEAVE t ")
@GroupBy(after="t.AUTH_DEPT_ID, t.PERS_PERSON_ID, t.PERS_PERSON_PIN,t.PERS_PERSON_LAST_NAME")
@OrderBy(after="t.PERS_PERSON_PIN DESC")
@GridConfig(operate=false, idField="id", winHeight=400, winWidth=600)
public class AttLeaveSummaryReportItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @GridColumn(show=false)
    private String id;
    @Column(name="t.PERS_PERSON_ID")
    private String personId;
    @Column(name="t.PERS_PERSON_PIN")
    @GridColumn(label="att_person_pin", width="120")
    private String personPin;
    @Condition(value="t.PERS_PERSON_NAME", equalTag="like")
    @GridColumn(label="att_person_name", width="120")
    private String personName;
    @Column(name="t.PERS_PERSON_LAST_NAME")
    @GridColumn(label="att_person_lastName", showExpression="#language!='zh_CN'", width="100")
    private String personLastName;
    @GridColumn(show=false)
    @Column(name="t.AUTH_DEPT_ID")
    private String deptId;
    @GridColumn(label="pers_dept_deptNo", width="150")
    private String deptCode;
    @GridColumn(label="pers_dept_deptName", width="150")
    private String deptName;
    @GridColumn(dynamicColumn="leaveTypeDyna")
    private Map<String, Object> leaveTypeMap;
    @Condition(value="t.END_DATETIME", equalTag=">=")
    private Date startApplyDateTime;
    @Condition(value="t.START_DATETIME", equalTag="<=")
    private Date endApplyDateTime;
    @Condition(value="t.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="(lower(t.PERS_PERSON_NAME) LIKE ''%{0}%'' OR lower(t.PERS_PERSON_LAST_NAME) LIKE ''%{0}%'')")
    private String likeName;
    @Condition(value="t.FLOW_STATUS", equalTag="=")
    private String flowStatus;

    public AttLeaveSummaryReportItem() {
    }

    public AttLeaveSummaryReportItem(Boolean equals) {
        super(equals);
        this.id = UUID.randomUUID().toString();
    }

    public AttLeaveSummaryReportItem setId(String id) {
        this.id = id;
        return this;
    }

    public AttLeaveSummaryReportItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public AttLeaveSummaryReportItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public AttLeaveSummaryReportItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public AttLeaveSummaryReportItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public AttLeaveSummaryReportItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public AttLeaveSummaryReportItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public AttLeaveSummaryReportItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AttLeaveSummaryReportItem setLeaveTypeMap(Map<String, Object> leaveTypeMap) {
        this.leaveTypeMap = leaveTypeMap;
        return this;
    }

    public AttLeaveSummaryReportItem setStartApplyDateTime(Date startApplyDateTime) {
        this.startApplyDateTime = startApplyDateTime;
        return this;
    }

    public AttLeaveSummaryReportItem setEndApplyDateTime(Date endApplyDateTime) {
        this.endApplyDateTime = endApplyDateTime;
        return this;
    }

    public AttLeaveSummaryReportItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public AttLeaveSummaryReportItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public AttLeaveSummaryReportItem setFlowStatus(String flowStatus) {
        this.flowStatus = flowStatus;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public Map<String, Object> getLeaveTypeMap() {
        return this.leaveTypeMap;
    }

    public Date getStartApplyDateTime() {
        return this.startApplyDateTime;
    }

    public Date getEndApplyDateTime() {
        return this.endApplyDateTime;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getFlowStatus() {
        return this.flowStatus;
    }
}

