/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.utils;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.utils.Base64Util;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringUtil;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ParkWebCommonUtil {
    public static boolean isNotNull(Object obj) {
        return !ParkWebCommonUtil.isNull(obj);
    }

    public static boolean isNull(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Map && ((Map)obj).isEmpty()) {
            return true;
        }
        if (obj instanceof JSONObject && ((JSONObject)obj).isEmpty()) {
            return true;
        }
        if (obj instanceof Long && (Long)obj == 0L) {
            return true;
        }
        if (obj instanceof List && ((List)obj).isEmpty()) {
            return true;
        }
        if (obj instanceof Collection && ((Collection)obj).isEmpty()) {
            return true;
        }
        return obj instanceof String && ((String)obj).isEmpty();
    }

    public static Map convertObjToMap(Object obj) {
        HashMap<String, Object> reMap = new HashMap<String, Object>();
        if (obj == null) {
            return null;
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        try {
            for (int i = 0; i < fields.length; ++i) {
                try {
                    Field f = obj.getClass().getDeclaredField(fields[i].getName());
                    f.setAccessible(true);
                    Object o = f.get(obj);
                    reMap.put(fields[i].getName(), o);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return reMap;
    }

    public static JSONObject getBaseJson(String opType) {
        JSONObject jsonInfo = new JSONObject();
        String msgId = UUID.randomUUID().toString();
        jsonInfo.put("Mode", (Object)"Park");
        jsonInfo.put("MsgId", (Object)msgId);
        jsonInfo.put("OpType", (Object)opType);
        return jsonInfo;
    }

    public static JSONObject getDisplayBaseJson(String model, String opType) {
        JSONObject jsonInfo = new JSONObject();
        String msgId = UUID.randomUUID().toString();
        jsonInfo.put("Mode", (Object)model);
        jsonInfo.put("MsgId", (Object)msgId);
        jsonInfo.put("OpType", (Object)opType);
        return jsonInfo;
    }

    public static boolean createDir(String destDirName) {
        File dir = new File(destDirName);
        if (dir.exists()) {
            return false;
        }
        if (!destDirName.endsWith(File.separator)) {
            destDirName = destDirName + File.separator;
        }
        return dir.mkdirs();
    }

    public static String replaceExComma(String str) {
        return str.replaceAll("(?:^,+)|(?:,+$)|(,),+", "$1");
    }

    public static Timestamp pastTime(Timestamp onTime, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(onTime);
        calendar.add(12, -minute);
        calendar.add(13, -second);
        return new Timestamp(calendar.getTimeInMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImgBase64ByteByPath(String filePath) {
        FileInputStream fStream = null;
        String imgBase64Str = "";
        File file = new File(filePath);
        try {
            if (file.exists()) {
                fStream = new FileInputStream(file);
                int lenght = fStream.available();
                byte[] data = new byte[lenght];
                fStream.read(data);
                imgBase64Str = Base64Util.encode((byte[])data);
                imgBase64Str = imgBase64Str.replaceAll("[\\s*\t\n\r]", "");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fStream != null) {
                    fStream.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return imgBase64Str;
    }

    public static String getSystemFilePath() {
        ParkParamsService parkParamsService = (ParkParamsService)SpringUtil.getBean(ParkParamsService.class);
        return parkParamsService.getPhotoSavePath() + "\\";
    }

    public static String getSystemFilePathForSDK() {
        ParkParamsService parkParamsService = (ParkParamsService)SpringUtil.getBean(ParkParamsService.class);
        return parkParamsService.getPhotoSavePath();
    }

    public static String getDatePhotoPath() {
        return DateUtil.dateToString((Date)new Date(), (String)DateUtil.DateStyle.YYYY_MM_DD.getValue()) + "\\";
    }

    public static String getPayMentByCode(Short code) {
        String paymentName = "";
        switch (code) {
            case 1: {
                paymentName = I18nUtil.i18nCode((String)"park_parkingLotSet_payMentMethod_cash", (Object[])new Object[0]);
                break;
            }
            case 2: {
                paymentName = I18nUtil.i18nCode((String)"park_parkingLotSet_payMentMethod_card", (Object[])new Object[0]);
                break;
            }
            case 3: {
                paymentName = I18nUtil.i18nCode((String)"park_recordin_eventType_perPay", (Object[])new Object[0]);
                break;
            }
            case 4: {
                paymentName = I18nUtil.i18nCode((String)"park_recordin_eventType_payed", (Object[])new Object[0]);
                break;
            }
            case 5: {
                paymentName = I18nUtil.i18nCode((String)"park_parkingLotSet_payMentMethod_central", (Object[])new Object[0]);
                break;
            }
            case 6: {
                paymentName = I18nUtil.i18nCode((String)"park_recordin_eventType_payedAliPay", (Object[])new Object[0]);
            }
        }
        return paymentName;
    }
}

