/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;
import java.util.List;
import java.util.Map;

@From(after="PARK_AUTHORIZE t LEFT JOIN PARK_CAR_TYPE type ON t.CAR_TYPE_ID = type.ID LEFT JOIN PARK_CAR_NUMBER car ON t.CAR_NUMBER_ID = car.ID LEFT JOIN PARK_FIXED_CHARGE charge ON t.FIXED_CHARGE_ID = charge.ID LEFT JOIN PARK_PARKINGSPACE space ON t.PARKINGSPACE_ID = space.ID LEFT JOIN PARK_PERSON pp ON pp.ID = t.PARK_PERSON_ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=450, operates={@GridOperate(type="custom", permission="park:authorize:edit", click="editAuthorize", label="common_op_edit"), @GridOperate(type="custom", permission="park:authorize:del", click="parkDelAuthorize", label="park_authorize_del")})
public class ParkAuthorizeItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.PARK_PERSON_ID")
    private String parkPersonId;
    @Column(name="pp.PERS_PERSON_ID")
    private String persPersonId;
    @Column(name="pp.PERS_PERSON_PIN")
    private String persPersonPin;
    @Column(name="pp.PERS_PERSON_NAME")
    @GridColumn(label="pers_person_name", sortNo=1, width="120", columnType="custom", convert="showAuthoizeName")
    private String personName;
    @Column(name="pp.PERS_PERSON_LASTNAME")
    @GridColumn(label="pers_person_lastName", sortNo=2, width="120", showExpression="#language!='zh_CN'")
    private String personLastName;
    @Condition(value="pp.AUTH_DEPT_ID", equalTag="in")
    private String deptId;
    @Column(name="car.ID")
    private String carNumberId;
    @Column(name="car.CAR_NUMBER")
    @GridColumn(label="park_carNumber", sortNo=3, width="120")
    private String carNumber;
    @Column(name="car.CARD_NO")
    @GridColumn(label="pers_card_cardNo", sortNo=4, width="120")
    private String cardNo;
    private String parkEntZoneIds;
    @GridColumn(label="park_entranceArea_name", sortNo=5, width="200", sort="na")
    private String parkEntZoneNames;
    @Column(name="space.ID")
    private String parkingSpaceId;
    @Column(name="space.SPACE_NAME")
    @GridColumn(label="park_parkingSpace_spaceName", sortNo=6, width="120")
    private String parkingSpaceName;
    @Column(name="type.ID")
    private String carTypeId;
    @Column(name="type.NAME")
    @GridColumn(label="park_carType_name", sortNo=7, width="120")
    private String carTypeName;
    @Column(name="type.CODE")
    private String carTypeCode;
    @Column(name="type.CODE", equalTag="!=")
    private String carTypeCodeNot;
    @Column(name="type.TYPE")
    private Short carTypeType;
    @Column(name="charge.ID")
    private String fixedChargeId;
    @Column(name="charge.NAME")
    private String fixedChargeName;
    @Column(name="t.START_TIME")
    @DateType(type="date")
    @GridColumn(label="common_startTime", sortNo=8, width="120")
    private Date startTime;
    @Column(name="t.END_TIME")
    @DateType(type="date")
    @GridColumn(label="common_endTime", sortNo=9, width="120")
    private Date endTime;
    @Column(name="t.END_TIME", equalTag="<=")
    @DateType(type="date")
    private Date endTimeLessEqual;
    @Column(name="t.STATUS")
    private Short status;
    @Column(name="t.DEBT")
    @GridColumn(label="park_authorize_debt", sortNo=10, width="120")
    private Double debt;
    @GridColumn(label="park_authorize_operator", sortNo=11, width="120")
    @Column(name="t.UPDATER_CODE")
    private String createrName;
    private Date createrTime;
    @Condition(value="t.ID IN (SELECT autharea.AUTHORIZE_ID FROM PARK_AUTHORIZE_AREA autharea WHERE autharea.entrance_area_id IN (SELECT entarea.id AS entareaId FROM PARK_ENTRANCE_AREA entarea LEFT JOIN PARK_PARKING_AREA area ON area.ID = entarea.PARKING_AREA_ID WHERE area.ID = '%s'))")
    private String parkParkingAreaId;
    @Condition(value="t.ID IN (SELECT autharea.AUTHORIZE_ID FROM PARK_AUTHORIZE_AREA autharea WHERE autharea.entrance_area_id IN (SELECT entarea.id as entareaId FROM PARK_ENTRANCE_AREA entarea WHERE entarea.ID = '%s'))")
    private String parkEntranceAreaId;
    @Condition(value="pp.PERS_PERSON_ID", equalTag="in")
    private String persPersonIdIn;
    @Condition(value="t.END_TIME", equalTag="<=")
    private Date lessEndTime;
    @Condition(value="(pp.PERS_PERSON_NAME LIKE ''%{0}%'' OR pp.PERS_PERSON_LASTNAME LIKE ''%{0}%'')")
    private String likeName;
    @Condition(value="pp.ID IN (SELECT DISTINCT pp.ID FROM park_person pp,park_car_number car WHERE car.PERSON_ID = pp.ID AND car.car_number LIKE ''%{0}%'')")
    private String carNumberEx;
    private boolean fixedFeeScale;
    private boolean displayParkingSpace;
    private String parkingLotModel;
    private String nowTime;
    private String modelAndView;
    private String batchAuthorizeSelect;
    private String saveLogValue;
    List<Map<String, Object>> batchAuthorizeSelectMap;
    private Boolean batchAuthorize = false;

    public ParkAuthorizeItem() {
    }

    public ParkAuthorizeItem(Boolean equals) {
        super(equals);
    }

    public ParkAuthorizeItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getParkPersonId() {
        return this.parkPersonId;
    }

    public String getPersPersonId() {
        return this.persPersonId;
    }

    public String getPersPersonPin() {
        return this.persPersonPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getCarNumberId() {
        return this.carNumberId;
    }

    public String getCarNumber() {
        return this.carNumber;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getParkEntZoneIds() {
        return this.parkEntZoneIds;
    }

    public String getParkEntZoneNames() {
        return this.parkEntZoneNames;
    }

    public String getParkingSpaceId() {
        return this.parkingSpaceId;
    }

    public String getParkingSpaceName() {
        return this.parkingSpaceName;
    }

    public String getCarTypeId() {
        return this.carTypeId;
    }

    public String getCarTypeName() {
        return this.carTypeName;
    }

    public String getCarTypeCode() {
        return this.carTypeCode;
    }

    public String getCarTypeCodeNot() {
        return this.carTypeCodeNot;
    }

    public Short getCarTypeType() {
        return this.carTypeType;
    }

    public String getFixedChargeId() {
        return this.fixedChargeId;
    }

    public String getFixedChargeName() {
        return this.fixedChargeName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Date getEndTimeLessEqual() {
        return this.endTimeLessEqual;
    }

    public Short getStatus() {
        return this.status;
    }

    public Double getDebt() {
        return this.debt;
    }

    public String getCreaterName() {
        return this.createrName;
    }

    public Date getCreaterTime() {
        return this.createrTime;
    }

    public String getParkParkingAreaId() {
        return this.parkParkingAreaId;
    }

    public String getParkEntranceAreaId() {
        return this.parkEntranceAreaId;
    }

    public String getPersPersonIdIn() {
        return this.persPersonIdIn;
    }

    public Date getLessEndTime() {
        return this.lessEndTime;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getCarNumberEx() {
        return this.carNumberEx;
    }

    public boolean isFixedFeeScale() {
        return this.fixedFeeScale;
    }

    public boolean isDisplayParkingSpace() {
        return this.displayParkingSpace;
    }

    public String getParkingLotModel() {
        return this.parkingLotModel;
    }

    public String getNowTime() {
        return this.nowTime;
    }

    public String getModelAndView() {
        return this.modelAndView;
    }

    public String getBatchAuthorizeSelect() {
        return this.batchAuthorizeSelect;
    }

    public String getSaveLogValue() {
        return this.saveLogValue;
    }

    public List<Map<String, Object>> getBatchAuthorizeSelectMap() {
        return this.batchAuthorizeSelectMap;
    }

    public Boolean getBatchAuthorize() {
        return this.batchAuthorize;
    }

    public ParkAuthorizeItem setId(String id) {
        this.id = id;
        return this;
    }

    public ParkAuthorizeItem setParkPersonId(String parkPersonId) {
        this.parkPersonId = parkPersonId;
        return this;
    }

    public ParkAuthorizeItem setPersPersonId(String persPersonId) {
        this.persPersonId = persPersonId;
        return this;
    }

    public ParkAuthorizeItem setPersPersonPin(String persPersonPin) {
        this.persPersonPin = persPersonPin;
        return this;
    }

    public ParkAuthorizeItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public ParkAuthorizeItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public ParkAuthorizeItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public ParkAuthorizeItem setCarNumberId(String carNumberId) {
        this.carNumberId = carNumberId;
        return this;
    }

    public ParkAuthorizeItem setCarNumber(String carNumber) {
        this.carNumber = carNumber;
        return this;
    }

    public ParkAuthorizeItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public ParkAuthorizeItem setParkEntZoneIds(String parkEntZoneIds) {
        this.parkEntZoneIds = parkEntZoneIds;
        return this;
    }

    public ParkAuthorizeItem setParkEntZoneNames(String parkEntZoneNames) {
        this.parkEntZoneNames = parkEntZoneNames;
        return this;
    }

    public ParkAuthorizeItem setParkingSpaceId(String parkingSpaceId) {
        this.parkingSpaceId = parkingSpaceId;
        return this;
    }

    public ParkAuthorizeItem setParkingSpaceName(String parkingSpaceName) {
        this.parkingSpaceName = parkingSpaceName;
        return this;
    }

    public ParkAuthorizeItem setCarTypeId(String carTypeId) {
        this.carTypeId = carTypeId;
        return this;
    }

    public ParkAuthorizeItem setCarTypeName(String carTypeName) {
        this.carTypeName = carTypeName;
        return this;
    }

    public ParkAuthorizeItem setCarTypeCode(String carTypeCode) {
        this.carTypeCode = carTypeCode;
        return this;
    }

    public ParkAuthorizeItem setCarTypeCodeNot(String carTypeCodeNot) {
        this.carTypeCodeNot = carTypeCodeNot;
        return this;
    }

    public ParkAuthorizeItem setCarTypeType(Short carTypeType) {
        this.carTypeType = carTypeType;
        return this;
    }

    public ParkAuthorizeItem setFixedChargeId(String fixedChargeId) {
        this.fixedChargeId = fixedChargeId;
        return this;
    }

    public ParkAuthorizeItem setFixedChargeName(String fixedChargeName) {
        this.fixedChargeName = fixedChargeName;
        return this;
    }

    public ParkAuthorizeItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public ParkAuthorizeItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public ParkAuthorizeItem setEndTimeLessEqual(Date endTimeLessEqual) {
        this.endTimeLessEqual = endTimeLessEqual;
        return this;
    }

    public ParkAuthorizeItem setStatus(Short status) {
        this.status = status;
        return this;
    }

    public ParkAuthorizeItem setDebt(Double debt) {
        this.debt = debt;
        return this;
    }

    public ParkAuthorizeItem setCreaterName(String createrName) {
        this.createrName = createrName;
        return this;
    }

    public ParkAuthorizeItem setCreaterTime(Date createrTime) {
        this.createrTime = createrTime;
        return this;
    }

    public ParkAuthorizeItem setParkParkingAreaId(String parkParkingAreaId) {
        this.parkParkingAreaId = parkParkingAreaId;
        return this;
    }

    public ParkAuthorizeItem setParkEntranceAreaId(String parkEntranceAreaId) {
        this.parkEntranceAreaId = parkEntranceAreaId;
        return this;
    }

    public ParkAuthorizeItem setPersPersonIdIn(String persPersonIdIn) {
        this.persPersonIdIn = persPersonIdIn;
        return this;
    }

    public ParkAuthorizeItem setLessEndTime(Date lessEndTime) {
        this.lessEndTime = lessEndTime;
        return this;
    }

    public ParkAuthorizeItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public ParkAuthorizeItem setCarNumberEx(String carNumberEx) {
        this.carNumberEx = carNumberEx;
        return this;
    }

    public ParkAuthorizeItem setFixedFeeScale(boolean fixedFeeScale) {
        this.fixedFeeScale = fixedFeeScale;
        return this;
    }

    public ParkAuthorizeItem setDisplayParkingSpace(boolean displayParkingSpace) {
        this.displayParkingSpace = displayParkingSpace;
        return this;
    }

    public ParkAuthorizeItem setParkingLotModel(String parkingLotModel) {
        this.parkingLotModel = parkingLotModel;
        return this;
    }

    public ParkAuthorizeItem setNowTime(String nowTime) {
        this.nowTime = nowTime;
        return this;
    }

    public ParkAuthorizeItem setModelAndView(String modelAndView) {
        this.modelAndView = modelAndView;
        return this;
    }

    public ParkAuthorizeItem setBatchAuthorizeSelect(String batchAuthorizeSelect) {
        this.batchAuthorizeSelect = batchAuthorizeSelect;
        return this;
    }

    public ParkAuthorizeItem setSaveLogValue(String saveLogValue) {
        this.saveLogValue = saveLogValue;
        return this;
    }

    public ParkAuthorizeItem setBatchAuthorizeSelectMap(List<Map<String, Object>> batchAuthorizeSelectMap) {
        this.batchAuthorizeSelectMap = batchAuthorizeSelectMap;
        return this;
    }

    public ParkAuthorizeItem setBatchAuthorize(Boolean batchAuthorize) {
        this.batchAuthorize = batchAuthorize;
        return this;
    }

    public String toString() {
        return "ParkAuthorizeItem(id=" + this.getId() + ", parkPersonId=" + this.getParkPersonId() + ", persPersonId=" + this.getPersPersonId() + ", persPersonPin=" + this.getPersPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", deptId=" + this.getDeptId() + ", carNumberId=" + this.getCarNumberId() + ", carNumber=" + this.getCarNumber() + ", cardNo=" + this.getCardNo() + ", parkEntZoneIds=" + this.getParkEntZoneIds() + ", parkEntZoneNames=" + this.getParkEntZoneNames() + ", parkingSpaceId=" + this.getParkingSpaceId() + ", parkingSpaceName=" + this.getParkingSpaceName() + ", carTypeId=" + this.getCarTypeId() + ", carTypeName=" + this.getCarTypeName() + ", carTypeCode=" + this.getCarTypeCode() + ", carTypeCodeNot=" + this.getCarTypeCodeNot() + ", carTypeType=" + this.getCarTypeType() + ", fixedChargeId=" + this.getFixedChargeId() + ", fixedChargeName=" + this.getFixedChargeName() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", endTimeLessEqual=" + this.getEndTimeLessEqual() + ", status=" + this.getStatus() + ", debt=" + this.getDebt() + ", createrName=" + this.getCreaterName() + ", createrTime=" + this.getCreaterTime() + ", parkParkingAreaId=" + this.getParkParkingAreaId() + ", parkEntranceAreaId=" + this.getParkEntranceAreaId() + ", persPersonIdIn=" + this.getPersPersonIdIn() + ", lessEndTime=" + this.getLessEndTime() + ", likeName=" + this.getLikeName() + ", carNumberEx=" + this.getCarNumberEx() + ", fixedFeeScale=" + this.isFixedFeeScale() + ", displayParkingSpace=" + this.isDisplayParkingSpace() + ", parkingLotModel=" + this.getParkingLotModel() + ", nowTime=" + this.getNowTime() + ", modelAndView=" + this.getModelAndView() + ", batchAuthorizeSelect=" + this.getBatchAuthorizeSelect() + ", saveLogValue=" + this.getSaveLogValue() + ", batchAuthorizeSelectMap=" + this.getBatchAuthorizeSelectMap() + ", batchAuthorize=" + this.getBatchAuthorize() + ")";
    }
}

