/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="PARK_PERSON t LEFT JOIN PARK_CAR_NUMBER car ON car.PERSON_ID = t.ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig
public class ParkPersonItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    private String id;
    @Column(name="t.PERS_PERSON_ID")
    private String personId;
    @Column(name="t.PERS_PERSON_ID")
    private String persPersonId;
    @Column(name="t.PERS_PERSON_PIN")
    private String persPersonPin;
    @Column(name="t.PERS_PERSON_NAME")
    private String persPersonName;
    @Column(name="t.PERS_PERSON_LASTNAME")
    private String persPersonLastName;
    @Column(name="t.AUTH_DEPT_ID")
    private String deptId;
    @Column(name="t.AUTH_DEPT_NAME")
    private String deptName;
    @Condition(value="t.PERS_PERSON_ID", equalTag="not in")
    private String notInPersonId;
    @Condition(value="t.ID IN (SELECT person.id as personIds FROM PARK_CAR_NUMBER car LEFT JOIN PARK_PERSON person ON person.ID = car.PERSON_ID WHERE car.CAR_NUMBER LIKE ''%{0}%'')")
    private String carNumber;
    @Condition(value="(t.PERS_PERSON_NAME LIKE ''%{0}%'' OR t.PERS_PERSON_LASTNAME LIKE ''%{0}%'')")
    private String likeName;
    @Condition(value="t.AUTH_DEPT_ID", equalTag="in")
    private String deptIdIn;
    @Condition(value="t.ID", equalTag="not in")
    private String idNotIn;
    @Column(name="t.PEOPLE_TYPE")
    private Short peopleType;

    public ParkPersonItem() {
    }

    public ParkPersonItem(Boolean equals) {
        super(equals);
    }

    public ParkPersonItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public ParkPersonItem(String id, Short peopleType) {
        this.id = id;
        this.peopleType = peopleType;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersPersonId() {
        return this.persPersonId;
    }

    public String getPersPersonPin() {
        return this.persPersonPin;
    }

    public String getPersPersonName() {
        return this.persPersonName;
    }

    public String getPersPersonLastName() {
        return this.persPersonLastName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getNotInPersonId() {
        return this.notInPersonId;
    }

    public String getCarNumber() {
        return this.carNumber;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getDeptIdIn() {
        return this.deptIdIn;
    }

    public String getIdNotIn() {
        return this.idNotIn;
    }

    public Short getPeopleType() {
        return this.peopleType;
    }

    public ParkPersonItem setId(String id) {
        this.id = id;
        return this;
    }

    public ParkPersonItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public ParkPersonItem setPersPersonId(String persPersonId) {
        this.persPersonId = persPersonId;
        return this;
    }

    public ParkPersonItem setPersPersonPin(String persPersonPin) {
        this.persPersonPin = persPersonPin;
        return this;
    }

    public ParkPersonItem setPersPersonName(String persPersonName) {
        this.persPersonName = persPersonName;
        return this;
    }

    public ParkPersonItem setPersPersonLastName(String persPersonLastName) {
        this.persPersonLastName = persPersonLastName;
        return this;
    }

    public ParkPersonItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public ParkPersonItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public ParkPersonItem setNotInPersonId(String notInPersonId) {
        this.notInPersonId = notInPersonId;
        return this;
    }

    public ParkPersonItem setCarNumber(String carNumber) {
        this.carNumber = carNumber;
        return this;
    }

    public ParkPersonItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public ParkPersonItem setDeptIdIn(String deptIdIn) {
        this.deptIdIn = deptIdIn;
        return this;
    }

    public ParkPersonItem setIdNotIn(String idNotIn) {
        this.idNotIn = idNotIn;
        return this;
    }

    public ParkPersonItem setPeopleType(Short peopleType) {
        this.peopleType = peopleType;
        return this;
    }

    public String toString() {
        return "ParkPersonItem(id=" + this.getId() + ", personId=" + this.getPersonId() + ", persPersonId=" + this.getPersPersonId() + ", persPersonPin=" + this.getPersPersonPin() + ", persPersonName=" + this.getPersPersonName() + ", persPersonLastName=" + this.getPersPersonLastName() + ", deptId=" + this.getDeptId() + ", deptName=" + this.getDeptName() + ", notInPersonId=" + this.getNotInPersonId() + ", carNumber=" + this.getCarNumber() + ", likeName=" + this.getLikeName() + ", deptIdIn=" + this.getDeptIdIn() + ", idNotIn=" + this.getIdNotIn() + ", peopleType=" + this.getPeopleType() + ")";
    }
}

