/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;
import java.util.List;
import java.util.Map;

@From(after="PARK_AUTHORIZE t LEFT JOIN PARK_CAR_TYPE type ON t.CAR_TYPE_ID = type.ID LEFT JOIN PARK_CAR_NUMBER car ON t.CAR_NUMBER_ID = car.ID LEFT JOIN PARK_PARKINGSPACE space ON t.PARKINGSPACE_ID = space.ID LEFT JOIN PARK_FIXED_CHARGE charge ON t.FIXED_CHARGE_ID = charge.ID LEFT JOIN PARK_PERSON pp ON pp.ID = t.PARK_PERSON_ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig
public class ParkSelectAuthorizeDelayItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Condition(value="t.ID", equalTag="not in")
    private String idNotIn;
    @Column(name="t.PARK_PERSON_ID")
    private String parkPersonId;
    @Column(name="pp.PERS_PERSON_ID")
    private String persPersonId;
    @Column(name="pp.PERS_PERSON_NAME")
    @GridColumn(label="pers_person_name", sortNo=1, width="120")
    private String personName;
    @Column(name="pp.PERS_PERSON_LASTNAME")
    @GridColumn(label="pers_person_lastName", sortNo=2, width="120", showExpression="#language!='zh_CN'")
    private String personLastName;
    @Condition(value="pp.AUTH_DEPT_ID")
    private String deptId;
    @Condition(value="pp.AUTH_DEPT_ID", equalTag="in")
    private String deptIdIn;
    @Column(name="car.ID")
    private String carNumberId;
    @Column(name="car.CAR_NUMBER")
    @GridColumn(label="park_carNumber", sortNo=3, width="120")
    private String carNumber;
    @Column(name="car.CARD_NO")
    private String cardNo;
    @Column(name="space.ID")
    private String parkingSpaceId;
    @Column(name="space.SPACE_NAME")
    @GridColumn(label="park_parkingSpace_spaceName", width="120")
    private String parkingSpaceName;
    @Column(name="t.END_TIME", equalTag="=")
    @DateType(type="date")
    @GridColumn(label="common_endTime", width="120")
    private Date endTime;
    @Column(name="t.END_TIME", equalTag="<=")
    @DateType(type="date")
    private Date endTimeLessEqual;
    @Column(name="t.END_TIME", equalTag=">=")
    @DateType(type="date")
    private Date endTimeGreaterEqual;
    @Column(name="type.ID")
    private String carTypeId;
    @Column(name="type.NAME")
    private String carTypeName;
    @Column(name="charge.ID")
    private String fixedChargeId;
    @Column(name="charge.NAME")
    private String fixedChargeName;
    @Condition(value="pp.ID IN (SELECT DISTINCT pp.ID FROM park_person pp,park_car_number car WHERE car.PERSON_ID = pp.ID AND car.car_number LIKE ''%{0}%'')")
    private String carNumberEx;
    @Condition(value="(pp.PERS_PERSON_NAME LIKE ''%{0}%'' OR pp.PERS_PERSON_LASTNAME LIKE ''%{0}%'')")
    private String likeName;
    @Column(name="t.STATUS")
    private Short status;
    private String type;
    private String selectId;
    List<Map<String, Object>> batchAuthorizeSelectMap;

    public ParkSelectAuthorizeDelayItem() {
    }

    public ParkSelectAuthorizeDelayItem(Boolean equals) {
        super(equals);
    }

    public ParkSelectAuthorizeDelayItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getIdNotIn() {
        return this.idNotIn;
    }

    public String getParkPersonId() {
        return this.parkPersonId;
    }

    public String getPersPersonId() {
        return this.persPersonId;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptIdIn() {
        return this.deptIdIn;
    }

    public String getCarNumberId() {
        return this.carNumberId;
    }

    public String getCarNumber() {
        return this.carNumber;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getParkingSpaceId() {
        return this.parkingSpaceId;
    }

    public String getParkingSpaceName() {
        return this.parkingSpaceName;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Date getEndTimeLessEqual() {
        return this.endTimeLessEqual;
    }

    public Date getEndTimeGreaterEqual() {
        return this.endTimeGreaterEqual;
    }

    public String getCarTypeId() {
        return this.carTypeId;
    }

    public String getCarTypeName() {
        return this.carTypeName;
    }

    public String getFixedChargeId() {
        return this.fixedChargeId;
    }

    public String getFixedChargeName() {
        return this.fixedChargeName;
    }

    public String getCarNumberEx() {
        return this.carNumberEx;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public Short getStatus() {
        return this.status;
    }

    public String getType() {
        return this.type;
    }

    public String getSelectId() {
        return this.selectId;
    }

    public List<Map<String, Object>> getBatchAuthorizeSelectMap() {
        return this.batchAuthorizeSelectMap;
    }

    public ParkSelectAuthorizeDelayItem setId(String id) {
        this.id = id;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setIdNotIn(String idNotIn) {
        this.idNotIn = idNotIn;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setParkPersonId(String parkPersonId) {
        this.parkPersonId = parkPersonId;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setPersPersonId(String persPersonId) {
        this.persPersonId = persPersonId;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setDeptIdIn(String deptIdIn) {
        this.deptIdIn = deptIdIn;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setCarNumberId(String carNumberId) {
        this.carNumberId = carNumberId;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setCarNumber(String carNumber) {
        this.carNumber = carNumber;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setParkingSpaceId(String parkingSpaceId) {
        this.parkingSpaceId = parkingSpaceId;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setParkingSpaceName(String parkingSpaceName) {
        this.parkingSpaceName = parkingSpaceName;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setEndTimeLessEqual(Date endTimeLessEqual) {
        this.endTimeLessEqual = endTimeLessEqual;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setEndTimeGreaterEqual(Date endTimeGreaterEqual) {
        this.endTimeGreaterEqual = endTimeGreaterEqual;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setCarTypeId(String carTypeId) {
        this.carTypeId = carTypeId;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setCarTypeName(String carTypeName) {
        this.carTypeName = carTypeName;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setFixedChargeId(String fixedChargeId) {
        this.fixedChargeId = fixedChargeId;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setFixedChargeName(String fixedChargeName) {
        this.fixedChargeName = fixedChargeName;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setCarNumberEx(String carNumberEx) {
        this.carNumberEx = carNumberEx;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setStatus(Short status) {
        this.status = status;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setType(String type) {
        this.type = type;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setSelectId(String selectId) {
        this.selectId = selectId;
        return this;
    }

    public ParkSelectAuthorizeDelayItem setBatchAuthorizeSelectMap(List<Map<String, Object>> batchAuthorizeSelectMap) {
        this.batchAuthorizeSelectMap = batchAuthorizeSelectMap;
        return this;
    }

    public String toString() {
        return "ParkSelectAuthorizeDelayItem(id=" + this.getId() + ", idNotIn=" + this.getIdNotIn() + ", parkPersonId=" + this.getParkPersonId() + ", persPersonId=" + this.getPersPersonId() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", deptId=" + this.getDeptId() + ", deptIdIn=" + this.getDeptIdIn() + ", carNumberId=" + this.getCarNumberId() + ", carNumber=" + this.getCarNumber() + ", cardNo=" + this.getCardNo() + ", parkingSpaceId=" + this.getParkingSpaceId() + ", parkingSpaceName=" + this.getParkingSpaceName() + ", endTime=" + this.getEndTime() + ", endTimeLessEqual=" + this.getEndTimeLessEqual() + ", endTimeGreaterEqual=" + this.getEndTimeGreaterEqual() + ", carTypeId=" + this.getCarTypeId() + ", carTypeName=" + this.getCarTypeName() + ", fixedChargeId=" + this.getFixedChargeId() + ", fixedChargeName=" + this.getFixedChargeName() + ", carNumberEx=" + this.getCarNumberEx() + ", likeName=" + this.getLikeName() + ", status=" + this.getStatus() + ", type=" + this.getType() + ", selectId=" + this.getSelectId() + ", batchAuthorizeSelectMap=" + this.getBatchAuthorizeSelectMap() + ")";
    }
}

