/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;

@From(after="AUTH_APP t LEFT JOIN AUTH_COMPANY c ON t.COMPANY_ID = c.ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, operates={@GridOperate(type="edit", permission="auth:app:edit", url="authApp.do?edit", label="common_op_edit")})
public class AuthAppItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="c.COMPANY_NAME")
    @GridColumn(label="auth_company_companyName", width="100")
    private String companyName;
    @Column(name="NAME")
    @GridColumn(label="auth_app_name", width="100")
    private String name;
    @Column(name="REMARK")
    private String remark;
    @Column(name="t.APPLICATION_ID")
    @GridColumn(label="auth_app_applicationId", width="220")
    private String applicationId;
    @Column(name="t.APP_KEY")
    @GridColumn(label="auth_app_appKey", width="220")
    private String appKey;
    @Column(name="t.APP_SECRET")
    @GridColumn(label="auth_app_appSecret", width="150")
    private String appSecret;
    @Column(name="t.LICENSE_ID")
    @GridColumn(label="auth_license_id", width="100")
    private String licenseId;
    @Column(name="t.AUTH_APP_TYPE")
    @GridColumn(label="auth_app_type", width="150")
    private String type;
    @Column(name="t.COMPANY_ID")
    private String companyId;
    @Column(name="t.STATUS")
    @GridColumn(label="auth_license_status", width="100", format="0=auth_license_period_nonActivated,1=auth_license_period_activated")
    private Integer status;
    @Condition(value="t.ID", equalTag="not in")
    private String notInId;
    @Condition(value="t.APPLICATION_ID", equalTag="in")
    private String inApplicationId;

    public AuthAppItem() {
    }

    public AuthAppItem(String id) {
        this.id = id;
    }

    public AuthAppItem setId(String id) {
        this.id = id;
        return this;
    }

    public AuthAppItem setCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    public AuthAppItem setName(String name) {
        this.name = name;
        return this;
    }

    public AuthAppItem setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public AuthAppItem setApplicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public AuthAppItem setAppKey(String appKey) {
        this.appKey = appKey;
        return this;
    }

    public AuthAppItem setAppSecret(String appSecret) {
        this.appSecret = appSecret;
        return this;
    }

    public AuthAppItem setLicenseId(String licenseId) {
        this.licenseId = licenseId;
        return this;
    }

    public AuthAppItem setType(String type) {
        this.type = type;
        return this;
    }

    public AuthAppItem setCompanyId(String companyId) {
        this.companyId = companyId;
        return this;
    }

    public AuthAppItem setStatus(Integer status) {
        this.status = status;
        return this;
    }

    public AuthAppItem setNotInId(String notInId) {
        this.notInId = notInId;
        return this;
    }

    public AuthAppItem setInApplicationId(String inApplicationId) {
        this.inApplicationId = inApplicationId;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getName() {
        return this.name;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getLicenseId() {
        return this.licenseId;
    }

    public String getType() {
        return this.type;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getNotInId() {
        return this.notInId;
    }

    public String getInApplicationId() {
        return this.inApplicationId;
    }
}

