/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerCallableStatement;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.SQLServerXADataSource;
import com.microsoft.sqlserver.jdbc.Util;
import com.microsoft.sqlserver.jdbc.XAReturnValue;
import com.microsoft.sqlserver.jdbc.XidImpl;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public final class SQLServerXAResource
implements XAResource {
    private SQLServerConnection con;
    private int timeoutSeconds;
    static final int XA_START = 0;
    static final int XA_END = 1;
    static final int XA_PREPARE = 2;
    static final int XA_COMMIT = 3;
    static final int XA_ROLLBACK = 4;
    static final int XA_FORGET = 5;
    static final int XA_RECOVER = 6;
    static final int XA_PREPARE_EX = 7;
    static final int XA_ROLLBACK_EX = 8;
    static final int XA_FORGET_EX = 9;
    static final int XA_INIT = 10;
    private SQLServerConnection controlConnection;
    private static boolean xaInitDone;
    private static Integer xaInitLock;
    private String sResourceManagerId;
    private int enlistedTransactionCount;
    private final Logger xaLogger;
    private static int baseResourceID;
    private int tightlyCoupled = 0;
    public static final int SSTRANSTIGHTLYCPLD = 32768;
    private SQLServerCallableStatement[] xaStatements = new SQLServerCallableStatement[]{null, null, null, null, null, null, null, null, null, null};
    private final String traceID = " XAResourceID:" + SQLServerXAResource.nextResourceID();

    public String toString() {
        return this.traceID;
    }

    SQLServerXAResource(SQLServerConnection sQLServerConnection, String string) {
        this.xaLogger = SQLServerXADataSource.xaLogger;
        this.con = sQLServerConnection;
        Properties properties = sQLServerConnection.activeConnectionProperties;
        this.sResourceManagerId = properties == null ? "" : properties.getProperty("serverName") + "." + properties.getProperty("databaseName") + "." + properties.getProperty("portNumber");
        if (this.xaLogger.isLoggable(Level.FINE)) {
            this.xaLogger.fine(this.toString() + " created by (" + string + ")");
        }
    }

    private synchronized SQLServerCallableStatement getXACallableStatementHandle(int n2) throws SQLServerException {
        assert (n2 >= 0 && n2 <= 9);
        assert (n2 < this.xaStatements.length);
        if (null != this.xaStatements[n2]) {
            return this.xaStatements[n2];
        }
        CallableStatement callableStatement = null;
        switch (n2) {
            case 0: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_start(?, ?, ?, ?, ?, ?, ?)}");
                break;
            }
            case 1: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_end(?, ?, ?, ?, ?)}");
                break;
            }
            case 2: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_prepare(?, ?, ?, ?)}");
                break;
            }
            case 3: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_commit(?, ?, ?, ?, ?)}");
                break;
            }
            case 4: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_rollback(?, ?, ?, ?)}");
                break;
            }
            case 5: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_forget(?, ?, ?, ?)}");
                break;
            }
            case 6: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_recover(?, ?, ?, ?)}");
                break;
            }
            case 7: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_prepare_ex(?, ?, ?, ?,?)}");
                break;
            }
            case 8: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_rollback_ex(?, ?, ?, ?, ?)}");
                break;
            }
            case 9: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_forget_ex(?, ?, ?, ?, ?)}");
                break;
            }
            default: {
                assert (false) : "Bad handle request:" + n2;
                break;
            }
        }
        this.xaStatements[n2] = (SQLServerCallableStatement)callableStatement;
        return this.xaStatements[n2];
    }

    private synchronized void closeXAStatements() throws SQLServerException {
        for (int i2 = 0; i2 < this.xaStatements.length; ++i2) {
            if (null == this.xaStatements[i2]) continue;
            this.xaStatements[i2].close();
            this.xaStatements[i2] = null;
        }
    }

    final synchronized void close() throws SQLServerException {
        block3: {
            try {
                this.closeXAStatements();
            }
            catch (Exception exception) {
                if (!this.xaLogger.isLoggable(Level.WARNING)) break block3;
                this.xaLogger.warning(this.toString() + "Closing exception ignored: " + exception);
            }
        }
        if (null != this.controlConnection) {
            this.controlConnection.close();
        }
    }

    private String flagsDisplay(int n2) {
        if (0 == n2) {
            return "TMNOFLAGS";
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        if (0 != (0x800000 & n2)) {
            stringBuilder.append("TMENDRSCAN");
        }
        if (0 != (0x20000000 & n2)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("TMFAIL");
        }
        if (0 != (0x200000 & n2)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("TMJOIN");
        }
        if (0 != (0x40000000 & n2)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("TMONEPHASE");
        }
        if (0 != (0x8000000 & n2)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("TMRESUME");
        }
        if (0 != (0x1000000 & n2)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("TMSTARTRSCAN");
        }
        if (0 != (0x4000000 & n2)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("TMSUCCESS");
        }
        if (0 != (0x2000000 & n2)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("TMSUSPEND");
        }
        if (0 != (0x8000 & n2)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("SSTRANSTIGHTLYCPLD");
        }
        return stringBuilder.toString();
    }

    private String cookieDisplay(byte[] byArray) {
        return Util.byteToHexDisplayString(byArray);
    }

    private String typeDisplay(int n2) {
        switch (n2) {
            case 0: {
                return "XA_START";
            }
            case 1: {
                return "XA_END";
            }
            case 2: {
                return "XA_PREPARE";
            }
            case 3: {
                return "XA_COMMIT";
            }
            case 4: {
                return "XA_ROLLBACK";
            }
            case 5: {
                return "XA_FORGET";
            }
            case 6: {
                return "XA_RECOVER";
            }
        }
        return "UNKNOWN" + n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final XAReturnValue DTC_XA_Interface(int n2, Xid xid, int n3) throws XAException {
        if (this.xaLogger.isLoggable(Level.FINER)) {
            this.xaLogger.finer(this.toString() + " Calling XA function for type:" + this.typeDisplay(n2) + " flags:" + this.flagsDisplay(n3) + " xid:" + XidImpl.xidDisplay(xid));
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (xid != null) {
            byArray = xid.getGlobalTransactionId();
            byArray2 = xid.getBranchQualifier();
        }
        String string = "DTC_XA_";
        int n4 = 1;
        int n5 = 0;
        XAReturnValue xAReturnValue = new XAReturnValue();
        SQLServerPreparedStatement sQLServerPreparedStatement = null;
        try {
            Object object;
            Object object2;
            Object[] objectArray;
            Object object3;
            Object object4 = this;
            synchronized (object4) {
                if (this.controlConnection == null) {
                    try {
                        object3 = (Properties)this.con.activeConnectionProperties.clone();
                        ((Properties)object3).setProperty("sendStringParametersAsUnicode", "true");
                        ((Properties)object3).remove("selectMethod");
                        if (this.xaLogger.isLoggable(Level.FINER)) {
                            this.xaLogger.finer("Creating an internal control connection for" + this.toString() + " xid:" + XidImpl.xidDisplay(xid));
                        }
                        objectArray = new SQLServerConnection(this.toString());
                        objectArray.connect((Properties)object3, null);
                        if (this.xaLogger.isLoggable(Level.FINER)) {
                            this.xaLogger.finer("Created an internal control connection" + objectArray.toString() + " for " + this.toString() + " xid:" + XidImpl.xidDisplay(xid));
                        }
                        object2 = xaInitLock;
                        synchronized (object2) {
                            if (!xaInitDone) {
                                object = null;
                                object = (SQLServerCallableStatement)objectArray.prepareCall("{call master..xp_sqljdbc_xa_init_ex(?, ?,?)}");
                                ((SQLServerCallableStatement)object).registerOutParameter(1, 4);
                                ((SQLServerCallableStatement)object).registerOutParameter(2, 1);
                                ((SQLServerCallableStatement)object).registerOutParameter(3, 1);
                                try {
                                    ((SQLServerPreparedStatement)object).execute();
                                }
                                catch (SQLServerException sQLServerException) {
                                    block60: {
                                        try {
                                            ((SQLServerStatement)object).close();
                                            objectArray.close();
                                        }
                                        catch (SQLException sQLException) {
                                            if (!this.xaLogger.isLoggable(Level.FINER)) break block60;
                                            this.xaLogger.finer(this.toString() + " Ignoring exception when closing failed execution. exception:" + sQLException);
                                        }
                                    }
                                    if (this.xaLogger.isLoggable(Level.FINER)) {
                                        this.xaLogger.finer(this.toString() + " exception:" + sQLServerException);
                                    }
                                    throw sQLServerException;
                                }
                                int n6 = ((SQLServerCallableStatement)object).getInt(1);
                                String string2 = ((SQLServerCallableStatement)object).getString(2);
                                String string3 = ((SQLServerCallableStatement)object).getString(3);
                                if (this.xaLogger.isLoggable(Level.FINE)) {
                                    this.xaLogger.fine(this.toString() + " Server XA DLL version:" + string3);
                                }
                                ((SQLServerStatement)object).close();
                                if (0 != n6) {
                                    assert (null != string2 && string2.length() > 1);
                                    objectArray.close();
                                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_failedToInitializeXA"));
                                    Object[] objectArray2 = new Object[]{String.valueOf(n6), string2};
                                    XAException xAException = new XAException(messageFormat.format(objectArray2));
                                    xAException.errorCode = n6;
                                    if (this.xaLogger.isLoggable(Level.FINER)) {
                                        this.xaLogger.finer(this.toString() + " exception:" + xAException);
                                    }
                                    throw xAException;
                                }
                                xaInitDone = true;
                            }
                        }
                        this.controlConnection = objectArray;
                    }
                    catch (SQLServerException sQLServerException) {
                        objectArray = new MessageFormat(SQLServerException.getErrString("R_failedToCreateXAConnection"));
                        object2 = new Object[]{new String(sQLServerException.getMessage())};
                        if (this.xaLogger.isLoggable(Level.FINER)) {
                            this.xaLogger.finer(this.toString() + " exception:" + objectArray.format(object2));
                        }
                        SQLServerException.makeFromDriverError(null, null, objectArray.format(object2), null, true);
                    }
                }
            }
            switch (n2) {
                case 0: {
                    string = "START:";
                    sQLServerPreparedStatement = this.getXACallableStatementHandle(0);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 4);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 1);
                    sQLServerPreparedStatement.setBytes(n4++, byArray);
                    sQLServerPreparedStatement.setBytes(n4++, byArray2);
                    sQLServerPreparedStatement.setInt(n4++, n3);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, -2);
                    sQLServerPreparedStatement.setInt(n4++, this.timeoutSeconds);
                    break;
                }
                case 1: {
                    string = "END:";
                    sQLServerPreparedStatement = this.getXACallableStatementHandle(1);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 4);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 1);
                    sQLServerPreparedStatement.setBytes(n4++, byArray);
                    sQLServerPreparedStatement.setBytes(n4++, byArray2);
                    sQLServerPreparedStatement.setInt(n4++, n3);
                    break;
                }
                case 2: {
                    string = "PREPARE:";
                    sQLServerPreparedStatement = (0x8000 & n3) == 32768 ? this.getXACallableStatementHandle(7) : this.getXACallableStatementHandle(2);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 4);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 1);
                    sQLServerPreparedStatement.setBytes(n4++, byArray);
                    sQLServerPreparedStatement.setBytes(n4++, byArray2);
                    if ((0x8000 & n3) != 32768) break;
                    sQLServerPreparedStatement.setInt(n4++, n3);
                    break;
                }
                case 3: {
                    string = "COMMIT:";
                    sQLServerPreparedStatement = this.getXACallableStatementHandle(3);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 4);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 1);
                    sQLServerPreparedStatement.setBytes(n4++, byArray);
                    sQLServerPreparedStatement.setBytes(n4++, byArray2);
                    sQLServerPreparedStatement.setInt(n4++, n3);
                    break;
                }
                case 4: {
                    string = "ROLLBACK:";
                    sQLServerPreparedStatement = (0x8000 & n3) == 32768 ? this.getXACallableStatementHandle(8) : this.getXACallableStatementHandle(4);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 4);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 1);
                    sQLServerPreparedStatement.setBytes(n4++, byArray);
                    sQLServerPreparedStatement.setBytes(n4++, byArray2);
                    if ((0x8000 & n3) != 32768) break;
                    sQLServerPreparedStatement.setInt(n4++, n3);
                    break;
                }
                case 5: {
                    string = "FORGET:";
                    sQLServerPreparedStatement = (0x8000 & n3) == 32768 ? this.getXACallableStatementHandle(9) : this.getXACallableStatementHandle(5);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 4);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 1);
                    sQLServerPreparedStatement.setBytes(n4++, byArray);
                    sQLServerPreparedStatement.setBytes(n4++, byArray2);
                    if ((0x8000 & n3) != 32768) break;
                    sQLServerPreparedStatement.setInt(n4++, n3);
                    break;
                }
                case 6: {
                    string = "RECOVER:";
                    sQLServerPreparedStatement = this.getXACallableStatementHandle(6);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 4);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 1);
                    sQLServerPreparedStatement.setInt(n4++, n3);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, -2);
                    break;
                }
                default: {
                    assert (false) : "Unknown execution type:" + n2;
                    break;
                }
            }
            sQLServerPreparedStatement.execute();
            n5 = ((SQLServerCallableStatement)sQLServerPreparedStatement).getInt(1);
            object4 = ((SQLServerCallableStatement)sQLServerPreparedStatement).getString(2);
            if (3 == n5 && 1 != n2 && 2 != n2 || 0 != n5 && 3 != n5) {
                block61: {
                    assert (null != object4 && ((String)object4).length() > 1);
                    object3 = new MessageFormat(SQLServerException.getErrString("R_failedFunctionXA"));
                    objectArray = new Object[]{string, String.valueOf(n5), object4};
                    object2 = new XAException(((Format)object3).format(objectArray));
                    ((XAException)object2).errorCode = n5;
                    if (n2 == 1 && -7 == n5) {
                        try {
                            if (this.xaLogger.isLoggable(Level.FINER)) {
                                this.xaLogger.finer(this.toString() + " Begin un-enlist, enlisted count:" + this.enlistedTransactionCount);
                            }
                            this.con.JTAUnenlistConnection();
                            --this.enlistedTransactionCount;
                            if (this.xaLogger.isLoggable(Level.FINER)) {
                                this.xaLogger.finer(this.toString() + " End un-enlist, enlisted count:" + this.enlistedTransactionCount);
                            }
                        }
                        catch (SQLServerException sQLServerException) {
                            if (!this.xaLogger.isLoggable(Level.FINER)) break block61;
                            this.xaLogger.finer(this.toString() + " Ignoring exception:" + sQLServerException);
                        }
                    }
                }
                throw object2;
            }
            if (n2 == 0) {
                object3 = ((SQLServerCallableStatement)sQLServerPreparedStatement).getBytes(6);
                if (object3 == null) {
                    objectArray = new MessageFormat(SQLServerException.getErrString("R_noTransactionCookie"));
                    object2 = new Object[]{string};
                    SQLServerException.makeFromDriverError(null, null, objectArray.format(object2), null, true);
                } else {
                    try {
                        if (this.xaLogger.isLoggable(Level.FINER)) {
                            this.xaLogger.finer(this.toString() + " Begin enlisting, cookie:" + this.cookieDisplay((byte[])object3) + " enlisted count:" + this.enlistedTransactionCount);
                        }
                        this.con.JTAEnlistConnection((byte[])object3);
                        ++this.enlistedTransactionCount;
                        if (this.xaLogger.isLoggable(Level.FINER)) {
                            this.xaLogger.finer(this.toString() + " End enlisting, cookie:" + this.cookieDisplay((byte[])object3) + " enlisted count:" + this.enlistedTransactionCount);
                        }
                    }
                    catch (SQLServerException sQLServerException) {
                        object2 = new MessageFormat(SQLServerException.getErrString("R_failedToEnlist"));
                        object = new Object[]{sQLServerException.getMessage()};
                        SQLServerException.makeFromDriverError(null, null, ((Format)object2).format(object), null, true);
                    }
                }
            }
            if (n2 == 1) {
                try {
                    if (this.xaLogger.isLoggable(Level.FINER)) {
                        this.xaLogger.finer(this.toString() + " Begin un-enlist, enlisted count:" + this.enlistedTransactionCount);
                    }
                    this.con.JTAUnenlistConnection();
                    --this.enlistedTransactionCount;
                    if (this.xaLogger.isLoggable(Level.FINER)) {
                        this.xaLogger.finer(this.toString() + " End un-enlist, enlisted count:" + this.enlistedTransactionCount);
                    }
                }
                catch (SQLServerException sQLServerException) {
                    objectArray = new MessageFormat(SQLServerException.getErrString("R_failedToUnEnlist"));
                    object2 = new Object[]{sQLServerException.getMessage()};
                    SQLServerException.makeFromDriverError(null, null, objectArray.format(object2), null, true);
                }
            }
            if (n2 == 6) {
                try {
                    xAReturnValue.bData = ((SQLServerCallableStatement)sQLServerPreparedStatement).getBytes(4);
                }
                catch (SQLServerException sQLServerException) {
                    objectArray = new MessageFormat(SQLServerException.getErrString("R_failedToReadRecoveryXIDs"));
                    object2 = new Object[]{sQLServerException.getMessage()};
                    SQLServerException.makeFromDriverError(null, null, objectArray.format(object2), null, true);
                }
            }
        }
        catch (SQLServerException sQLServerException) {
            if (this.xaLogger.isLoggable(Level.FINER)) {
                this.xaLogger.finer(this.toString() + " exception:" + sQLServerException);
            }
            XAException xAException = new XAException(sQLServerException.toString());
            xAException.errorCode = -3;
            throw xAException;
        }
        if (this.xaLogger.isLoggable(Level.FINER)) {
            this.xaLogger.finer(this.toString() + " Status:" + n5);
        }
        xAReturnValue.nStatus = n5;
        return xAReturnValue;
    }

    @Override
    public void start(Xid xid, int n2) throws XAException {
        this.tightlyCoupled = n2 & 0x8000;
        this.DTC_XA_Interface(0, xid, n2);
    }

    @Override
    public void end(Xid xid, int n2) throws XAException {
        this.DTC_XA_Interface(1, xid, n2 | this.tightlyCoupled);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        int n2 = 0;
        XAReturnValue xAReturnValue = this.DTC_XA_Interface(2, xid, this.tightlyCoupled);
        n2 = xAReturnValue.nStatus;
        return n2;
    }

    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        this.DTC_XA_Interface(3, xid, (bl ? 0x40000000 : 0) | this.tightlyCoupled);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.DTC_XA_Interface(4, xid, this.tightlyCoupled);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.DTC_XA_Interface(5, xid, this.tightlyCoupled);
    }

    @Override
    public Xid[] recover(int n2) throws XAException {
        int n3;
        int n4;
        XAReturnValue xAReturnValue = this.DTC_XA_Interface(6, null, n2 | this.tightlyCoupled);
        Vector<XidImpl> vector = new Vector<XidImpl>();
        if (null == xAReturnValue.bData) {
            return new XidImpl[0];
        }
        for (int i2 = 0; i2 < xAReturnValue.bData.length; i2 += n4) {
            int n5;
            int n6 = 1;
            n3 = 0;
            for (n5 = 0; n5 < 4; ++n5) {
                n4 = xAReturnValue.bData[i2 + n5] & 0xFF;
                n3 += (n4 *= n6);
                n6 *= 256;
            }
            i2 += 4;
            n5 = xAReturnValue.bData[i2++] & 0xFF;
            n4 = xAReturnValue.bData[i2++] & 0xFF;
            byte[] byArray = new byte[n5];
            byte[] byArray2 = new byte[n4];
            System.arraycopy(xAReturnValue.bData, i2, byArray, 0, n5);
            System.arraycopy(xAReturnValue.bData, i2 += n5, byArray2, 0, n4);
            XidImpl xidImpl = new XidImpl(n3, byArray, byArray2);
            vector.add(xidImpl);
        }
        Xid[] xidArray = new XidImpl[vector.size()];
        for (n3 = 0; n3 < vector.size(); ++n3) {
            xidArray[n3] = (XidImpl)vector.elementAt(n3);
            if (!this.xaLogger.isLoggable(Level.FINER)) continue;
            this.xaLogger.finer(this.toString() + ((XidImpl)xidArray[n3]).toString());
        }
        return xidArray;
    }

    @Override
    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (this.xaLogger.isLoggable(Level.FINER)) {
            this.xaLogger.finer(this.toString() + " xares:" + xAResource);
        }
        if (!(xAResource instanceof SQLServerXAResource)) {
            return false;
        }
        SQLServerXAResource sQLServerXAResource = (SQLServerXAResource)xAResource;
        return sQLServerXAResource.sResourceManagerId.equals(this.sResourceManagerId);
    }

    @Override
    public boolean setTransactionTimeout(int n2) throws XAException {
        this.timeoutSeconds = n2;
        if (this.xaLogger.isLoggable(Level.FINER)) {
            this.xaLogger.finer(this.toString() + " TransactionTimeout:" + n2);
        }
        return true;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.timeoutSeconds;
    }

    private static synchronized int nextResourceID() {
        return ++baseResourceID;
    }

    static {
        baseResourceID = 0;
        xaInitLock = new Integer(0);
    }
}

