/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CSocketInputStreamWrapper;
import oracle.jdbc.driver.T4CSocketOutputStreamWrapper;
import oracle.jdbc.driver.T4CTypeRep;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;

class T4CMAREngineStream
extends T4CMAREngine {
    NetInputStream inStream;
    NetOutputStream outStream;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:09:24_PDT_2013";
    public static final boolean TRACE = false;

    T4CMAREngineStream(Communication communication) throws SQLException, IOException {
        if (communication == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 433);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.net = communication;
        try {
            this.outStream = new T4CSocketOutputStreamWrapper((NetOutputStream)communication.getOutputStream());
            this.inStream = new T4CSocketInputStreamWrapper((NetInputStream)communication.getInputStream(), (T4CSocketOutputStreamWrapper)this.outStream);
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        this.types = new T4CTypeRep(this, false);
        this.types.setRep((byte)1, (byte)2);
    }

    void initBuffers() {
    }

    @Override
    final void marshalSB1(byte by) throws IOException {
        this.marshalSB2(by);
    }

    @Override
    final void marshalUB1(short s2) throws IOException {
        this.outStream.write((byte)(s2 & 0xFF));
    }

    @Override
    final void marshalSB2(short s2) throws IOException {
        byte by = this.value2Buffer(s2, this.tmpBuffer2, (byte)1);
        if (by != 0) {
            this.outStream.write(this.tmpBuffer2, 0, by);
        }
    }

    @Override
    final void marshalUB2(int n2) throws IOException {
        this.marshalSB2((short)(n2 & 0xFFFF));
    }

    @Override
    final void marshalSB4(int n2) throws IOException {
        byte by = this.value2Buffer(n2, this.tmpBuffer4, (byte)2);
        if (by != 0) {
            this.outStream.write(this.tmpBuffer4, 0, by);
        }
    }

    @Override
    final void marshalUB4(long l2) throws IOException {
        this.marshalSB4((int)(l2 & 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    final void marshalSB8(long l2) throws IOException {
        byte by = this.value2Buffer(l2, this.tmpBuffer8, (byte)3);
        if (by != 0) {
            this.outStream.write(this.tmpBuffer8, 0, by);
        }
    }

    @Override
    final void marshalB1Array(byte[] byArray) throws IOException {
        if (byArray.length > 0) {
            this.outStream.write(byArray);
        }
    }

    @Override
    final void marshalB1Array(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray.length > 0) {
            this.outStream.write(byArray, n2, n3);
        }
    }

    final byte value2Buffer(int n2, byte[] byArray, byte by) throws IOException {
        boolean bl = (this.types.rep[by] & 1) > 0;
        boolean bl2 = true;
        byte by2 = 0;
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            byArray[by2] = (byte)(n2 >>> 8 * i2 & 0xFF);
            if (bl) {
                if (bl2 && byArray[by2] == 0) continue;
                bl2 = false;
                by2 = (byte)(by2 + 1);
                continue;
            }
            by2 = (byte)(by2 + 1);
        }
        if (bl) {
            this.outStream.write(by2);
        }
        if ((this.types.rep[by] & 2) > 0) {
            this.reverseArray(byArray, by2);
        }
        return by2;
    }

    final byte value2Buffer(long l2, byte[] byArray, byte by) throws IOException {
        boolean bl = (this.types.rep[by] & 1) > 0;
        boolean bl2 = true;
        byte by2 = 0;
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            byArray[by2] = (byte)(l2 >>> 8 * i2 & 0xFFL);
            if (bl) {
                if (bl2 && byArray[by2] == 0) continue;
                bl2 = false;
                by2 = (byte)(by2 + 1);
                continue;
            }
            by2 = (byte)(by2 + 1);
        }
        if (bl) {
            this.outStream.write(by2);
        }
        if ((this.types.rep[by] & 2) > 0) {
            this.reverseArray(byArray, by2);
        }
        return by2;
    }

    final void reverseArray(byte[] byArray, byte by) {
        int n2 = by / 2;
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by2 = byArray[i2];
            byArray[i2] = byArray[by - 1 - i2];
            byArray[by - 1 - i2] = by2;
        }
    }

    @Override
    final byte unmarshalSB1() throws SQLException, IOException {
        byte by = (byte)this.unmarshalSB2();
        return by;
    }

    @Override
    final short unmarshalUB1() throws SQLException, IOException {
        short s2 = 0;
        try {
            s2 = (short)this.inStream.read();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
            throw socketTimeoutException;
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        if (s2 < 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return s2;
    }

    @Override
    final short unmarshalSB2() throws SQLException, IOException {
        short s2 = (short)this.unmarshalUB2();
        return s2;
    }

    @Override
    final int unmarshalUB2() throws SQLException, IOException {
        int n2 = (int)this.buffer2Value((byte)1);
        return n2 & 0xFFFF;
    }

    @Override
    final int unmarshalSB4() throws SQLException, IOException {
        int n2 = (int)this.unmarshalUB4();
        return n2;
    }

    @Override
    final long unmarshalUB4() throws SQLException, IOException {
        long l2 = this.buffer2Value((byte)2);
        return l2;
    }

    @Override
    byte[] unmarshalNBytes(int n2) throws SQLException, IOException {
        byte[] byArray = new byte[n2];
        if (n2 > 0) {
            try {
                if (this.inStream.read(byArray) < 0) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
                throw socketTimeoutException;
            }
            catch (BreakNetException breakNetException) {
                this.net.sendReset();
                throw breakNetException;
            }
        }
        return byArray;
    }

    @Override
    int unmarshalNBytes(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        int n4;
        if (n2 + n3 > byArray.length) {
            n3 = byArray.length - n2;
        }
        for (n4 = 0; n4 < n3; n4 += this.getNBytes(byArray, n2 + n4, n3 - n4)) {
        }
        return n4;
    }

    @Override
    int getNBytes(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        if (n2 + n3 > byArray.length) {
            n3 = byArray.length - n2;
        }
        int n4 = 0;
        try {
            n4 = this.inStream.read(byArray, n2, n3);
            if (n4 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
            throw socketTimeoutException;
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        return n4;
    }

    @Override
    byte[] getNBytes(int n2) throws SQLException, IOException {
        byte[] byArray = new byte[n2];
        try {
            if (this.inStream.read(byArray) < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
            throw socketTimeoutException;
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        return byArray;
    }

    @Override
    byte[] unmarshalTEXT(int n2) throws SQLException, IOException {
        byte[] byArray;
        int n3 = 0;
        byte[] byArray2 = new byte[n2];
        while (n3 < n2) {
            try {
                if (this.inStream.read(byArray2, n3, 1) < 0) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
                throw socketTimeoutException;
            }
            catch (BreakNetException breakNetException) {
                this.net.sendReset();
                throw breakNetException;
            }
            if (byArray2[n3++] != 0) continue;
        }
        if (byArray2.length == --n3) {
            byArray = byArray2;
        } else {
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
        }
        return byArray;
    }

    @Override
    final long buffer2Value(byte by) throws SQLException, IOException {
        try {
            long l2 = 0L;
            int n2 = 1;
            if ((this.types.rep[by] & 1) > 0) {
                n2 = this.inStream.readB1();
            } else {
                switch (by) {
                    case 1: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 4;
                        break;
                    }
                    case 3: {
                        n2 = 8;
                    }
                }
            }
            l2 = (this.types.rep[by] & 2) > 0 ? this.inStream.readLongLSB(n2) : this.inStream.readLongMSB(n2);
            return l2;
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
            throw socketTimeoutException;
        }
    }

    @Override
    void setByteOrder(byte by) throws IOException {
    }

    @Override
    protected void flush() throws IOException {
        ((T4CSocketOutputStreamWrapper)this.outStream).flush(true);
    }

    @Override
    void writeZeroCopyIO(byte[] byArray, int n2, int n3) throws IOException, NetException {
        this.outStream.flush();
        this.outStream.writeZeroCopyIO(byArray, n2, n3);
    }
}

