/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.postgresql.core.Logger;
import org.postgresql.jdbc4.Jdbc4Connection;
import org.postgresql.util.GT;
import org.postgresql.util.HostSpec;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class Driver
implements java.sql.Driver {
    public static final int DEBUG = 2;
    public static final int INFO = 1;
    private static final Logger logger = new Logger();
    private static boolean logLevelSet = false;
    private static Timer cancelTimer = null;
    private Properties defaultProperties;
    private static final Object[][] knownProperties;
    public static final int MAJORVERSION = 9;
    public static final int MINORVERSION = 2;
    private static String[] protocols;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Properties getDefaultProperties() throws IOException {
        if (this.defaultProperties != null) {
            return this.defaultProperties;
        }
        try {
            this.defaultProperties = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return Driver.this.loadDefaultProperties();
                }
            });
        }
        catch (PrivilegedActionException e2) {
            throw (IOException)e2.getException();
        }
        Class<Driver> clazz = Driver.class;
        synchronized (Driver.class) {
            String driverLogLevel;
            if (!logLevelSet && (driverLogLevel = this.defaultProperties.getProperty("loglevel")) != null) {
                try {
                    Driver.setLogLevel(Integer.parseInt(driverLogLevel));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return this.defaultProperties;
        }
    }

    private Properties loadDefaultProperties() throws IOException {
        Properties merged = new Properties();
        try {
            merged.setProperty("user", System.getProperty("user.name"));
        }
        catch (SecurityException se) {
            // empty catch block
        }
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl == null) {
            logger.debug("Can't find a classloader for the Driver; not loading driver configuration");
            return merged;
        }
        logger.debug("Loading driver configuration via classloader " + cl);
        ArrayList<URL> urls = new ArrayList<URL>();
        Enumeration<URL> urlEnum = cl.getResources("org/postgresql/driverconfig.properties");
        while (urlEnum.hasMoreElements()) {
            urls.add(urlEnum.nextElement());
        }
        for (int i2 = urls.size() - 1; i2 >= 0; --i2) {
            URL url = (URL)urls.get(i2);
            logger.debug("Loading driver configuration from: " + url);
            InputStream is = url.openStream();
            merged.load(is);
            is.close();
        }
        return merged;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Properties defaults;
        try {
            defaults = this.getDefaultProperties();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Error loading default settings from driverconfig.properties"), PSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
        Properties props = new Properties(defaults);
        Enumeration<?> e2 = info.propertyNames();
        while (e2.hasMoreElements()) {
            String propName = (String)e2.nextElement();
            props.setProperty(propName, info.getProperty(propName));
        }
        if ((props = this.parseURL(url, props)) == null) {
            logger.debug("Error in url: " + url);
            return null;
        }
        try {
            logger.debug("Connecting with URL: " + url);
            long timeout = Driver.timeout(props);
            if (timeout <= 0L) {
                return Driver.makeConnection(url, props);
            }
            ConnectThread ct = new ConnectThread(url, props);
            new Thread((Runnable)ct, "PostgreSQL JDBC driver connection thread").start();
            return ct.getResult(timeout);
        }
        catch (PSQLException ex1) {
            logger.debug("Connection error:", ex1);
            throw ex1;
        }
        catch (AccessControlException ace) {
            throw new PSQLException(GT.tr("Your security policy has prevented the connection from being attempted.  You probably need to grant the connect java.net.SocketPermission to the database server host and port that you wish to connect to."), PSQLState.UNEXPECTED_ERROR, (Throwable)ace);
        }
        catch (Exception ex2) {
            logger.debug("Unexpected connection error:", ex2);
            throw new PSQLException(GT.tr("Something unusual has occurred to cause the driver to fail. Please report this exception."), PSQLState.UNEXPECTED_ERROR, (Throwable)ex2);
        }
    }

    private static Connection makeConnection(String url, Properties props) throws SQLException {
        return new Jdbc4Connection(Driver.hostSpecs(props), Driver.user(props), Driver.database(props), props, url);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return this.parseURL(url, null) != null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Properties copy = new Properties(info);
        this.parseURL(url, copy);
        DriverPropertyInfo[] props = new DriverPropertyInfo[knownProperties.length];
        for (int i2 = 0; i2 < knownProperties.length; ++i2) {
            String name = (String)knownProperties[i2][0];
            props[i2] = new DriverPropertyInfo(name, copy.getProperty(name));
            props[i2].required = (Boolean)knownProperties[i2][1];
            props[i2].description = (String)knownProperties[i2][2];
            if (knownProperties[i2].length <= 3) continue;
            props[i2].choices = (String[])knownProperties[i2][3];
        }
        return props;
    }

    @Override
    public int getMajorVersion() {
        return 9;
    }

    @Override
    public int getMinorVersion() {
        return 2;
    }

    public static String getVersion() {
        return "PostgreSQL 9.2 JDBC4.1 (build 1004)";
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    Properties parseURL(String url, Properties defaults) throws SQLException {
        Properties urlProps = new Properties(defaults);
        String l_urlServer = url;
        String l_urlArgs = "";
        int l_qPos = url.indexOf(63);
        if (l_qPos != -1) {
            l_urlServer = url.substring(0, l_qPos);
            l_urlArgs = url.substring(l_qPos + 1);
        }
        if (!l_urlServer.startsWith("jdbc:postgresql:")) {
            return null;
        }
        if ((l_urlServer = l_urlServer.substring("jdbc:postgresql:".length())).startsWith("//")) {
            int slash = (l_urlServer = l_urlServer.substring(2)).indexOf(47);
            if (slash == -1) {
                return null;
            }
            urlProps.setProperty("PGDBNAME", l_urlServer.substring(slash + 1));
            String[] addresses = l_urlServer.substring(0, slash).split(",");
            StringBuffer hosts = new StringBuffer();
            StringBuffer ports = new StringBuffer();
            for (int addr = 0; addr < addresses.length; ++addr) {
                String address = addresses[addr];
                int portIdx = address.lastIndexOf(58);
                if (portIdx != -1 && address.lastIndexOf(93) < portIdx) {
                    String portStr = address.substring(portIdx + 1);
                    try {
                        Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException ex) {
                        return null;
                    }
                    ports.append(portStr);
                    hosts.append(address.subSequence(0, portIdx));
                } else {
                    ports.append("5432");
                    hosts.append(address);
                }
                ports.append(',');
                hosts.append(',');
            }
            ports.setLength(ports.length() - 1);
            hosts.setLength(hosts.length() - 1);
            urlProps.setProperty("PGPORT", ports.toString());
            urlProps.setProperty("PGHOST", hosts.toString());
        } else {
            urlProps.setProperty("PGPORT", "5432");
            urlProps.setProperty("PGHOST", "localhost");
            urlProps.setProperty("PGDBNAME", l_urlServer);
        }
        String[] args = l_urlArgs.split("&");
        for (int i2 = 0; i2 < args.length; ++i2) {
            String token = args[i2];
            if (token.length() == 0) continue;
            int l_pos = token.indexOf(61);
            if (l_pos == -1) {
                urlProps.setProperty(token, "");
                continue;
            }
            urlProps.setProperty(token.substring(0, l_pos), token.substring(l_pos + 1));
        }
        return urlProps;
    }

    private static HostSpec[] hostSpecs(Properties props) {
        String[] hosts = props.getProperty("PGHOST").split(",");
        String[] ports = props.getProperty("PGPORT").split(",");
        HostSpec[] hostSpecs = new HostSpec[hosts.length];
        for (int i2 = 0; i2 < hostSpecs.length; ++i2) {
            hostSpecs[i2] = new HostSpec(hosts[i2], Integer.parseInt(ports[i2]));
        }
        return hostSpecs;
    }

    private static String user(Properties props) {
        return props.getProperty("user", "");
    }

    private static String database(Properties props) {
        return props.getProperty("PGDBNAME", "");
    }

    private static long timeout(Properties props) {
        String timeout = props.getProperty("loginTimeout");
        if (timeout != null) {
            try {
                return (long)(Float.parseFloat(timeout) * 1000.0f);
            }
            catch (NumberFormatException e2) {
                logger.debug("Couldn't parse loginTimeout value: " + timeout);
            }
        }
        return DriverManager.getLoginTimeout() * 1000;
    }

    public static SQLFeatureNotSupportedException notImplemented(Class callClass, String functionName) {
        return new SQLFeatureNotSupportedException(GT.tr("Method {0} is not yet implemented.", callClass.getName() + "." + functionName), PSQLState.NOT_IMPLEMENTED.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogLevel(int logLevel) {
        Class<Driver> clazz = Driver.class;
        synchronized (Driver.class) {
            logger.setLogLevel(logLevel);
            logLevelSet = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLogLevel() {
        Class<Driver> clazz = Driver.class;
        synchronized (Driver.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return logger.getLogLevel();
        }
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw Driver.notImplemented(this.getClass(), "getParentLogger()");
    }

    public static synchronized void addTimerTask(TimerTask timerTask, long milliSeconds) {
        if (cancelTimer == null) {
            cancelTimer = new Timer(true);
        }
        cancelTimer.schedule(timerTask, milliSeconds);
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        knownProperties = new Object[][]{{"PGDBNAME", Boolean.TRUE, "Database name to connect to; may be specified directly in the JDBC URL."}, {"user", Boolean.TRUE, "Username to connect to the database as.", null}, {"PGHOST", Boolean.FALSE, "Hostname of the PostgreSQL server; may be specified directly in the JDBC URL."}, {"PGPORT", Boolean.FALSE, "Port number to connect to the PostgreSQL server on; may be specified directly in the JDBC URL."}, {"password", Boolean.FALSE, "Password to use when authenticating."}, {"protocolVersion", Boolean.FALSE, "Force use of a particular protocol version when connecting; if set, disables protocol version fallback."}, {"ssl", Boolean.FALSE, "Control use of SSL; any nonnull value causes SSL to be required."}, {"sslfactory", Boolean.FALSE, "Provide a SSLSocketFactory class when using SSL."}, {"sslfactoryarg", Boolean.FALSE, "Argument forwarded to constructor of SSLSocketFactory class."}, {"loglevel", Boolean.FALSE, "Control the driver's log verbosity: 0 is off, 1 is INFO, 2 is DEBUG.", new String[]{"0", "1", "2"}}, {"allowEncodingChanges", Boolean.FALSE, "Allow the user to change the client_encoding variable."}, {"logUnclosedConnections", Boolean.FALSE, "When connections that are not explicitly closed are garbage collected, log the stacktrace from the opening of the connection to trace the leak source."}, {"prepareThreshold", Boolean.FALSE, "Default statement prepare threshold (numeric)."}, {"binaryTransfer", Boolean.FALSE, "Use binary format for sending and receiving data if possible."}, {"binaryTransferEnable", Boolean.FALSE, "Comma separated list of types to enable binary transfer. Either OID numbers or names."}, {"binaryTransferDisable", Boolean.FALSE, "Comma separated list of types to disable binary transfer. Either OID numbers or names. Overrides values in the driver default set and values set with binaryTransferEnable."}, {"charSet", Boolean.FALSE, "When connecting to a pre-7.3 server, the database encoding to assume is in use."}, {"compatible", Boolean.FALSE, "Force compatibility of some features with an older version of the driver.", new String[]{"7.1", "7.2", "7.3", "7.4", "8.0", "8.1", "8.2"}}, {"loginTimeout", Boolean.FALSE, "The login timeout, in seconds; 0 means no timeout beyond the normal TCP connection timout."}, {"socketTimeout", Boolean.FALSE, "The timeout value for socket read operations, in seconds; 0 means no timeout."}, {"tcpKeepAlive", Boolean.FALSE, "Enable or disable TCP keep-alive probe."}, {"stringtype", Boolean.FALSE, "The type to bind String parameters as (usually 'varchar'; 'unspecified' allows implicit casting to other types)", new String[]{"varchar", "unspecified"}}, {"kerberosServerName", Boolean.FALSE, "The Kerberos service name to use when authenticating with GSSAPI.  This is equivalent to libpq's PGKRBSRVNAME environment variable."}, {"jaasApplicationName", Boolean.FALSE, "Specifies the name of the JAAS system or application login configuration."}};
        protocols = new String[]{"jdbc", "postgresql"};
    }

    private static class ConnectThread
    implements Runnable {
        private final String url;
        private final Properties props;
        private Connection result;
        private Throwable resultException;
        private boolean abandoned;

        ConnectThread(String url, Properties props) {
            this.url = url;
            this.props = props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Throwable error;
            Connection conn;
            try {
                conn = Driver.makeConnection(this.url, this.props);
                error = null;
            }
            catch (Throwable t2) {
                conn = null;
                error = t2;
            }
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                if (this.abandoned) {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException e2) {}
                    }
                } else {
                    this.result = conn;
                    this.resultException = error;
                    this.notify();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Connection getResult(long timeout) throws SQLException {
            long expiry = System.currentTimeMillis() + timeout;
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                while (this.result == null) {
                    if (this.resultException != null) {
                        if (this.resultException instanceof SQLException) {
                            this.resultException.fillInStackTrace();
                            throw (SQLException)this.resultException;
                        }
                        throw new PSQLException(GT.tr("Something unusual has occurred to cause the driver to fail. Please report this exception."), PSQLState.UNEXPECTED_ERROR, this.resultException);
                    }
                    long delay = expiry - System.currentTimeMillis();
                    if (delay <= 0L) {
                        this.abandoned = true;
                        throw new PSQLException(GT.tr("Connection attempt timed out."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    try {
                        this.wait(delay);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        this.abandoned = true;
                        throw new RuntimeException(GT.tr("Interrupted while attempting to connect."));
                    }
                }
                return this.result;
            }
        }
    }
}

