/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.park.remote.ParkChannelRemote;
import com.zkteco.zkbiosecurity.park.service.ParkChannelService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.utils.ParkGetLocalIpAddrUtil;
import com.zkteco.zkbiosecurity.park.utils.ParkI18nUtil;
import com.zkteco.zkbiosecurity.park.vo.ParkChannelItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkChannelController
extends BaseController
implements ParkChannelRemote {
    @Autowired
    private ParkChannelService parkChannelService;
    @Autowired
    private ParkParamsService parkParamsService;
    @Value(value="${cloud.server.url:}")
    private String cloudServerUrl;
    @Autowired(required=false)
    private BaseLicenseService baseLicenseService;

    @RequiresPermissions(value={"park:channel"})
    public ModelAndView index() {
        if ("lprCamera".equals(this.parkParamsService.getRunMode())) {
            return new ModelAndView("park/channel/parkChannel");
        }
        return new ModelAndView("park/channel/parkChannelAccModel");
    }

    @RequiresPermissions(value={"park:channel:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        this.request.setAttribute("item", (Object)this.parkChannelService.getItemById(id));
        return new ModelAndView("park/channel/editParkChannel");
    }

    @RequiresPermissions(value={"park:channel:edit"})
    @LogRequest(module="park_module", object="park_channel", opType="park_channel_edit", requestParams={"name"}, opContent="park_channel_name")
    public ZKResultMsg save(ParkChannelItem item) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemtList = this.parkChannelService.saveItem(item);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemtList));
        return res;
    }

    @RequiresPermissions(value={"park:channel:refresh"})
    public DxGrid list(ParkChannelItem codition) {
        Pager pager = this.parkChannelService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="park_module", object="park_channel", opType="park_channel_del", requestParams={"names"}, opContent="park_channel_del")
    @RequiresPermissions(value={"park:channel:del"})
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkChannelService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isNotExist(String name) {
        return this.parkChannelService.isNotExist(name);
    }

    public ZKResultMsg getChannelByIpAddress() {
        List parkChannelItemList = this.parkChannelService.getByParkPavilioIp(ParkGetLocalIpAddrUtil.getClientIpAddr(this.request));
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        if (parkChannelItemList != null) {
            for (ParkChannelItem parkChannelItem : parkChannelItemList) {
                selectItems.add(new SelectItem((Object)parkChannelItem.getName(), parkChannelItem.getId() + "," + parkChannelItem.getState()));
            }
        }
        return new ZKResultMsg(selectItems);
    }

    public ModelAndView showLimitLineMode() {
        List parkChannelItemList = this.parkChannelService.getByPavilioIpAndLimit(ParkGetLocalIpAddrUtil.getClientIpAddr(this.request));
        this.request.setAttribute("parkChannelItemList", (Object)parkChannelItemList);
        return new ModelAndView("park/terminalManage/opParkLimitMode");
    }

    public ModelAndView showNormallyOpen() {
        List parkChannelItemList = this.parkChannelService.getByPavilioIpAndNormallyOpen(ParkGetLocalIpAddrUtil.getClientIpAddr(this.request));
        this.request.setAttribute("parkChannelItemList", (Object)parkChannelItemList);
        return new ModelAndView("park/terminalManage/opParkNormallyOpen");
    }

    public ZKResultMsg saveLimitLineMode(@RequestParam(value="openIds", required=false) String openIds, @RequestParam(value="closeIds", required=false) String closeIds) {
        this.parkChannelService.saveLimitLineMode(openIds, closeIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg saveNormallyOpen(@RequestParam(value="openIds", required=false) String openIds, @RequestParam(value="closeIds", required=false) String closeIds) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkChannelService.saveNormallyOpen(openIds, closeIds);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemList));
        return res;
    }

    public ZKResultMsg isExistCenterChannel() {
        boolean isExist = this.parkChannelService.isExistCenterChannel();
        return new ZKResultMsg((Object)isExist);
    }

    public ZKResultMsg getUnmannedQR(@RequestParam(value="parkChannelId") String parkChannelId) {
        ZKResultMsg res = new ZKResultMsg();
        if (this.parkParamsService.isUnmanned()) {
            String appId = this.baseLicenseService.getAppId();
            res.setMsg("");
            this.log.info(this.cloudServerUrl + "/BiosecurityPark/portal/pay?unmannedTransfer&appId=" + appId + "&parkChannelId=" + parkChannelId);
            res.setData((Object)(this.cloudServerUrl + "/BiosecurityPark/portal/pay?unmannedTransfer&appId=" + appId + "&parkChannelId=" + parkChannelId));
        } else {
            res.setMsg(I18nUtil.i18nCode((String)"park_parkingLotSet_enableUnmanned", (Object[])new Object[0]));
        }
        return res;
    }

    public ZKResultMsg getAllChannelByPavilioiId(@RequestParam(value="pavilioiId") String pavilioiId) {
        List selectItems = this.parkChannelService.getAllChannelByPavilioiId(pavilioiId);
        return new ZKResultMsg((Object)selectItems);
    }
}

