/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.client.service.impl;

import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.client.utils.ParkClientCommonUtil;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.park.bean.ParkCheckOutInfo;
import com.zkteco.zkbiosecurity.park.bean.ParkProcessParameter;
import com.zkteco.zkbiosecurity.park.bean.ParkWeChatCharge;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.service.ParkChannelService;
import com.zkteco.zkbiosecurity.park.service.ParkCloudService;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingMeterService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordoutService;
import com.zkteco.zkbiosecurity.park.service.ParkTempBillingService;
import com.zkteco.zkbiosecurity.park.vo.ParkChannelItem;
import com.zkteco.zkbiosecurity.park.vo.ParkDeviceItem;
import com.zkteco.zkbiosecurity.park.vo.ParkParkingMeterItem;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordinItem;
import com.zkteco.zkbiosecurity.park.vo.ParkTempBillingItem;
import java.sql.Timestamp;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParkUnattended {
    private static final Logger log = LoggerFactory.getLogger(ParkUnattended.class);
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkRecordinService parkRecordinService;
    @Autowired
    private ParkChannelService parkChannelService;
    @Autowired
    private ParkRecordoutService parkRecordoutService;
    @Autowired
    private ParkCloudService parkCloudService;
    @Autowired
    private ParkTempBillingService tempBillingService;
    @Autowired
    private ParkParkingMeterService parkingMeterService;
    @Autowired
    private ParkParamsService parkParamsService;
    private static final String UNLICENSEDCAR = "unlicensedCar";
    private static final String TEMPCARCHECKOUT = "tempCarCheckout";

    public ZKResultMsg unlicensedCheckin(ZKMessage msg) {
        String channelId = msg.getContent().get("channelId").toString();
        String license = msg.getContent().get("license").toString();
        if (this.parkParamsService.printParkLogger()) {
            log.info("PARK_ONLINE_PAY == Unlicensed Check In, ChannelId = " + channelId);
        }
        boolean isError = true;
        ParkChannelItem channelItem = this.parkChannelService.getItemById(channelId);
        ParkDeviceItem deviceItem = this.parkDeviceService.getByChannelIdAndPriorities(channelId, ParkConstants.DEVICE_MASTER);
        if (ParkClientCommonUtil.isNotNull(deviceItem)) {
            String photoPath = this.parkRecordinService.snapImage(deviceItem.getIpAddress(), license);
            Timestamp onTime = new Timestamp(System.currentTimeMillis());
            ParkProcessParameter parameter = new ParkProcessParameter();
            parameter.setCheckinMode("scr");
            parameter.setDevice(deviceItem);
            parameter.setPhotoPath(photoPath);
            parameter.setLicense(license);
            parameter.setParkChannelId(channelId);
            parameter.setConfirmFlag(true);
            Short state = channelItem.getState();
            if (ParkConstants.CHANNEL_STATE_CART_IN.equals(state)) {
                isError = false;
                parameter.setCheckinTime(onTime);
                this.parkRecordinService.unlicensedCheckin(parameter);
            }
        }
        if (isError) {
            ParkCheckOutInfo cheOutInfo = new ParkCheckOutInfo();
            cheOutInfo.setMsgType("warning");
            cheOutInfo.setMsgInfo("park_unattended_noCheckSmallPakring");
            cheOutInfo.setParkChannelId(channelId);
            this.parkCloudService.sendUnattendedMsg(cheOutInfo);
        }
        return ZKResultMsg.successMsg();
    }

    public ZKResultMsg unlicensedCheckout(ZKMessage msg) {
        String channelId = msg.getContent().get("channelId").toString();
        String recordinId = msg.getContent().get("recordinId").toString();
        String billingMethod = msg.getContent().get("billingMethod").toString();
        ParkWeChatCharge weChatCharge = new ParkWeChatCharge();
        if (this.parkParamsService.printParkLogger()) {
            log.info("PARK_ONLINE_PAY == Unlicensed Check Out, ChannelId = " + channelId);
        }
        weChatCharge = UNLICENSEDCAR.equals(billingMethod) || TEMPCARCHECKOUT.equals(billingMethod) ? this.getUnattended(recordinId, channelId) : this.getTempCarCharge(channelId);
        return new ZKResultMsg((Object)weChatCharge);
    }

    private ParkWeChatCharge getUnattended(String recordinId, String channelId) {
        ParkWeChatCharge weChatCharge = new ParkWeChatCharge();
        weChatCharge.setParkChannelId(channelId);
        ParkRecordinItem recordinItem = this.parkRecordinService.getItemById(recordinId);
        if (ParkClientCommonUtil.isNotNull(recordinItem)) {
            weChatCharge.setParkingTime(ParkClientCommonUtil.getParkingTime(recordinItem.getCheckInTime(), new Date()));
            if (!this.parkRecordinService.checkTempAuthArea("tempA", channelId)) {
                weChatCharge.setIsAuth("noAuth");
                weChatCharge.setRecordinId(recordinId);
            } else {
                weChatCharge.setIsAuth("temp");
                weChatCharge.setRecordinId(recordinItem.getId());
                ParkTempBillingItem tempBillingItem = this.tempBillingService.getByChannelId(channelId);
                if (ParkClientCommonUtil.isNotNull(tempBillingItem)) {
                    String parkMeterId = tempBillingItem.getParkingMeterId();
                    this.tempBillingService.deleteByIds(tempBillingItem.getId());
                    ParkParkingMeterItem parkingMeterItem = this.parkingMeterService.getItemById(parkMeterId);
                    String recordoutId = parkingMeterItem.getRecordoutId();
                    this.parkRecordoutService.deleteByIds(recordoutId);
                    this.parkingMeterService.deleteByIds(parkMeterId);
                    if (!tempBillingItem.getRecordinId().equals(recordinItem.getId())) {
                        ParkRecordinItem parkRecordinItem = this.parkRecordinService.getItemById(tempBillingItem.getRecordinId());
                        parkRecordinItem.setStatus(ParkConstants.CAR_STATUS_IN);
                        this.parkRecordinService.saveItem(parkRecordinItem);
                    }
                }
                this.parkRecordoutService.unattendedCharge(recordinItem, weChatCharge, channelId, null);
            }
        } else {
            weChatCharge.setChargeType("noRecordin");
            weChatCharge.setRecordinId(recordinId);
        }
        return weChatCharge;
    }

    private ParkWeChatCharge getTempCarCharge(String channelId) {
        ParkWeChatCharge weChatCharge = new ParkWeChatCharge();
        weChatCharge.setParkChannelId(channelId);
        ParkTempBillingItem tempBillingItem = this.tempBillingService.getByChannelId(channelId);
        if (ParkClientCommonUtil.isNotNull(tempBillingItem)) {
            tempBillingItem.setPaymentMethod(ParkConstants.PAY_ONLINE_CHARGE);
            this.tempBillingService.saveItem(tempBillingItem);
            ParkClientCommonUtil.getCarTypeByEvent(tempBillingItem.getEventType(), weChatCharge);
            weChatCharge.setFinalAmount(String.valueOf(tempBillingItem.getReceiveAmount()));
            weChatCharge.setRecordinId(tempBillingItem.getRecordinId());
            ParkRecordinItem parkRecordinItem = this.parkRecordinService.getItemById(tempBillingItem.getRecordinId());
            weChatCharge.setParkingTime(ParkClientCommonUtil.getParkingTime(parkRecordinItem.getCheckInTime(), new Date()));
        } else {
            ParkCheckOutInfo cheOutInfo = new ParkCheckOutInfo();
            cheOutInfo.setMsgType("check");
            cheOutInfo.setParkChannelId(channelId);
            this.parkCloudService.sendUnattendedMsg(cheOutInfo);
        }
        return weChatCharge;
    }
}

