/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.security;

import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.core.utils.EncrypAESUtil;
import com.zkteco.zkbiosecurity.guard.foldex.utils.FoldexUtil;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.session.ExpiringSession;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.data.redis.RedisOperationsSessionRepository;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class SessionManager {
    private static final Logger log = LoggerFactory.getLogger(SessionManager.class);
    @Value(value="${server.session.timeout:1800}")
    private Long sessionTimeout;
    @Value(value="${system.accesstoken.timeout:1}")
    private Long accesstokenTimeout;
    @Value(value="${system.cloud.httpVaildTime:30}")
    private Integer httpVaildTime;
    @Autowired
    FindByIndexNameSessionRepository<? extends ExpiringSession> findByIndexNameSessionRepository;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private RedisOperationsSessionRepository redisOperationsSessionRepository;

    public Boolean checkToken(String accessToken) {
        if (StringUtils.isEmpty((Object)accessToken)) {
            return false;
        }
        accessToken = EncrypAESUtil.decryptToString((String)accessToken);
        String username = accessToken.split("_")[0];
        String key = "auth:access_token:" + username;
        if (this.redisTemplate.hasKey((Object)key).booleanValue() && this.redisTemplate.getExpire((Object)key) > 0L) {
            this.redisTemplate.expire((Object)key, 86400L * this.accesstokenTimeout, TimeUnit.SECONDS);
        }
        return this.redisTemplate.hasKey((Object)key);
    }

    public Boolean checkKey(String key) {
        String appkey = (String)this.stringRedisTemplate.opsForValue().get((Object)"system:param:zkteco:cloud:appkey");
        try {
            if (!StringUtils.isEmpty((Object)key)) {
                String appid = (String)this.stringRedisTemplate.opsForValue().get((Object)"system:param:zkteco:cloud:appid");
                Long newTimestamp = System.currentTimeMillis();
                Long oldTimestamp = Long.parseLong(FoldexUtil.decrypt((String)appid, (String)appkey, (String)key));
                if (newTimestamp - oldTimestamp < (long)(this.httpVaildTime * 1000)) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return false;
        }
        return false;
    }

    public SecuritySubject getCurrentSubject(String sessionId) {
        Object obj = this.redisTemplate.opsForHash().get((Object)("spring:session:sessions:" + sessionId), (Object)"sessionAttr:user");
        RedisOperationsSessionRepository.RedisSession redisSession = this.redisOperationsSessionRepository.getSession(sessionId);
        if (redisSession == null) {
            return null;
        }
        SecuritySubject securitySubject = (SecuritySubject)redisSession.getAttribute("user");
        return securitySubject;
    }

    public void targetSession(HttpServletRequest request, String target) {
        request.getSession().setAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, (Object)target);
    }

    public Map<String, ? extends ExpiringSession> getSessionsByTarget(String target) {
        Map sessionMap = this.findByIndexNameSessionRepository.findByIndexNameAndIndexValue(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, target);
        for (String key : sessionMap.keySet()) {
            if (!((ExpiringSession)sessionMap.get(key)).isExpired()) continue;
            sessionMap.remove(key);
        }
        return sessionMap;
    }

    public Integer countSessionByTarget(String target) {
        Map sessionMap = this.findByIndexNameSessionRepository.findByIndexNameAndIndexValue(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, target);
        Integer count = 0;
        for (ExpiringSession session : sessionMap.values()) {
            if (session.isExpired()) continue;
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        return count;
    }

    public int deleteUserSessionByAccount(String account) {
        Map<String, ? extends ExpiringSession> sessionMap = this.getSessionsByTarget(account);
        sessionMap.keySet().forEach(k -> {
            this.redisTemplate.delete((Object)("spring:session:sessions:" + k));
            this.redisTemplate.delete((Object)("spring:session:sessions:expires:" + k));
        });
        return sessionMap.keySet().size();
    }
}

