/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.dispather.service.impl;

import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.dispather.service.DispatcherService;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class DispatcherServiceImpl
implements DispatcherService {
    Logger logger = LoggerFactory.getLogger(DispatcherServiceImpl.class);
    @Resource
    private ApplicationContext applicationContext;

    @Override
    public ZKResultMsg handle(ZKMessage zkMessage) throws ZKBusinessException {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        if (StringUtils.isEmpty((Object)zkMessage.getMessageId())) {
            return zkResultMsg;
        }
        try {
            String[] javaExtension = zkMessage.getMessageId().split("#");
            if (!this.applicationContext.containsBean(javaExtension[0])) {
                return zkResultMsg;
            }
            Object object = this.applicationContext.getBean(javaExtension[0]);
            Method method = object.getClass().getDeclaredMethod(javaExtension[1], ZKMessage.class);
            method.setAccessible(true);
            zkResultMsg = (ZKResultMsg)method.invoke(object, zkMessage);
        }
        catch (Exception e) {
            this.logger.error("zkMessage:{}", (Object)zkMessage, (Object)e);
        }
        return zkResultMsg;
    }
}

