/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.license.client;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.cloud.sdk.websocket.ApiResultMsg;
import com.zkteco.cloud.sdk.websocket.FailMessageHandler;
import com.zkteco.cloud.sdk.websocket.MessageHandler;
import com.zkteco.cloud.sdk.websocket.ZKCloudTmcClient;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.dispather.service.DispatcherService;
import com.zkteco.zkbiosecurity.license.client.FailMessageCacheManager;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseClientService;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.message.utils.ZKMessageUtils;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class BaseLicenseClientServiceImpl
implements BaseLicenseClientService {
    private static final Logger log = LoggerFactory.getLogger(BaseLicenseClientServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private FailMessageCacheManager failMessageCacheManager;
    @Autowired
    private DispatcherService dispatcherService;
    private ZKCloudTmcClient client = null;

    public ZKResultMsg cancelAppid(ZKMessage zkMessage) {
        this.baseSysParamService.deleteValByName("zkteco:cloud:appid");
        this.baseSysParamService.deleteValByName("zkteco:cloud:appkey");
        this.baseSysParamService.deleteValByName("zkteco:cloud:websocket:url");
        this.baseSysParamService.deleteValByName("cloud.qrcode.url");
        this.baseSysParamService.deleteValByName("zkteco:cloud:app:relation");
        this.closeWebsocketListener();
        return new ZKResultMsg();
    }

    public String getAppid() {
        return this.baseSysParamService.getValByName("zkteco:cloud:appid");
    }

    public String getAppKey() {
        return this.baseSysParamService.getValByName("zkteco:cloud:appkey");
    }

    public String getWebsocketUrl() {
        return this.baseSysParamService.getValByName("zkteco:cloud:websocket:url");
    }

    public void startWebsocketListener(String url, final String appId, String key) {
        this.closeWebsocketListener();
        try {
            this.client = new ZKCloudTmcClient(appId, key);
            this.client.addMessageHander(new MessageHandler(){

                public void onMessage(ApiResultMsg apiResultMsg) {
                    try {
                        ZKMessage zkMessage = ZKMessageUtils.stringToMessage((String)apiResultMsg.getMsg());
                        ZKResultMsg zkResultMsg = BaseLicenseClientServiceImpl.this.dispatcherService.handle(zkMessage);
                        BaseLicenseClientServiceImpl.this.logger.debug("receive message:" + apiResultMsg.getMsg());
                        if (!zkMessage.isAsync()) {
                            ZKMessage zkMessage1 = new ZKMessage();
                            zkMessage1.setContentId(zkMessage.getContentId());
                            zkMessage1.setAsync(false);
                            zkMessage1.setDefaultContent(JSONObject.toJSONString((Object)zkResultMsg));
                            BaseLicenseClientServiceImpl.this.sendMessage(zkMessage1);
                        }
                    }
                    catch (Exception e) {
                        BaseLicenseClientServiceImpl.this.logger.error("business error:" + e.getMessage());
                    }
                }
            });
            this.client.connect(URI.create(url));
            this.client.addFailMessageHandler(new FailMessageHandler(){

                public void handlerFailMessage() {
                    if (!StringUtils.isEmpty((Object)appId)) {
                        BaseLicenseClientServiceImpl.this.logger.info("resend msg:appid=" + appId);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        while (BaseLicenseClientServiceImpl.this.failMessageCacheManager.getDataSize(appId) > 0L) {
                            try {
                                Thread.sleep(300L);
                                if (BaseLicenseClientServiceImpl.this.client == null || !BaseLicenseClientServiceImpl.this.client.isOpen()) break;
                                String data = BaseLicenseClientServiceImpl.this.failMessageCacheManager.getDataFromDb(appId);
                                BaseLicenseClientServiceImpl.this.client.send(data);
                            }
                            catch (Exception e) {
                                BaseLicenseClientServiceImpl.this.logger.error("handle fail message error:", (Object)e.getMessage());
                            }
                        }
                        BaseLicenseClientServiceImpl.this.failMessageCacheManager.getDataFromDb(appId);
                    }
                }

                public void handlerFailMessage(final ApiResultMsg message) {
                    if (message != null && message.getCode() != null && message.getCode().equals(-29)) {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                BaseLicenseClientServiceImpl.this.cancelAppid(new ZKMessage());
                                BaseLicenseClientServiceImpl.this.client.flushAllClient();
                                BaseLicenseClientServiceImpl.this.logger.error(message.getMsg() + " rest appId and appKey !");
                            }
                        }).start();
                    }
                }
            });
        }
        catch (Exception e) {
            this.logger.error("ws run error", (Object)e.getMessage());
        }
    }

    public void closeWebsocketListener() {
        if (this.client != null && this.client.isOpen()) {
            try {
                this.client.close();
            }
            catch (InterruptedException e) {
                this.logger.error("close client error", (Throwable)e);
            }
        }
    }

    public void sendMessage(ZKMessage message) {
        message.setAppId(this.getAppid());
        ApiResultMsg apiResultMsg = new ApiResultMsg();
        apiResultMsg.setMsg(ZKMessageUtils.messageToString((ZKMessage)message));
        if (this.client != null && this.client.isOpen()) {
            this.client.send(JSONObject.toJSONString((Object)apiResultMsg));
            this.logger.debug("send message:" + ZKMessageUtils.messageToString((ZKMessage)message));
        } else if (!StringUtils.isEmpty((Object)this.getAppid())) {
            this.failMessageCacheManager.putDataToDb(this.getAppid(), JSONObject.toJSONString((Object)apiResultMsg));
        }
    }

    public void reconnectionWebsocket() {
        String websocketUrl;
        BaseSysParamItem baseSysParamItem = this.baseSysParamService.findByParamName("zkteco:cloud:appid");
        String appId = baseSysParamItem != null ? baseSysParamItem.getParamValue() : null;
        baseSysParamItem = this.baseSysParamService.findByParamName("zkteco:cloud:appkey");
        String appKey = baseSysParamItem != null ? baseSysParamItem.getParamValue() : null;
        baseSysParamItem = this.baseSysParamService.findByParamName("zkteco:cloud:websocket:url");
        String string = websocketUrl = baseSysParamItem != null ? baseSysParamItem.getParamValue() : null;
        if (!(StringUtils.isEmpty((Object)appId) || StringUtils.isEmpty((Object)appKey) || StringUtils.isEmpty((Object)websocketUrl))) {
            String appRelation;
            this.baseSysParamService.saveValueByName("zkteco:cloud:appid", appId);
            this.baseSysParamService.saveValueByName("zkteco:cloud:appkey", appKey);
            this.baseSysParamService.saveValueByName("zkteco:cloud:websocket:url", websocketUrl);
            baseSysParamItem = this.baseSysParamService.findByParamName("cloud.qrcode.url");
            String cloudQrcodeUrl = baseSysParamItem != null ? baseSysParamItem.getParamValue() : null;
            this.baseSysParamService.saveValueByName("cloud.qrcode.url", cloudQrcodeUrl);
            baseSysParamItem = this.baseSysParamService.findByParamName("zkteco:cloud:app:relation");
            String string2 = appRelation = baseSysParamItem != null ? baseSysParamItem.getParamValue() : null;
            if (appRelation != null) {
                this.baseSysParamService.saveValueByName("zkteco:cloud:app:relation", appRelation);
            }
            this.startWebsocketListener(websocketUrl, appId, appKey);
        } else {
            this.baseSysParamService.deleteValByName("zkteco:cloud:appid");
            this.baseSysParamService.deleteValByName("zkteco:cloud:appkey");
            this.baseSysParamService.deleteValByName("zkteco:cloud:websocket:url");
            this.baseSysParamService.deleteValByName("cloud.qrcode.url");
            this.baseSysParamService.deleteValByName("zkteco:cloud:app:relation");
            log.info("cloud appId and appKey is null,so can not start websocket!");
        }
    }

    public Boolean getwebsocketStaus() {
        if (this.client != null) {
            return this.client.isOpen();
        }
        return false;
    }
}

