/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.distributor.push.http;

import com.zkteco.zkbiosecurity.adms.distributor.bean.ResponseInfo;
import com.zkteco.zkbiosecurity.adms.distributor.push.PushResponse;
import com.zkteco.zkbiosecurity.adms.distributor.push.processor.PushProcessor;
import com.zkteco.zkbiosecurity.adms.distributor.utils.RequestUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final Logger logger = LoggerFactory.getLogger(HttpServerHandler.class);
    private PushProcessor pushProcessor;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
    private static final Calendar cd = Calendar.getInstance();

    public HttpServerHandler(PushProcessor pushProcessor) {
        this.pushProcessor = pushProcessor;
    }

    public HttpServerHandler() {
    }

    public HttpServerHandler(boolean autoRelease) {
        super(autoRelease);
    }

    public HttpServerHandler(Class<? extends HttpObject> inboundMessageType, boolean autoRelease) {
        super(inboundMessageType, autoRelease);
    }

    public HttpServerHandler(Class<? extends HttpObject> inboundMessageType) {
        super(inboundMessageType);
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            String sn = null;
            String uri = null;
            String clientIP = this.getClientIP(ctx, httpRequest);
            long startTime = System.currentTimeMillis();
            try {
                uri = httpRequest.uri();
                if (uri.startsWith("/upload/") || uri.contains("/iclock/upload/ins/adpic")) {
                    String range = httpRequest.headers().get("Range");
                    if (StringUtils.isBlank((CharSequence)range)) {
                        PushResponse.getResourceFile(ctx, httpRequest);
                    } else {
                        this.rangeDownloadFile(ctx, httpRequest, uri, startTime, range);
                    }
                } else if (uri.startsWith("/secure/data")) {
                    ResponseInfo ri = this.pushProcessor.securityAuth(ctx, httpRequest, sn, uri);
                    PushResponse.response(ctx.channel(), ri.getRs(), HttpUtil.isKeepAlive((HttpMessage)httpRequest), "UTF-8");
                } else {
                    URI uriObj = new URI(uri.replace("%", ""));
                    String requestPath = uriObj.getPath();
                    sn = RequestUtil.getParams(uri, "SN");
                    ResponseInfo ri = null;
                    if (StringUtils.isNotBlank((CharSequence)sn)) {
                        httpRequest.headers().getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                        ri = this.pushProcessor.requestData(ctx, httpRequest, sn, uri, requestPath);
                    } else {
                        logger.warn("sn is empty,uri=" + uri + ",ip=" + clientIP);
                        ri = new ResponseInfo("UNKNOWN DEVICE", "UTF-8");
                    }
                    if (StringUtils.isNotBlank((CharSequence)ri.getRs())) {
                        PushResponse.response(ctx.channel(), ri.getRs(), HttpUtil.isKeepAlive((HttpMessage)httpRequest), ri.getEncoding());
                    }
                }
            }
            catch (Exception e) {
                logger.error("clientIP=" + clientIP + "\turi=" + uri + "\tsn=" + sn + " netty handle data error", (Throwable)e);
                PushResponse.response(ctx.channel(), "406", HttpUtil.isKeepAlive((HttpMessage)httpRequest), "UTF-8");
            }
        }
    }

    private void rangeDownloadFile(ChannelHandlerContext ctx, HttpRequest httpRequest, String uri, final long startTime, String range) throws IOException {
        File file;
        if (uri.contains("/iclock/upload/ins/adpic")) {
            uri = uri.replaceFirst("/iclock", "");
        }
        if (!(file = new File(FileUtil.getLocalFullPath((String)uri))).exists()) {
            logger.error("uri=" + uri + "\uff0cfile not exists");
            PushResponse.response(ctx.channel(), "file not exists", HttpUtil.isKeepAlive((HttpMessage)httpRequest), "UTF-8");
            return;
        }
        long fileFullLength = file.length();
        logger.info("fileFullLength=" + fileFullLength);
        final FileInputStream fis = new FileInputStream(file);
        final BufferedInputStream bis = new BufferedInputStream(fis);
        String contentRange = null;
        long contentLength = 0L;
        long position = 0L;
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        if (range != null && range.trim().length() > 0 && !"null".equals(range)) {
            response.setStatus(HttpResponseStatus.PARTIAL_CONTENT);
            String rangBytes = range.replaceAll("bytes=", "");
            if (rangBytes.endsWith("-")) {
                position = Long.parseLong(rangBytes.substring(0, rangBytes.indexOf("-")));
                contentLength = fileFullLength - position;
                contentRange = new StringBuffer("bytes ").append(String.valueOf(position)).append("-").append(new Long(fileFullLength - 1L).toString()).append("/").append(fileFullLength).toString();
                bis.skip(position);
            } else {
                String[] rangeArr = rangBytes.split("-");
                position = Long.parseLong(rangeArr[0]);
                contentLength = Long.parseLong(rangeArr[1]) - position + 1L;
                contentRange = range.replace("=", " ") + "/" + fileFullLength;
                bis.skip(position);
            }
        } else {
            contentLength = fileFullLength;
            contentRange = new StringBuffer("bytes ").append("0-").append(fileFullLength - 1L).append("/").append(fileFullLength).toString();
        }
        logger.info("Range=" + range + ",Content-Length=" + contentLength);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)contentLength);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/octet-stream");
        response.headers().add((CharSequence)HttpHeaderNames.CONTENT_DISPOSITION, (Object)String.format("attachment; filename=\"%s\"", UUID.randomUUID()));
        response.headers().add((CharSequence)HttpHeaderNames.CONTENT_RANGE, (Object)contentRange);
        ctx.write((Object)response);
        ChannelFuture sendFileFuture = ctx.write((Object)new ChunkedStream((InputStream)bis), (ChannelPromise)ctx.newProgressivePromise());
        sendFileFuture.addListener((GenericFutureListener)new ChannelProgressiveFutureListener(){

            public void operationComplete(ChannelProgressiveFuture future) throws Exception {
                logger.info("time=" + (System.currentTimeMillis() - startTime));
                fis.close();
                bis.close();
                logger.info("close over");
            }

            public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) throws Exception {
                logger.debug("progress=" + progress + ",total=" + total);
            }
        });
        ChannelFuture lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!HttpUtil.isKeepAlive((HttpMessage)httpRequest)) {
            logger.info("isKeepAlive,close");
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private String getClientIP(ChannelHandlerContext ctx, HttpRequest httpRequest) {
        String clientIP = httpRequest.headers().get("X-Forwarded-For");
        if (clientIP == null) {
            InetSocketAddress insocket = (InetSocketAddress)ctx.channel().remoteAddress();
            clientIP = insocket.getAddress().getHostAddress();
        }
        return clientIP;
    }

    public void channelRead(ChannelHandlerContext arg0, Object arg1) throws Exception {
        super.channelRead(arg0, arg1);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Channel channel = ctx.channel();
        if (channel.isActive()) {
            ctx.close();
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        super.userEventTriggered(ctx, evt);
    }
}

