/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pos.remote.PosStoreDetailRemote;
import com.zkteco.zkbiosecurity.pos.service.PosStoreDetailService;
import com.zkteco.zkbiosecurity.pos.vo.PosStoreDetailItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosStoreDetailController
extends BaseController
implements PosStoreDetailRemote {
    @Autowired
    private PosStoreDetailService posStoreDetailService;

    @RequiresPermissions(value={"pos:storeDetail"})
    public ModelAndView index() {
        return new ModelAndView("pos/storeDetail/posStoreDetail");
    }

    @RequiresPermissions(value={"pos:storeDetail:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posStoreDetailService.getItemById(id));
        }
        return new ModelAndView("pos/storeDetail/editPosStoreDetail");
    }

    @RequiresPermissions(value={"pos:storeDetail:edit"})
    @LogRequest(module="pos_module", object="pos_leftMenu_storeDetail", opType="common_op_edit", requestParams={"name"}, opContent="pos_storeDetail_name")
    public ZKResultMsg save(PosStoreDetailItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.posStoreDetailService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pos:storeDetail:refresh"})
    public DxGrid list(PosStoreDetailItem codition) {
        Pager pager = this.posStoreDetailService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"pos:storeDetail:del"})
    @LogRequest(module="pos_module", object="pos_leftMenu_storeDetail", opType="common_op_del", requestParams={"names"}, opContent="pos_storeDetail_name")
    public ZKResultMsg delete(String ids) {
        this.posStoreDetailService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String validCode(String code) {
        PosStoreDetailItem item = this.posStoreDetailService.getItemByCode(code);
        boolean rs = item == null;
        return rs + "";
    }
}

