/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttDeptSchRemote;
import com.zkteco.zkbiosecurity.att.service.AttDeptSchService;
import com.zkteco.zkbiosecurity.att.utils.AttDateUtils;
import com.zkteco.zkbiosecurity.att.vo.AttDeptSchItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttDeptSchController
extends BaseController
implements AttDeptSchRemote {
    @Autowired
    private AttDeptSchService attDeptSchService;

    @RequiresPermissions(value={"att:deptsch"})
    public ModelAndView index() {
        return new ModelAndView("att/deptSch/attDeptSch");
    }

    @RequiresPermissions(value={"att:deptsch:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("shiftIds", (Object)this.attDeptSchService.getShiftIds(id));
            AttDeptSchItem attDeptSchItem = this.attDeptSchService.getItemById(id);
            String endTime = AttDateUtils.dateToStrAsShort((Date)attDeptSchItem.getEndDate());
            String maxTime = AttDateUtils.dateToStrAsShort((Date)AttDateUtils.getMaxEndDate());
            if (endTime.equals(maxTime)) {
                attDeptSchItem.setEndDate(null);
            }
            this.request.setAttribute("item", (Object)attDeptSchItem);
        }
        return new ModelAndView("att/deptSch/editAttDeptSch");
    }

    @RequiresPermissions(value={"att:deptsch:edit"})
    @LogRequest(module="att_module", object="att_leftMenu_deptSch", opType="common_op_new", requestParams={"deptIds"}, opContent="att_common_deptId")
    public ZKResultMsg save(AttDeptSchItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String shiftIds = this.request.getParameter("shiftIds");
        String deptIds = this.request.getParameter("deptIds");
        String isIncludeLower = this.request.getParameter("isIncludeLower");
        this.attDeptSchService.saveItem(item, shiftIds, deptIds, isIncludeLower);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:deptsch:refresh"})
    public DxGrid list(AttDeptSchItem condition) {
        if (null == condition.getDeptId()) {
            condition.setId("-1");
        }
        Pager pager = this.attDeptSchService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:deptsch:del"})
    @LogRequest(module="att_module", object="att_leftMenu_deptSch", opType="common_op_del", requestParams={"ids"}, opContent="att_common_id")
    public ZKResultMsg delete(String ids) {
        this.attDeptSchService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getAttShiftSchJsonByDate() {
        String deptId = this.request.getParameter("schId");
        String dateSelected = this.request.getParameter("dateSelected");
        if (StringUtils.isNotBlank((CharSequence)dateSelected)) {
            return this.attDeptSchService.getAttDeptSchJson(deptId, dateSelected);
        }
        return null;
    }
}

