/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttLeaveRemote;
import com.zkteco.zkbiosecurity.att.service.AttAdjustService;
import com.zkteco.zkbiosecurity.att.service.AttClassService;
import com.zkteco.zkbiosecurity.att.service.AttLeaveService;
import com.zkteco.zkbiosecurity.att.service.AttOutService;
import com.zkteco.zkbiosecurity.att.service.AttOvertimeService;
import com.zkteco.zkbiosecurity.att.service.AttPersonService;
import com.zkteco.zkbiosecurity.att.service.AttTripService;
import com.zkteco.zkbiosecurity.att.service.AttWorkflowService;
import com.zkteco.zkbiosecurity.att.utils.AttDateUtils;
import com.zkteco.zkbiosecurity.att.vo.AttLeaveItem;
import com.zkteco.zkbiosecurity.att.vo.AttPersonItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttLeaveController
extends ExportController
implements AttLeaveRemote {
    @Autowired
    private AttLeaveService attLeaveService;
    @Autowired
    private AttPersonService attPersonService;
    @Autowired
    private AttTripService attTripService;
    @Autowired
    private AttAdjustService attAdjustService;
    @Autowired
    private AttOutService attOutService;
    @Autowired
    private AttOvertimeService attOvertimeService;
    @Autowired
    private AttClassService attClassService;
    @Autowired
    private AttWorkflowService attWorkflowService;

    @RequiresPermissions(value={"att:leave"})
    public ModelAndView index() {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        this.request.setAttribute("staff", (Object)staff);
        return new ModelAndView("att/leave/attLeave");
    }

    @RequiresPermissions(value={"att:leave:add"})
    public ModelAndView edit(String id) {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        this.request.setAttribute("staff", (Object)staff);
        AttLeaveItem item = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            item = this.attLeaveService.getItemById(id);
        } else if (null != staff && staff.booleanValue()) {
            item = new AttLeaveItem();
            item.setPersonId(securitySubject.getUserId());
        }
        this.request.setAttribute("item", (Object)item);
        return new ModelAndView("att/leave/editAttLeave");
    }

    public ModelAndView viewLeavePhoto(String key) {
        this.request.setAttribute("key", (Object)key);
        return new ModelAndView("att/flowable/leave/leavePhoto");
    }

    @RequiresPermissions(value={"att:leave:add"})
    @LogRequest(module="att_module", object="att_leftMenu_leave", opType="common_op_new", requestParams={"personPin"}, opContent="att_person_pin")
    public ZKResultMsg save(AttLeaveItem item, @RequestParam(value="leaveImage", required=false) MultipartFile file) {
        ZKResultMsg res = new ZKResultMsg();
        String personIds = this.request.getParameter("personIds");
        if (StringUtils.isBlank((CharSequence)personIds)) {
            throw new ZKBusinessException("EXCEPTIONLEVEL_WARN", "common_prompt_selectObj");
        }
        String leaveImageStr = null;
        if (Objects.nonNull(file) && !file.isEmpty()) {
            Date date = new Date();
            leaveImageStr = FileUtil.saveFileToServer((String)"att", (String)"leave/image", (String)(date.getTime() + ".jpg"), (MultipartFile)file);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -2);
        calendar.set(5, 1);
        Date theFirstDayOfLastMonth = DateUtil.getDayBeginTime((Date)calendar.getTime());
        if (theFirstDayOfLastMonth.compareTo(item.getStartDatetime()) > 0) {
            return ZKResultMsg.getFailMsg((String)I18nUtil.i18nCode((String)"att_apply_overLastMonth", (Object[])new Object[0]));
        }
        HashMap resultMap = this.attLeaveService.getNotApplyPersonStr(personIds, "leave", item.getStartDatetime(), item.getEndDatetime());
        String notApplyPersonNameStr = (String)resultMap.get("notApplyPersonNameStr");
        if (notApplyPersonNameStr.length() > 0) {
            if (notApplyPersonNameStr.length() > 9) {
                String resultPersStr = notApplyPersonNameStr.substring(0, 9) + "...";
                throw ZKBusinessException.warnException((String)"att_admin_applyWarn", (Object[])new Object[]{resultPersStr});
            }
            throw ZKBusinessException.warnException((String)"att_admin_applyWarn", (Object[])new Object[]{notApplyPersonNameStr});
        }
        this.attLeaveService.saveItem(item, personIds, leaveImageStr);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:leave:refresh"})
    public DxGrid list(AttLeaveItem condition) {
        condition.setFlowStatus("2");
        Pager pager = this.attLeaveService.loadPagerByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:leave:del"})
    @LogRequest(module="att_module", object="att_leftMenu_leave", opType="common_op_del", requestParams={"pins"}, opContent="att_person_pin")
    public ZKResultMsg delete(String ids) {
        this.attLeaveService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:leave:export"})
    @LogRequest(module="att_module", object="att_leftMenu_leave", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AttLeaveItem attLeaveItem = new AttLeaveItem();
        this.setConditionValue((BaseItem)attLeaveItem);
        attLeaveItem.setFlowStatus("2");
        List intemList = this.attLeaveService.getItemData(request.getSession().getId(), attLeaveItem, this.getBeginIndex(), this.getEndIndex());
        for (AttLeaveItem attLeave : intemList) {
            float leaveLongHour = (float)attLeave.getLeaveLong().intValue() / 60.0f;
            double result = new BigDecimal(leaveLongHour).setScale(1, 4).doubleValue();
            attLeave.setLeaveLongHour(String.valueOf(result));
        }
        this.excelExport(intemList, AttLeaveItem.class);
    }

    public ModelAndView showImage(String id) {
        AttLeaveItem attLeaveItem = this.attLeaveService.getItemById(id);
        String leaveImage = StringUtils.defaultString((String)attLeaveItem.getLeaveImagePath(), (String)"");
        this.request.setAttribute("leaveImage", (Object)leaveImage);
        return new ModelAndView("att/leave/leaveImage");
    }

    public ZKResultMsg calLeaveTime() {
        String personId = this.request.getParameter("personId");
        String startDateTimeStr = this.request.getParameter("startDateTime");
        String endDateTimeStr = this.request.getParameter("endDateTime");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startDateTime = null;
        Date endDateTime = null;
        try {
            startDateTime = sdf.parse(startDateTimeStr);
            endDateTime = sdf.parse(endDateTimeStr);
        }
        catch (ParseException e) {
            throw new ZKBusinessException("400", "att_timeSlot_time");
        }
        String leaveHours = this.attLeaveService.calLeaveTime(personId, startDateTime, endDateTime);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)leaveHours));
    }

    public ZKResultMsg calLeaveTimeMinute() {
        String personId = this.request.getParameter("personId");
        String startDateTimeStr = this.request.getParameter("startDateTime");
        String endDateTimeStr = this.request.getParameter("endDateTime");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startDateTime = null;
        Date endDateTime = null;
        try {
            startDateTime = sdf.parse(startDateTimeStr);
            endDateTime = sdf.parse(endDateTimeStr);
        }
        catch (ParseException e) {
            throw new ZKBusinessException("400", "att_timeSlot_time");
        }
        int calLeaveTimeMinutes = this.attLeaveService.calLeaveTimeMinutes(personId, startDateTime, endDateTime);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)calLeaveTimeMinutes));
    }

    public ZKResultMsg existApply(String personIds, Date startTime, Date endTime, String exceptionType) {
        List attPersonItemList = this.attPersonService.getPersonItemByPersonIds((Collection)StrUtil.strToList((String)personIds));
        for (AttPersonItem attPersonItem : attPersonItemList) {
            Date hireDate = attPersonItem.getHireDate();
            if (hireDate == null || hireDate.getTime() <= startTime.getTime()) continue;
            throw new ZKBusinessException("500", "att_h5_persNoHire");
        }
        List<String> personIdList = Arrays.asList(personIds.split(","));
        if (exceptionType.equals("adjust") || exceptionType.equals("class")) {
            if (this.attAdjustService.existAdjust(personIdList, startTime, endTime)) {
                return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"att_apply_adjustTips", (Object[])new Object[0]));
            }
            if (this.attClassService.existClass(personIdList, startTime, endTime)) {
                return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"att_apply_classTips", (Object[])new Object[0]));
            }
        } else {
            if (this.attLeaveService.existLeave(personIdList, startTime, endTime)) {
                return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"att_apply_leaveTips", (Object[])new Object[0]));
            }
            if (this.attTripService.existTrip(personIdList, startTime, endTime)) {
                return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"att_apply_tripTips", (Object[])new Object[0]));
            }
            if (this.attOutService.existOut(personIdList, startTime, endTime)) {
                return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"att_apply_outTips", (Object[])new Object[0]));
            }
            if (this.attOvertimeService.existOvertime(personIdList, startTime, endTime)) {
                return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"att_apply_overtimeTips", (Object[])new Object[0]));
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public ZKResultMsg checkApplyAndWorkTimeValid(String flowType, Date startTime, Date endTime) {
        if (startTime == null || endTime == null) {
            I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"base_dataClean_message4", (Object[])new Object[0]));
        }
        String startTimeStr = AttDateUtils.dateToStrAsLong((Date)startTime);
        String endTimeStr = AttDateUtils.dateToStrAsLong((Date)endTime);
        String personPin = this.attPersonService.getPinByLoginType(this.request.getSession().getId());
        if (StringUtils.isBlank((CharSequence)personPin)) {
            I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"att_excp_notExisetPerson", (Object[])new Object[0]));
        }
        return this.attWorkflowService.checkApplyAndWorkTimeValid(personPin, flowType, startTimeStr, endTimeStr);
    }
}

