/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.ClassSpecializer;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.DontInline;
import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.Invokers;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodTypeForm;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.internal.vm.annotation.Stable;
import sun.invoke.util.Wrapper;

class LambdaForm {
    final int arity;
    final int result;
    final Name[] names;
    final String debugName;
    MemberName vmentry;
    private boolean isCompiled;
    LambdaForm[] bindCache;
    public static final int VOID_RESULT = -1;
    public static final int LAST_RESULT = -2;
    private static final ConcurrentHashMap<String, LambdaForm> PREPARED_FORMS;
    private static final boolean USE_PREDEFINED_INTERPRET_METHODS = true;
    private static final int COMPILE_THRESHOLD;
    private int invocationCounter = 0;
    static final String ALL_TYPES = "LIJFD";
    static final int INTERNED_ARGUMENT_LIMIT = 10;
    private static final Name[][] INTERNED_ARGUMENTS;
    private static final MemberName.Factory IMPL_NAMES;
    private static final Name[] CONSTANT_ZERO;

    LambdaForm(String string, int n, Name[] nameArray, int n2) {
        assert (LambdaForm.namesOK(n, nameArray));
        this.arity = n;
        this.result = LambdaForm.fixResult(n2, nameArray);
        this.names = (Name[])nameArray.clone();
        this.debugName = string;
        this.normalize();
    }

    LambdaForm(String string, int n, Name[] nameArray) {
        this(string, n, nameArray, -2);
    }

    LambdaForm(String string, Name[] nameArray, Name[] nameArray2, Name name) {
        this(string, nameArray.length, LambdaForm.buildNames(nameArray, nameArray2, name), -2);
    }

    private static Name[] buildNames(Name[] nameArray, Name[] nameArray2, Name name) {
        int n = nameArray.length;
        int n2 = n + nameArray2.length + (name == null ? 0 : 1);
        Name[] nameArray3 = Arrays.copyOf(nameArray, n2);
        System.arraycopy(nameArray2, 0, nameArray3, n, nameArray2.length);
        if (name != null) {
            nameArray3[n2 - 1] = name;
        }
        return nameArray3;
    }

    private LambdaForm(String string) {
        assert (LambdaForm.isValidSignature(string));
        this.arity = LambdaForm.signatureArity(string);
        this.result = LambdaForm.signatureReturn(string) == 'V' ? -1 : this.arity;
        this.names = LambdaForm.buildEmptyNames(this.arity, string);
        this.debugName = "LF.zero";
        assert (this.nameRefsAreLegal());
        assert (this.isEmpty());
        assert (string.equals(this.basicTypeSignature()));
    }

    private static Name[] buildEmptyNames(int n, String string) {
        assert (LambdaForm.isValidSignature(string));
        int n2 = n + 1;
        if (n < 0 || string.length() != n2 + 1) {
            throw new IllegalArgumentException("bad arity for " + string);
        }
        int n3 = string.charAt(n2) == 'V' ? 0 : 1;
        Name[] nameArray = LambdaForm.arguments(n3, string.substring(0, n));
        for (int i = 0; i < n3; ++i) {
            nameArray[n + i] = LambdaForm.constantZero(n + i, string.charAt(n2 + i));
        }
        return nameArray;
    }

    private static int fixResult(int n, Name[] nameArray) {
        if (n >= 0) {
            if (nameArray[n].type == 86) {
                return -1;
            }
        } else if (n == -2) {
            return nameArray.length - 1;
        }
        return n;
    }

    private static boolean namesOK(int n, Name[] nameArray) {
        for (int i = 0; i < nameArray.length; ++i) {
            Name name = nameArray[i];
            assert (name != null) : "n is null";
            if (i < n) {
                assert (name.isParam()) : name + " is not param at " + i;
                continue;
            }
            assert (!name.isParam()) : name + " is param at " + i;
        }
        return true;
    }

    private void normalize() {
        int n;
        int n2;
        Name[] nameArray = null;
        int n3 = 0;
        for (n2 = 0; n2 < this.names.length; ++n2) {
            Name name = this.names[n2];
            if (name.initIndex(n2)) continue;
            if (nameArray == null) {
                nameArray = (Name[])this.names.clone();
                n3 = n2;
            }
            this.names[n2] = name.cloneWithIndex(n2);
        }
        if (nameArray != null) {
            n2 = this.arity;
            if (n2 <= n3) {
                n2 = n3 + 1;
            }
            for (int i = n2; i < this.names.length; ++i) {
                Name name = this.names[i].replaceNames(nameArray, this.names, n3, i);
                this.names[i] = name.newIndex(i);
            }
        }
        assert (this.nameRefsAreLegal());
        n2 = Math.min(this.arity, 10);
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            Name name = this.names[n];
            Name name2 = LambdaForm.internArgument(name);
            if (name == name2) continue;
            this.names[n] = name2;
            bl = true;
        }
        if (bl) {
            for (n = this.arity; n < this.names.length; ++n) {
                this.names[n].internArguments();
            }
            assert (this.nameRefsAreLegal());
        }
    }

    private boolean nameRefsAreLegal() {
        Name name;
        int n;
        assert (this.arity >= 0 && this.arity <= this.names.length);
        assert (this.result >= -1 && this.result < this.names.length);
        for (n = 0; n < this.arity; ++n) {
            name = this.names[n];
            assert (name.index() == n) : Arrays.asList(name.index(), n);
            assert (name.isParam());
        }
        for (n = this.arity; n < this.names.length; ++n) {
            name = this.names[n];
            assert (name.index() == n);
            for (Object object : name.arguments) {
                if (!(object instanceof Name)) continue;
                Name name2 = (Name)object;
                short s = Name.access$000((Name)name2);
                assert (0 <= s && s < this.names.length) : name.debugString() + ": 0 <= i2 && i2 < names.length: 0 <= " + s + " < " + this.names.length;
                assert (this.names[s] == name2) : Arrays.asList("-1-", n, "-2-", name.debugString(), "-3-", s, "-4-", name2.debugString(), "-5-", this.names[s].debugString(), "-6-", this);
                assert (s < n);
            }
        }
        return true;
    }

    char returnType() {
        if (this.result < 0) {
            return 'V';
        }
        Name name = this.names[this.result];
        return (char)name.type;
    }

    char parameterType(int n) {
        assert (n < this.arity);
        return (char)this.names[n].type;
    }

    int arity() {
        return this.arity;
    }

    MethodType methodType() {
        return LambdaForm.signatureType(this.basicTypeSignature());
    }

    final String basicTypeSignature() {
        StringBuilder stringBuilder = new StringBuilder(this.arity() + 3);
        int n = this.arity();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.parameterType(i));
        }
        return stringBuilder.append('_').append(this.returnType()).toString();
    }

    static int signatureArity(String string) {
        assert (LambdaForm.isValidSignature(string));
        return string.indexOf(95);
    }

    static char signatureReturn(String string) {
        return string.charAt(LambdaForm.signatureArity(string) + 1);
    }

    static boolean isValidSignature(String string) {
        int n = string.indexOf(95);
        if (n < 0) {
            return false;
        }
        int n2 = string.length();
        if (n2 != n + 2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (i == n) continue;
            char c = string.charAt(i);
            if (c == 'V') {
                return i == n2 - 1 && n == n2 - 2;
            }
            if (ALL_TYPES.indexOf(c) >= 0) continue;
            return false;
        }
        return true;
    }

    static Class<?> typeClass(char c) {
        switch (c) {
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'L': {
                return Object.class;
            }
            case 'V': {
                return Void.TYPE;
            }
        }
        assert (false);
        return null;
    }

    static MethodType signatureType(String string) {
        Class[] classArray = new Class[LambdaForm.signatureArity(string)];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = LambdaForm.typeClass(string.charAt(i));
        }
        Class<?> clazz = LambdaForm.typeClass(LambdaForm.signatureReturn(string));
        return MethodType.methodType(clazz, classArray);
    }

    public void prepare() {
        if (COMPILE_THRESHOLD == 0) {
            this.compileToBytecode();
        }
        if (this.vmentry != null) {
            return;
        }
        LambdaForm lambdaForm = LambdaForm.getPreparedForm(this.basicTypeSignature());
        this.vmentry = lambdaForm.vmentry;
    }

    MemberName compileToBytecode() {
        MethodType methodType = this.methodType();
        assert (this.vmentry == null || this.vmentry.getMethodType().basicType().equals((Object)methodType));
        if (this.vmentry != null && this.isCompiled) {
            return this.vmentry;
        }
        try {
            this.vmentry = InvokerBytecodeGenerator.generateCustomizedCode(this, methodType);
            if (MethodHandleStatics.TRACE_INTERPRETER) {
                LambdaForm.traceInterpreter("compileToBytecode", this);
            }
            this.isCompiled = true;
            return this.vmentry;
        }
        catch (Error | Exception throwable) {
            throw MethodHandleStatics.newInternalError((String)this.toString(), (Throwable)throwable);
        }
    }

    private static Map<String, LambdaForm> computeInitialPreparedForms() {
        HashMap<String, LambdaForm> hashMap = new HashMap<String, LambdaForm>();
        for (MemberName memberName : MemberName.getFactory().getMethods(LambdaForm.class, false, null, null, null)) {
            MethodType methodType;
            if (!memberName.isStatic() || !memberName.isPackage() || (methodType = memberName.getMethodType()).parameterCount() <= 0 || methodType.parameterType(0) != MethodHandle.class || !memberName.getName().startsWith("interpret_")) continue;
            String string = LambdaForm.basicTypeSignature(methodType);
            assert (memberName.getName().equals("interpret" + string.substring(string.indexOf(95))));
            LambdaForm lambdaForm = new LambdaForm(string);
            lambdaForm.vmentry = memberName;
            methodType.form().setCachedLambdaForm(7, lambdaForm);
            hashMap.put(string, lambdaForm);
        }
        return hashMap;
    }

    static Object interpret_L(MethodHandle methodHandle) throws Throwable {
        Object[] objectArray = new Object[]{methodHandle};
        String string = null;
        if (!$assertionsDisabled) {
            string = "L_L";
            if (!LambdaForm.argumentTypesMatch("L_L", objectArray)) {
                throw new AssertionError();
            }
        }
        Object object = methodHandle.form.interpretWithArguments(objectArray);
        assert (LambdaForm.returnTypesMatch(string, objectArray, object));
        return object;
    }

    static Object interpret_L(MethodHandle methodHandle, Object object) throws Throwable {
        Object[] objectArray = new Object[]{methodHandle, object};
        String string = null;
        if (!$assertionsDisabled) {
            string = "LL_L";
            if (!LambdaForm.argumentTypesMatch("LL_L", objectArray)) {
                throw new AssertionError();
            }
        }
        Object object2 = methodHandle.form.interpretWithArguments(objectArray);
        assert (LambdaForm.returnTypesMatch(string, objectArray, object2));
        return object2;
    }

    static Object interpret_L(MethodHandle methodHandle, Object object, Object object2) throws Throwable {
        Object[] objectArray = new Object[]{methodHandle, object, object2};
        String string = null;
        if (!$assertionsDisabled) {
            string = "LLL_L";
            if (!LambdaForm.argumentTypesMatch("LLL_L", objectArray)) {
                throw new AssertionError();
            }
        }
        Object object3 = methodHandle.form.interpretWithArguments(objectArray);
        assert (LambdaForm.returnTypesMatch(string, objectArray, object3));
        return object3;
    }

    private static LambdaForm getPreparedForm(String string) {
        MethodType methodType = LambdaForm.signatureType(string);
        LambdaForm lambdaForm = methodType.form().cachedLambdaForm(6);
        if (lambdaForm != null) {
            return lambdaForm;
        }
        assert (LambdaForm.isValidSignature(string));
        lambdaForm = new LambdaForm(string);
        lambdaForm.vmentry = InvokerBytecodeGenerator.generateLambdaFormInterpreterEntryPoint((String)string);
        return methodType.form().setCachedLambdaForm(6, lambdaForm);
    }

    private static boolean argumentTypesMatch(String string, Object[] objectArray) {
        int n = LambdaForm.signatureArity(string);
        assert (objectArray.length == n) : "av.length == arity: av.length=" + objectArray.length + ", arity=" + n;
        assert (objectArray[0] instanceof MethodHandle) : "av[0] not instace of MethodHandle: " + objectArray[0];
        MethodHandle methodHandle = (MethodHandle)objectArray[0];
        MethodType methodType = methodHandle.type();
        assert (methodType.parameterCount() == n - 1);
        for (int i = 0; i < objectArray.length; ++i) {
            Class<MethodHandle> clazz;
            Class clazz2 = clazz = i == 0 ? MethodHandle.class : methodType.parameterType(i - 1);
            assert (LambdaForm.valueMatches(string.charAt(i), clazz, objectArray[i]));
        }
        return true;
    }

    private static boolean valueMatches(char c, Class<?> clazz, Object object) {
        if (clazz == Void.TYPE) {
            c = (char)86;
        }
        assert (c == LambdaForm.basicType(clazz)) : c + " == basicType(" + clazz + ")=" + LambdaForm.basicType(clazz);
        switch (c) {
            case 'I': {
                assert (LambdaForm.checkInt(clazz, object)) : "checkInt(" + clazz + "," + object + ")";
                break;
            }
            case 'J': {
                assert (object instanceof Long) : "instanceof Long: " + object;
                break;
            }
            case 'F': {
                assert (object instanceof Float) : "instanceof Float: " + object;
                break;
            }
            case 'D': {
                assert (object instanceof Double) : "instanceof Double: " + object;
                break;
            }
            case 'L': {
                assert (LambdaForm.checkRef(clazz, object)) : "checkRef(" + clazz + "," + object + ")";
                break;
            }
            case 'V': {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return true;
    }

    private static boolean returnTypesMatch(String string, Object[] objectArray, Object object) {
        MethodHandle methodHandle = (MethodHandle)objectArray[0];
        return LambdaForm.valueMatches(LambdaForm.signatureReturn(string), methodHandle.type().returnType(), object);
    }

    private static boolean checkInt(Class<?> clazz, Object object) {
        assert (object instanceof Integer);
        if (clazz == Integer.TYPE) {
            return true;
        }
        Wrapper wrapper = Wrapper.forBasicType(clazz);
        assert (wrapper.isSubwordOrInt());
        Object object2 = Wrapper.INT.wrap(wrapper.wrap(object));
        return object.equals(object2);
    }

    private static boolean checkRef(Class<?> clazz, Object object) {
        assert (!clazz.isPrimitive());
        if (object == null) {
            return true;
        }
        if (clazz.isInterface()) {
            return true;
        }
        return clazz.isInstance(object);
    }

    @Hidden
    @DontInline
    Object interpretWithArguments(Object ... objectArray) throws Throwable {
        if (MethodHandleStatics.TRACE_INTERPRETER) {
            return this.interpretWithArgumentsTracing(objectArray);
        }
        this.checkInvocationCounter();
        assert (this.arityCheck(objectArray));
        Object[] objectArray2 = Arrays.copyOf(objectArray, this.names.length);
        for (int i = objectArray.length; i < objectArray2.length; ++i) {
            objectArray2[i] = this.interpretName(this.names[i], objectArray2);
        }
        return this.result < 0 ? null : objectArray2[this.result];
    }

    @Hidden
    @DontInline
    Object interpretName(Name name, Object[] objectArray) throws Throwable {
        if (MethodHandleStatics.TRACE_INTERPRETER) {
            LambdaForm.traceInterpreter("| interpretName", name.debugString(), null);
        }
        Object[] objectArray2 = Arrays.copyOf(name.arguments, name.arguments.length, Object[].class);
        for (int i = 0; i < objectArray2.length; ++i) {
            Object object = objectArray2[i];
            if (!(object instanceof Name)) continue;
            int n = ((Name)object).index();
            assert (this.names[n] == object);
            object = objectArray[n];
            objectArray2[i] = object;
        }
        return name.function.invokeWithArguments(objectArray2);
    }

    private void checkInvocationCounter() {
        if (COMPILE_THRESHOLD != 0 && this.invocationCounter < COMPILE_THRESHOLD) {
            ++this.invocationCounter;
            if (this.invocationCounter >= COMPILE_THRESHOLD) {
                this.compileToBytecode();
            }
        }
    }

    Object interpretWithArgumentsTracing(Object ... objectArray) throws Throwable {
        Object object;
        LambdaForm.traceInterpreter("[ interpretWithArguments", this, objectArray);
        if (this.invocationCounter < COMPILE_THRESHOLD) {
            int n = this.invocationCounter++;
            LambdaForm.traceInterpreter("| invocationCounter", n);
            if (this.invocationCounter >= COMPILE_THRESHOLD) {
                this.compileToBytecode();
            }
        }
        try {
            assert (this.arityCheck(objectArray));
            Object[] objectArray2 = Arrays.copyOf(objectArray, this.names.length);
            for (int i = objectArray.length; i < objectArray2.length; ++i) {
                objectArray2[i] = this.interpretName(this.names[i], objectArray2);
            }
            object = this.result < 0 ? null : objectArray2[this.result];
        }
        catch (Throwable throwable) {
            LambdaForm.traceInterpreter("] throw =>", throwable);
            throw throwable;
        }
        LambdaForm.traceInterpreter("] return =>", object);
        return object;
    }

    static void traceInterpreter(String string, Object object, Object ... objectArray) {
        if (!MethodHandleStatics.TRACE_INTERPRETER) {
            return;
        }
        System.out.println("LFI: " + string + " " + (object != null ? object : "") + (objectArray != null && objectArray.length != 0 ? Arrays.asList(objectArray) : ""));
    }

    static void traceInterpreter(String string, Object object) {
        LambdaForm.traceInterpreter(string, object, null);
    }

    private boolean arityCheck(Object[] objectArray) {
        assert (objectArray.length == this.arity) : this.arity + "!=" + Arrays.asList(objectArray) + ".length";
        assert (objectArray[0] instanceof MethodHandle) : "not MH: " + objectArray[0];
        assert (((MethodHandle)objectArray[0]).internalForm() == this);
        return true;
    }

    private boolean isEmpty() {
        if (this.result < 0) {
            return this.names.length == this.arity;
        }
        if (this.result == this.arity && this.names.length == this.arity + 1) {
            return this.names[this.arity].isConstantZero();
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.debugName + "=Lambda(");
        for (int i = 0; i < this.names.length; ++i) {
            if (i == this.arity) {
                stringBuilder.append(")=>{");
            }
            Name name = this.names[i];
            if (i >= this.arity) {
                stringBuilder.append("\n    ");
            }
            stringBuilder.append(name);
            if (i < this.arity) {
                if (i + 1 >= this.arity) continue;
                stringBuilder.append(",");
                continue;
            }
            stringBuilder.append("=").append(name.exprString());
            stringBuilder.append(";");
        }
        stringBuilder.append(this.result < 0 ? "void" : this.names[this.result]).append("}");
        if (MethodHandleStatics.TRACE_INTERPRETER) {
            stringBuilder.append(":").append(this.basicTypeSignature());
            stringBuilder.append("/").append(this.vmentry);
        }
        return stringBuilder.toString();
    }

    LambdaForm bindImmediate(int n, char c, Object object) {
        assert (n > 0 && n < this.arity && this.names[n].type == c && Name.access$100((char)c, (Object)object));
        int n2 = this.arity - 1;
        Name[] nameArray = new Name[this.names.length - 1];
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.names.length) {
            Name name = this.names[n3];
            if (name.isParam()) {
                if (Name.access$000((Name)name) == n) {
                    --n4;
                } else {
                    nameArray[n4] = new Name(n4, (char)name.type);
                }
            } else {
                Object[] objectArray = new Object[name.arguments.length];
                for (int i = 0; i < name.arguments.length; ++i) {
                    Object object2 = name.arguments[i];
                    if (object2 instanceof Name) {
                        short s = Name.access$000((Name)((Name)object2));
                        if (s == n) {
                            objectArray[i] = object;
                            continue;
                        }
                        if (s < n) {
                            objectArray[i] = nameArray[s];
                            continue;
                        }
                        objectArray[i] = nameArray[s - 1];
                        continue;
                    }
                    objectArray[i] = object2;
                }
                nameArray[n4] = new Name(name.function, objectArray);
                nameArray[n4].initIndex(n4);
            }
            ++n3;
            ++n4;
        }
        n3 = this.result == -1 ? -1 : this.result - 1;
        return new LambdaForm(this.debugName, n2, nameArray, n3);
    }

    LambdaForm bind(int n, BoundMethodHandle.SpeciesData speciesData) {
        Name name = this.names[n];
        BoundMethodHandle.SpeciesData speciesData2 = speciesData.extendWithType((char)name.type);
        return this.bind(name, speciesData2.getterName(this.names[0], speciesData.fieldCount()), speciesData, speciesData2);
    }

    LambdaForm bind(Name name, Name name2, BoundMethodHandle.SpeciesData speciesData, BoundMethodHandle.SpeciesData speciesData2) {
        Name name3;
        int n;
        int n2 = Name.access$000((Name)name);
        assert (name.isParam());
        assert (!name2.isParam());
        assert (name.type == name2.type);
        assert (0 <= n2 && n2 < this.arity && this.names[n2] == name);
        assert (name2.function.memberDeclaringClassOrNull() == speciesData2.clazz);
        assert (speciesData.getters.length == speciesData2.getters.length - 1);
        if (this.bindCache != null) {
            LambdaForm lambdaForm = this.bindCache[n2];
            if (lambdaForm != null) {
                assert (lambdaForm.contains(name2)) : "form << " + lambdaForm + " >> does not contain binding << " + name2 + " >>";
                return lambdaForm;
            }
        } else {
            this.bindCache = new LambdaForm[this.arity];
        }
        assert (this.nameRefsAreLegal());
        int n3 = this.arity - 1;
        Name[] nameArray = (Name[])this.names.clone();
        nameArray[n2] = name2;
        int n4 = -1;
        for (n = 0; n < nameArray.length; ++n) {
            Name name4;
            name3 = this.names[n];
            if (name3.function == null || name3.function.memberDeclaringClassOrNull() != speciesData.clazz) continue;
            MethodHandle methodHandle = name3.function.resolvedHandle;
            MethodHandle methodHandle2 = null;
            for (int i = 0; i < speciesData.getters.length; ++i) {
                if (methodHandle != speciesData.getters[i]) continue;
                methodHandle2 = speciesData2.getters[i];
            }
            if (methodHandle2 == null) continue;
            if (n4 < 0) {
                n4 = n;
            }
            nameArray[n] = name4 = new Name(methodHandle2, name3.arguments);
        }
        assert (n4 < 0 || n4 > n2);
        for (n = n2 + 1; n < nameArray.length; ++n) {
            if (n <= n3) continue;
            nameArray[n] = nameArray[n].replaceNames(this.names, nameArray, n2, n);
        }
        n = n2;
        while (n + 1 < nameArray.length && (name3 = nameArray[n + 1]).isSiblingBindingBefore(name2)) {
            nameArray[n] = name3;
            ++n;
        }
        nameArray[n] = name2;
        int n5 = this.result;
        if (n5 == n2) {
            n5 = n;
        } else if (n5 > n2 && n5 <= n) {
            --n5;
        }
        this.bindCache[n2] = new LambdaForm(this.debugName, n3, nameArray, n5);
        return this.bindCache[n2];
    }

    boolean contains(Name name) {
        int n = name.index();
        if (n >= 0) {
            return n < this.names.length && name.equals(this.names[n]);
        }
        for (int i = this.arity; i < this.names.length; ++i) {
            if (!name.equals(this.names[i])) continue;
            return true;
        }
        return false;
    }

    LambdaForm addArguments(int n, char ... cArray) {
        assert (n <= this.arity);
        int n2 = this.names.length;
        int n3 = cArray.length;
        Name[] nameArray = Arrays.copyOf(this.names, n2 + n3);
        int n4 = this.arity + n3;
        int n5 = this.result;
        if (n5 >= this.arity) {
            n5 += n3;
        }
        int n6 = n + 1;
        System.arraycopy(this.names, n6, nameArray, n6 + n3, n2 - n6);
        for (int i = 0; i < n3; ++i) {
            nameArray[n6 + i] = new Name(cArray[i]);
        }
        return new LambdaForm(this.debugName, n4, nameArray, n5);
    }

    LambdaForm addArguments(int n, List<Class<?>> list) {
        char[] cArray = new char[list.size()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = LambdaForm.basicType(list.get(i));
        }
        return this.addArguments(n, cArray);
    }

    LambdaForm permuteArguments(int n, int[] nArray, char[] cArray) {
        int n2;
        Name name;
        int n3;
        int n4;
        int n5 = this.names.length;
        int n6 = cArray.length;
        int n7 = nArray.length;
        assert (n + n7 == this.arity);
        assert (LambdaForm.permutedTypesMatch(nArray, cArray, this.names, n));
        for (n4 = 0; n4 < n7 && nArray[n4] == n4; ++n4) {
        }
        Name[] nameArray = new Name[n5 - n7 + n6];
        System.arraycopy(this.names, 0, nameArray, 0, n + n4);
        int n8 = n5 - this.arity;
        System.arraycopy(this.names, n + n7, nameArray, n + n6, n8);
        int n9 = nameArray.length - n8;
        int n10 = this.result;
        if (n10 >= 0) {
            n10 = n10 < n + n7 ? nArray[n10 - n] : n10 - n7 + n6;
        }
        for (n3 = n4; n3 < n7; ++n3) {
            Name name2 = this.names[n + n3];
            int n11 = nArray[n3];
            name = nameArray[n + n11];
            if (name == null) {
                nameArray[n + n11] = name = new Name(cArray[n11]);
            } else assert (name.type == cArray[n11]);
            for (n2 = n9; n2 < nameArray.length; ++n2) {
                nameArray[n2] = nameArray[n2].replaceName(name2, name);
            }
        }
        for (n3 = n + n4; n3 < n9; ++n3) {
            if (nameArray[n3] != null) continue;
            nameArray[n3] = LambdaForm.argument(n3, cArray[n3 - n]);
        }
        for (n3 = this.arity; n3 < this.names.length; ++n3) {
            Name name3 = this.names[n3];
            int n12 = n3 - this.arity + n9;
            name = nameArray[n12];
            if (name3 == name) continue;
            for (n2 = n12 + 1; n2 < nameArray.length; ++n2) {
                nameArray[n2] = nameArray[n2].replaceName(name3, name);
            }
        }
        return new LambdaForm(this.debugName, n9, nameArray, n10);
    }

    static boolean permutedTypesMatch(int[] nArray, char[] cArray, Name[] nameArray, int n) {
        int n2 = cArray.length;
        int n3 = nArray.length;
        for (int i = 0; i < n3; ++i) {
            assert (nameArray[n + i].isParam());
            assert (nameArray[n + i].type == cArray[nArray[i]]);
        }
        return true;
    }

    void resolve() {
        for (Name name : this.names) {
            name.resolve();
        }
    }

    public static char basicType(Class<?> clazz) {
        char c = Wrapper.basicTypeChar(clazz);
        if ("ZBSC".indexOf(c) >= 0) {
            c = 'I';
        }
        assert ("LIJFDV".indexOf(c) >= 0);
        return c;
    }

    public static char[] basicTypes(List<Class<?>> list) {
        char[] cArray = new char[list.size()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = LambdaForm.basicType(list.get(i));
        }
        return cArray;
    }

    public static String basicTypeSignature(MethodType methodType) {
        char[] cArray = new char[methodType.parameterCount() + 2];
        int n = 0;
        for (Class<?> clazz : methodType.parameterList()) {
            cArray[n++] = LambdaForm.basicType(clazz);
        }
        cArray[n++] = 95;
        cArray[n++] = LambdaForm.basicType(methodType.returnType());
        assert (n == cArray.length);
        return String.valueOf(cArray);
    }

    static Name argument(int n, char c) {
        int n2 = ALL_TYPES.indexOf(c);
        if (n2 < 0 || n >= 10) {
            return new Name(n, c);
        }
        return INTERNED_ARGUMENTS[n2][n];
    }

    static Name internArgument(Name name) {
        assert (name.isParam()) : "not param: " + name;
        assert (Name.access$000((Name)name) < 10);
        return LambdaForm.argument(Name.access$000((Name)name), (char)name.type);
    }

    static Name[] arguments(int n, String string) {
        int n2 = string.length();
        Name[] nameArray = new Name[n2 + n];
        for (int i = 0; i < n2; ++i) {
            nameArray[i] = LambdaForm.argument(i, string.charAt(i));
        }
        return nameArray;
    }

    static Name[] arguments(int n, char ... cArray) {
        int n2 = cArray.length;
        Name[] nameArray = new Name[n2 + n];
        for (int i = 0; i < n2; ++i) {
            nameArray[i] = LambdaForm.argument(i, cArray[i]);
        }
        return nameArray;
    }

    static Name[] arguments(int n, List<Class<?>> list) {
        int n2 = list.size();
        Name[] nameArray = new Name[n2 + n];
        for (int i = 0; i < n2; ++i) {
            nameArray[i] = LambdaForm.argument(i, LambdaForm.basicType(list.get(i)));
        }
        return nameArray;
    }

    static Name[] arguments(int n, Class<?> ... classArray) {
        int n2 = classArray.length;
        Name[] nameArray = new Name[n2 + n];
        for (int i = 0; i < n2; ++i) {
            nameArray[i] = LambdaForm.argument(i, LambdaForm.basicType(classArray[i]));
        }
        return nameArray;
    }

    static Name[] arguments(int n, MethodType methodType) {
        int n2 = methodType.parameterCount();
        Name[] nameArray = new Name[n2 + n];
        for (int i = 0; i < n2; ++i) {
            nameArray[i] = LambdaForm.argument(i, LambdaForm.basicType(methodType.parameterType(i)));
        }
        return nameArray;
    }

    static Name constantZero(int n, char c) {
        return CONSTANT_ZERO[ALL_TYPES.indexOf(c)].newIndex(n);
    }

    private static int zeroI() {
        return 0;
    }

    private static long zeroJ() {
        return 0L;
    }

    private static float zeroF() {
        return 0.0f;
    }

    private static double zeroD() {
        return 0.0;
    }

    private static Object zeroL() {
        return null;
    }

    static {
        int n = 512;
        float f = 0.75f;
        char c = '\u0001';
        PREPARED_FORMS = new ConcurrentHashMap(n, f, c);
        COMPILE_THRESHOLD = MethodHandleStatics.COMPILE_THRESHOLD != null ? MethodHandleStatics.COMPILE_THRESHOLD.intValue() : 30;
        INTERNED_ARGUMENTS = new Name[ALL_TYPES.length()][10];
        for (n = 0; n < ALL_TYPES.length(); ++n) {
            for (int i = 0; i < INTERNED_ARGUMENTS[n].length; ++i) {
                c = ALL_TYPES.charAt(n);
                LambdaForm.INTERNED_ARGUMENTS[n][i] = new Name(i, c);
            }
        }
        IMPL_NAMES = MemberName.getFactory();
        CONSTANT_ZERO = new Name[ALL_TYPES.length()];
        for (n = 0; n < ALL_TYPES.length(); ++n) {
            char c2 = ALL_TYPES.charAt(n);
            Wrapper wrapper = Wrapper.forBasicType(c2);
            MemberName memberName = new MemberName(LambdaForm.class, "zero" + c2, MethodType.methodType(wrapper.primitiveType()), 6);
            try {
                memberName = IMPL_NAMES.resolveOrFail((byte)6, memberName, null, NoSuchMethodException.class);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                throw MethodHandleStatics.newInternalError((Throwable)reflectiveOperationException);
            }
            NamedFunction namedFunction = new NamedFunction(memberName);
            Name name = new Name(namedFunction, new Object[0]).newIndex(0);
            assert (name.type == ALL_TYPES.charAt(n));
            LambdaForm.CONSTANT_ZERO[n] = name;
            assert (name.isConstantZero());
        }
        PREPARED_FORMS.putAll(LambdaForm.computeInitialPreparedForms());
        NamedFunction.initializeInvokers();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Compiled {
    }

    static final class Name {
        final BasicType type;
        @Stable
        short index;
        final NamedFunction function;
        final Object constraint;
        @Stable
        final Object[] arguments;
        private static final Object[] EMPTY_ARGS = new Object[0];

        private Name(int index, BasicType type, NamedFunction function, Object[] arguments) {
            this.index = (short)index;
            this.type = type;
            this.function = function;
            this.arguments = arguments;
            this.constraint = null;
            assert (this.index == index && this.typesMatch(function, this.arguments));
        }

        private Name(Name that, Object constraint) {
            this.index = that.index;
            this.type = that.type;
            this.function = that.function;
            this.arguments = that.arguments;
            this.constraint = constraint;
            assert (constraint == null || this.isParam());
            assert (constraint == null || constraint instanceof ClassSpecializer.SpeciesData || constraint instanceof Class);
        }

        Name(MethodHandle function, Object ... arguments) {
            this(new NamedFunction(function), arguments);
        }

        Name(MethodType functionType, Object ... arguments) {
            this(new NamedFunction(functionType), arguments);
            assert (arguments[0] instanceof Name && ((Name)arguments[0]).type == BasicType.L_TYPE);
        }

        Name(MemberName function, Object ... arguments) {
            this(new NamedFunction(function), arguments);
        }

        Name(NamedFunction function) {
            this(-1, function.returnType(), function, EMPTY_ARGS);
        }

        Name(NamedFunction function, Object arg) {
            this(-1, function.returnType(), function, new Object[]{arg});
        }

        Name(NamedFunction function, Object arg0, Object arg1) {
            this(-1, function.returnType(), function, new Object[]{arg0, arg1});
        }

        Name(NamedFunction function, Object ... arguments) {
            this(-1, function.returnType(), function, (Object[])Arrays.copyOf(arguments, arguments.length, Object[].class));
        }

        Name(int index, BasicType type) {
            this(index, type, null, null);
        }

        Name(BasicType type) {
            this(-1, type);
        }

        BasicType type() {
            return this.type;
        }

        int index() {
            return this.index;
        }

        boolean initIndex(int i) {
            if (this.index != i) {
                if (this.index != -1) {
                    return false;
                }
                this.index = (short)i;
            }
            return true;
        }

        char typeChar() {
            return this.type.btChar;
        }

        Name newIndex(int i) {
            if (this.initIndex(i)) {
                return this;
            }
            return this.cloneWithIndex(i);
        }

        Name cloneWithIndex(int i) {
            Object[] newArguments = this.arguments == null ? null : (Object[])this.arguments.clone();
            return new Name(i, this.type, this.function, newArguments).withConstraint(this.constraint);
        }

        Name withConstraint(Object constraint) {
            if (constraint == this.constraint) {
                return this;
            }
            return new Name(this, constraint);
        }

        Name replaceName(Name oldName, Name newName) {
            if (oldName == newName) {
                return this;
            }
            Object[] arguments = this.arguments;
            if (arguments == null) {
                return this;
            }
            boolean replaced = false;
            for (int j = 0; j < arguments.length; ++j) {
                if (arguments[j] != oldName) continue;
                if (!replaced) {
                    replaced = true;
                    arguments = (Object[])arguments.clone();
                }
                arguments[j] = newName;
            }
            if (!replaced) {
                return this;
            }
            return new Name(this.function, arguments);
        }

        Name replaceNames(Name[] oldNames, Name[] newNames, int start, int end) {
            if (start >= end) {
                return this;
            }
            Object[] arguments = this.arguments;
            boolean replaced = false;
            block0: for (int j = 0; j < arguments.length; ++j) {
                Object object = arguments[j];
                if (!(object instanceof Name)) continue;
                Name n = (Name)object;
                short check = n.index;
                if (check >= 0 && check < newNames.length && n == newNames[check]) continue;
                for (int i = start; i < end; ++i) {
                    if (n != oldNames[i]) continue;
                    if (n == newNames[i]) continue block0;
                    if (!replaced) {
                        replaced = true;
                        arguments = (Object[])arguments.clone();
                    }
                    arguments[j] = newNames[i];
                    continue block0;
                }
            }
            if (!replaced) {
                return this;
            }
            return new Name(this.function, arguments);
        }

        void internArguments() {
            Object[] arguments = this.arguments;
            for (int j = 0; j < arguments.length; ++j) {
                Name n;
                Object object = arguments[j];
                if (!(object instanceof Name) || !(n = (Name)object).isParam() || n.index >= 10) continue;
                arguments[j] = LambdaForm.internArgument(n);
            }
        }

        boolean isParam() {
            return this.function == null;
        }

        boolean isConstantZero() {
            return !this.isParam() && this.arguments.length == 0 && this.function.isConstantZero();
        }

        boolean refersTo(Class<?> declaringClass, String methodName) {
            return this.function != null && this.function.member() != null && this.function.member().refersTo(declaringClass, methodName);
        }

        boolean isInvokeBasic() {
            if (this.function == null) {
                return false;
            }
            if (this.arguments.length < 1) {
                return false;
            }
            MemberName member = this.function.member();
            return member != null && member.refersTo(MethodHandle.class, "invokeBasic") && !member.isPublic() && !member.isStatic();
        }

        boolean isLinkerMethodInvoke() {
            if (this.function == null) {
                return false;
            }
            if (this.arguments.length < 1) {
                return false;
            }
            MemberName member = this.function.member();
            return member != null && member.getDeclaringClass() == MethodHandle.class && !member.isPublic() && member.isStatic() && member.getName().startsWith("linkTo");
        }

        public String toString() {
            return (this.isParam() ? "a" : "t") + (this.index >= 0 ? this.index : System.identityHashCode(this)) + ":" + this.typeChar();
        }

        public String debugString() {
            String s = this.paramString();
            return this.function == null ? s : s + "=" + this.exprString();
        }

        public String paramString() {
            String s = this.toString();
            Object c = this.constraint;
            if (c == null) {
                return s;
            }
            if (c instanceof Class) {
                c = ((Class)c).getSimpleName();
            }
            return s + "/" + c;
        }

        public String exprString() {
            if (this.function == null) {
                return this.toString();
            }
            StringBuilder buf = new StringBuilder(this.function.toString());
            buf.append("(");
            String cma = "";
            for (Object a : this.arguments) {
                buf.append(cma);
                cma = ",";
                if (a instanceof Name || a instanceof Integer) {
                    buf.append(a);
                    continue;
                }
                buf.append("(").append(a).append(")");
            }
            buf.append(")");
            return buf.toString();
        }

        private boolean typesMatch(NamedFunction function, Object ... arguments) {
            if (arguments == null) {
                assert (function == null);
                return true;
            }
            assert (arguments.length == function.arity()) : "arity mismatch: arguments.length=" + arguments.length + " == function.arity()=" + function.arity() + " in " + this.debugString();
            for (int i = 0; i < arguments.length; ++i) {
                assert (Name.typesMatch(function.parameterType(i), arguments[i])) : "types don't match: function.parameterType(" + i + ")=" + (Object)((Object)function.parameterType(i)) + ", arguments[" + i + "]=" + arguments[i] + " in " + this.debugString();
            }
            return true;
        }

        private static boolean typesMatch(BasicType parameterType, Object object) {
            if (object instanceof Name) {
                return ((Name)object).type == parameterType;
            }
            switch (parameterType.ordinal()) {
                case 1: {
                    return object instanceof Integer;
                }
                case 2: {
                    return object instanceof Long;
                }
                case 3: {
                    return object instanceof Float;
                }
                case 4: {
                    return object instanceof Double;
                }
            }
            assert (parameterType == BasicType.L_TYPE);
            return true;
        }

        int lastUseIndex(Name n) {
            if (this.arguments == null) {
                return -1;
            }
            int i = this.arguments.length;
            while (--i >= 0) {
                if (this.arguments[i] != n) continue;
                return i;
            }
            return -1;
        }

        int useCount(Name n) {
            int count = 0;
            if (this.arguments != null) {
                for (Object argument : this.arguments) {
                    if (argument != n) continue;
                    ++count;
                }
            }
            return count;
        }

        public boolean equals(Name that) {
            if (this == that) {
                return true;
            }
            if (this.isParam()) {
                return false;
            }
            return this.type == that.type && this.function.equals(that.function) && Arrays.equals(this.arguments, that.arguments);
        }

        public boolean equals(Object x) {
            return x instanceof Name && this.equals((Name)x);
        }

        public int hashCode() {
            if (this.isParam()) {
                return this.index | this.type.ordinal() << 8;
            }
            return this.function.hashCode() ^ Arrays.hashCode(this.arguments);
        }
    }

    static class NamedFunction {
        final MemberName member;
        @Stable
        private MethodHandle resolvedHandle;
        @Stable
        private MethodType type;
        static final MethodType INVOKER_METHOD_TYPE = MethodType.methodType(Object.class, MethodHandle.class, Object[].class);

        NamedFunction(MethodHandle resolvedHandle) {
            this(resolvedHandle.internalMemberName(), resolvedHandle);
        }

        NamedFunction(MemberName member, MethodHandle resolvedHandle) {
            this.member = member;
            this.resolvedHandle = resolvedHandle;
        }

        NamedFunction(MethodType basicInvokerType) {
            assert (basicInvokerType == basicInvokerType.basicType()) : basicInvokerType;
            if (basicInvokerType.parameterSlotCount() < 253) {
                this.resolvedHandle = basicInvokerType.invokers().basicInvoker();
                this.member = this.resolvedHandle.internalMemberName();
            } else {
                this.member = Invokers.invokeBasicMethod(basicInvokerType);
            }
            assert (NamedFunction.isInvokeBasic(this.member));
        }

        private static boolean isInvokeBasic(MemberName member) {
            return member != null && member.getDeclaringClass() == MethodHandle.class && "invokeBasic".equals(member.getName());
        }

        NamedFunction(Method method) {
            this(new MemberName(method));
        }

        NamedFunction(MemberName member) {
            this(member, null);
        }

        MethodHandle resolvedHandle() {
            if (this.resolvedHandle == null) {
                this.resolve();
            }
            return this.resolvedHandle;
        }

        synchronized void resolve() {
            if (this.resolvedHandle == null) {
                this.resolvedHandle = DirectMethodHandle.make(this.member);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof NamedFunction)) return false;
            NamedFunction that = (NamedFunction)other;
            if (this.member == null) return false;
            if (!this.member.equals(that.member)) return false;
            return true;
        }

        public int hashCode() {
            if (this.member != null) {
                return this.member.hashCode();
            }
            return super.hashCode();
        }

        private static MethodHandle computeInvoker(MethodTypeForm typeForm) {
            MethodHandle mh = (typeForm = typeForm.basicType().form()).cachedMethodHandle(1);
            if (mh != null) {
                return mh;
            }
            MemberName invoker = InvokerBytecodeGenerator.generateNamedFunctionInvoker(typeForm);
            mh = DirectMethodHandle.make(invoker);
            MethodHandle mh2 = typeForm.cachedMethodHandle(1);
            if (mh2 != null) {
                return mh2;
            }
            if (!mh.type().equals((Object)INVOKER_METHOD_TYPE)) {
                throw MethodHandleStatics.newInternalError(mh.debugString());
            }
            return typeForm.setCachedMethodHandle(1, mh);
        }

        @jdk.internal.vm.annotation.Hidden
        Object invokeWithArguments(Object ... arguments) throws Throwable {
            if (TRACE_INTERPRETER) {
                return this.invokeWithArgumentsTracing(arguments);
            }
            return this.invoker().invokeBasic(this.resolvedHandle(), arguments);
        }

        @jdk.internal.vm.annotation.Hidden
        Object invokeWithArgumentsTracing(Object[] arguments) throws Throwable {
            Object rval;
            try {
                LambdaForm.traceInterpreter("[ call", this, arguments);
                if (this.resolvedHandle == null) {
                    LambdaForm.traceInterpreter("| resolve", this);
                    this.resolvedHandle();
                }
                rval = this.invoker().invokeBasic(this.resolvedHandle(), arguments);
            }
            catch (Throwable ex) {
                LambdaForm.traceInterpreter("] throw =>", ex);
                throw ex;
            }
            LambdaForm.traceInterpreter("] return =>", rval);
            return rval;
        }

        private MethodHandle invoker() {
            return NamedFunction.computeInvoker(this.methodType().form());
        }

        MethodType methodType() {
            MethodType type = this.type;
            if (type == null) {
                this.type = type = NamedFunction.calculateMethodType(this.member, this.resolvedHandle);
            }
            return type;
        }

        private static MethodType calculateMethodType(MemberName member, MethodHandle resolvedHandle) {
            if (resolvedHandle != null) {
                return resolvedHandle.type();
            }
            return member.getInvocationType();
        }

        MemberName member() {
            assert (this.assertMemberIsConsistent());
            return this.member;
        }

        private boolean assertMemberIsConsistent() {
            if (this.resolvedHandle instanceof DirectMethodHandle) {
                MemberName m = this.resolvedHandle.internalMemberName();
                assert (m.equals(this.member));
            }
            return true;
        }

        Class<?> memberDeclaringClassOrNull() {
            return this.member == null ? null : this.member.getDeclaringClass();
        }

        BasicType returnType() {
            return BasicType.basicType(this.methodType().returnType());
        }

        BasicType parameterType(int n) {
            return BasicType.basicType(this.methodType().parameterType(n));
        }

        int arity() {
            return this.methodType().parameterCount();
        }

        public String toString() {
            if (this.member == null) {
                return String.valueOf(this.resolvedHandle);
            }
            return this.member.getDeclaringClass().getSimpleName() + "." + this.member.getName();
        }

        public boolean isIdentity() {
            return this.equals(LambdaForm.identity((BasicType)this.returnType()));
        }

        public boolean isConstantZero() {
            return this.equals(LambdaForm.constantZero((BasicType)this.returnType()));
        }

        public MethodHandleImpl.Intrinsic intrinsicName() {
            return this.resolvedHandle != null ? this.resolvedHandle.intrinsicName() : MethodHandleImpl.Intrinsic.NONE;
        }

        public Object intrinsicData() {
            return this.resolvedHandle != null ? this.resolvedHandle.intrinsicData() : null;
        }
    }
}

