/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.security.AccessController;
import java.util.concurrent.TimeUnit;
import sun.misc.Unsafe;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;
import sun.security.action.GetPropertyAction;

class WindowsFileAttributes
implements DosFileAttributes {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final short SIZEOF_FILE_INFORMATION = 52;
    private static final short OFFSETOF_FILE_INFORMATION_ATTRIBUTES = 0;
    private static final short OFFSETOF_FILE_INFORMATION_CREATETIME = 4;
    private static final short OFFSETOF_FILE_INFORMATION_LASTACCESSTIME = 12;
    private static final short OFFSETOF_FILE_INFORMATION_LASTWRITETIME = 20;
    private static final short OFFSETOF_FILE_INFORMATION_VOLSERIALNUM = 28;
    private static final short OFFSETOF_FILE_INFORMATION_SIZEHIGH = 32;
    private static final short OFFSETOF_FILE_INFORMATION_SIZELOW = 36;
    private static final short OFFSETOF_FILE_INFORMATION_INDEXHIGH = 44;
    private static final short OFFSETOF_FILE_INFORMATION_INDEXLOW = 48;
    private static final short SIZEOF_FILE_ATTRIBUTE_DATA = 36;
    private static final short OFFSETOF_FILE_ATTRIBUTE_DATA_ATTRIBUTES = 0;
    private static final short OFFSETOF_FILE_ATTRIBUTE_DATA_CREATETIME = 4;
    private static final short OFFSETOF_FILE_ATTRIBUTE_DATA_LASTACCESSTIME = 12;
    private static final short OFFSETOF_FILE_ATTRIBUTE_DATA_LASTWRITETIME = 20;
    private static final short OFFSETOF_FILE_ATTRIBUTE_DATA_SIZEHIGH = 28;
    private static final short OFFSETOF_FILE_ATTRIBUTE_DATA_SIZELOW = 32;
    private static final short SIZEOF_FIND_DATA = 592;
    private static final short OFFSETOF_FIND_DATA_ATTRIBUTES = 0;
    private static final short OFFSETOF_FIND_DATA_CREATETIME = 4;
    private static final short OFFSETOF_FIND_DATA_LASTACCESSTIME = 12;
    private static final short OFFSETOF_FIND_DATA_LASTWRITETIME = 20;
    private static final short OFFSETOF_FIND_DATA_SIZEHIGH = 28;
    private static final short OFFSETOF_FIND_DATA_SIZELOW = 32;
    private static final short OFFSETOF_FIND_DATA_RESERVED0 = 36;
    private static final long WINDOWS_EPOCH_IN_MICROSECONDS = -11644473600000000L;
    private static final boolean ensureAccurateMetadata;
    private final int fileAttrs;
    private final long creationTime;
    private final long lastAccessTime;
    private final long lastWriteTime;
    private final long size;
    private final int reparseTag;
    private final int volSerialNumber;
    private final int fileIndexHigh;
    private final int fileIndexLow;

    static FileTime toFileTime(long l) {
        l /= 10L;
        return FileTime.from(l += -11644473600000000L, TimeUnit.MICROSECONDS);
    }

    static long toWindowsTime(FileTime fileTime) {
        long l = fileTime.to(TimeUnit.MICROSECONDS);
        l -= -11644473600000000L;
        return l *= 10L;
    }

    private WindowsFileAttributes(int n, long l, long l2, long l3, long l4, int n2, int n3, int n4, int n5) {
        this.fileAttrs = n;
        this.creationTime = l;
        this.lastAccessTime = l2;
        this.lastWriteTime = l3;
        this.size = l4;
        this.reparseTag = n2;
        this.volSerialNumber = n3;
        this.fileIndexHigh = n4;
        this.fileIndexLow = n5;
    }

    private static WindowsFileAttributes fromFileInformation(long l, int n) {
        int n2 = unsafe.getInt(l + 0L);
        long l2 = unsafe.getLong(l + 4L);
        long l3 = unsafe.getLong(l + 12L);
        long l4 = unsafe.getLong(l + 20L);
        long l5 = ((long)unsafe.getInt(l + 32L) << 32) + ((long)unsafe.getInt(l + 36L) & 0xFFFFFFFFL);
        int n3 = unsafe.getInt(l + 28L);
        int n4 = unsafe.getInt(l + 44L);
        int n5 = unsafe.getInt(l + 48L);
        return new WindowsFileAttributes(n2, l2, l3, l4, l5, n, n3, n4, n5);
    }

    private static WindowsFileAttributes fromFileAttributeData(long l, int n) {
        int n2 = unsafe.getInt(l + 0L);
        long l2 = unsafe.getLong(l + 4L);
        long l3 = unsafe.getLong(l + 12L);
        long l4 = unsafe.getLong(l + 20L);
        long l5 = ((long)unsafe.getInt(l + 28L) << 32) + ((long)unsafe.getInt(l + 32L) & 0xFFFFFFFFL);
        return new WindowsFileAttributes(n2, l2, l3, l4, l5, n, 0, 0, 0);
    }

    static NativeBuffer getBufferForFindData() {
        return NativeBuffers.getNativeBuffer(592);
    }

    static WindowsFileAttributes fromFindData(long l) {
        int n = unsafe.getInt(l + 0L);
        long l2 = unsafe.getLong(l + 4L);
        long l3 = unsafe.getLong(l + 12L);
        long l4 = unsafe.getLong(l + 20L);
        long l5 = ((long)unsafe.getInt(l + 28L) << 32) + ((long)unsafe.getInt(l + 32L) & 0xFFFFFFFFL);
        int n2 = WindowsFileAttributes.isReparsePoint(n) ? unsafe.getInt(l + 36L) : 0;
        return new WindowsFileAttributes(n, l2, l3, l4, l5, n2, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WindowsFileAttributes readAttributes(long l) throws WindowsException {
        NativeBuffer nativeBuffer = NativeBuffers.getNativeBuffer(52);
        try {
            long l2 = nativeBuffer.address();
            WindowsNativeDispatcher.GetFileInformationByHandle(l, l2);
            int n = 0;
            int n2 = unsafe.getInt(l2 + 0L);
            if (WindowsFileAttributes.isReparsePoint(n2)) {
                int n3 = 16384;
                NativeBuffer nativeBuffer2 = NativeBuffers.getNativeBuffer(n3);
                try {
                    WindowsNativeDispatcher.DeviceIoControlGetReparsePoint(l, nativeBuffer2.address(), n3);
                    n = (int)unsafe.getLong(nativeBuffer2.address());
                }
                finally {
                    nativeBuffer2.release();
                }
            }
            WindowsFileAttributes windowsFileAttributes = WindowsFileAttributes.fromFileInformation(l2, n);
            return windowsFileAttributes;
        }
        finally {
            nativeBuffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WindowsFileAttributes get(WindowsPath windowsPath, boolean bl) throws WindowsException {
        if (!ensureAccurateMetadata) {
            WindowsException windowsException = null;
            NativeBuffer nativeBuffer = NativeBuffers.getNativeBuffer(36);
            try {
                long l = nativeBuffer.address();
                WindowsNativeDispatcher.GetFileAttributesEx(windowsPath.getPathForWin32Calls(), l);
                int n = unsafe.getInt(l + 0L);
                if (!WindowsFileAttributes.isReparsePoint(n)) {
                    WindowsFileAttributes windowsFileAttributes = WindowsFileAttributes.fromFileAttributeData(l, 0);
                    return windowsFileAttributes;
                }
            }
            catch (WindowsException windowsException2) {
                if (windowsException2.lastError() != 32) {
                    throw windowsException2;
                }
                windowsException = windowsException2;
            }
            finally {
                nativeBuffer.release();
            }
            if (windowsException != null) {
                String string = windowsPath.getPathForWin32Calls();
                char c = string.charAt(string.length() - 1);
                if (c == ':' || c == '\\') {
                    throw windowsException;
                }
                nativeBuffer = WindowsFileAttributes.getBufferForFindData();
                try {
                    long l = WindowsNativeDispatcher.FindFirstFile(string, nativeBuffer.address());
                    WindowsNativeDispatcher.FindClose(l);
                    WindowsFileAttributes windowsFileAttributes = WindowsFileAttributes.fromFindData(nativeBuffer.address());
                    if (windowsFileAttributes.isReparsePoint()) {
                        throw windowsException;
                    }
                    WindowsFileAttributes windowsFileAttributes2 = windowsFileAttributes;
                    return windowsFileAttributes2;
                }
                catch (WindowsException windowsException3) {
                    throw windowsException;
                }
                finally {
                    nativeBuffer.release();
                }
            }
        }
        long l = windowsPath.openForReadAttributeAccess(bl);
        try {
            WindowsFileAttributes windowsFileAttributes = WindowsFileAttributes.readAttributes(l);
            return windowsFileAttributes;
        }
        finally {
            WindowsNativeDispatcher.CloseHandle(l);
        }
    }

    static boolean isSameFile(WindowsFileAttributes windowsFileAttributes, WindowsFileAttributes windowsFileAttributes2) {
        return windowsFileAttributes.volSerialNumber == windowsFileAttributes2.volSerialNumber && windowsFileAttributes.fileIndexHigh == windowsFileAttributes2.fileIndexHigh && windowsFileAttributes.fileIndexLow == windowsFileAttributes2.fileIndexLow;
    }

    static boolean isReparsePoint(int n) {
        return (n & 0x400) != 0;
    }

    int attributes() {
        return this.fileAttrs;
    }

    int volSerialNumber() {
        if (this.volSerialNumber == 0) {
            throw new AssertionError((Object)"Should not get here");
        }
        return this.volSerialNumber;
    }

    int fileIndexHigh() {
        if (this.volSerialNumber == 0) {
            throw new AssertionError((Object)"Should not get here");
        }
        return this.fileIndexHigh;
    }

    int fileIndexLow() {
        if (this.volSerialNumber == 0) {
            throw new AssertionError((Object)"Should not get here");
        }
        return this.fileIndexLow;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public FileTime lastModifiedTime() {
        return WindowsFileAttributes.toFileTime(this.lastWriteTime);
    }

    @Override
    public FileTime lastAccessTime() {
        return WindowsFileAttributes.toFileTime(this.lastAccessTime);
    }

    @Override
    public FileTime creationTime() {
        return WindowsFileAttributes.toFileTime(this.creationTime);
    }

    @Override
    public Object fileKey() {
        return null;
    }

    boolean isReparsePoint() {
        return WindowsFileAttributes.isReparsePoint(this.fileAttrs);
    }

    boolean isDirectoryLink() {
        return this.isSymbolicLink() && (this.fileAttrs & 0x10) != 0;
    }

    @Override
    public boolean isSymbolicLink() {
        return this.reparseTag == -1610612724;
    }

    @Override
    public boolean isDirectory() {
        if (this.isSymbolicLink()) {
            return false;
        }
        return (this.fileAttrs & 0x10) != 0;
    }

    @Override
    public boolean isOther() {
        if (this.isSymbolicLink()) {
            return false;
        }
        return (this.fileAttrs & 0x440) != 0;
    }

    @Override
    public boolean isRegularFile() {
        return !this.isSymbolicLink() && !this.isDirectory() && !this.isOther();
    }

    @Override
    public boolean isReadOnly() {
        return (this.fileAttrs & 1) != 0;
    }

    @Override
    public boolean isHidden() {
        return (this.fileAttrs & 2) != 0;
    }

    @Override
    public boolean isArchive() {
        return (this.fileAttrs & 0x20) != 0;
    }

    @Override
    public boolean isSystem() {
        return (this.fileAttrs & 4) != 0;
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.nio.fs.ensureAccurateMetadata", "false"));
        ensureAccurateMetadata = string.length() == 0 ? true : Boolean.valueOf(string);
    }
}

