/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import sun.security.internal.spec.TlsMasterSecretParameterSpec;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11SecretKeyFactory;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_SSL3_MASTER_KEY_DERIVE_PARAMS;
import sun.security.pkcs11.wrapper.CK_SSL3_RANDOM_DATA;
import sun.security.pkcs11.wrapper.CK_TLS12_MASTER_KEY_DERIVE_PARAMS;
import sun.security.pkcs11.wrapper.CK_VERSION;
import sun.security.pkcs11.wrapper.Functions;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public final class P11TlsMasterSecretGenerator
extends KeyGeneratorSpi {
    private static final String MSG = "TlsMasterSecretGenerator must be initialized using a TlsMasterSecretParameterSpec";
    private final Token token;
    private final String algorithm;
    private long mechanism;
    private TlsMasterSecretParameterSpec spec;
    private P11Key p11Key;
    int version;

    P11TlsMasterSecretGenerator(Token token, String algorithm, long mechanism) throws PKCS11Exception {
        this.token = token;
        this.algorithm = algorithm;
        this.mechanism = mechanism;
    }

    @Override
    protected void engineInit(SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof TlsMasterSecretParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsMasterSecretParameterSpec)params;
        SecretKey key = this.spec.getPremasterSecret();
        try {
            this.p11Key = P11SecretKeyFactory.convertKey(this.token, key, null);
        }
        catch (InvalidKeyException e) {
            throw new InvalidAlgorithmParameterException("init() failed", e);
        }
        this.version = this.spec.getMajorVersion() << 8 | this.spec.getMinorVersion();
        if (this.version < 768 && this.version > 771) {
            throw new InvalidAlgorithmParameterException("Only SSL 3.0, TLS 1.0, TLS 1.1, and TLS 1.2 are supported");
        }
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        Object params;
        if (this.spec == null) {
            throw new IllegalStateException("TlsMasterSecretGenerator must be initialized");
        }
        boolean isTlsRsaPremasterSecret = this.p11Key.getAlgorithm().equals("TlsRsaPremasterSecret");
        if (this.version == 768) {
            this.mechanism = isTlsRsaPremasterSecret ? 881L : 883L;
        } else if (this.version == 769 || this.version == 770) {
            this.mechanism = isTlsRsaPremasterSecret ? 885L : 887L;
        } else if (this.version == 771) {
            this.mechanism = isTlsRsaPremasterSecret ? 992L : 994L;
        }
        CK_VERSION ckVersion = isTlsRsaPremasterSecret ? new CK_VERSION(0, 0) : null;
        byte[] clientRandom = this.spec.getClientRandom();
        byte[] serverRandom = this.spec.getServerRandom();
        CK_SSL3_RANDOM_DATA random = new CK_SSL3_RANDOM_DATA(clientRandom, serverRandom);
        CK_MECHANISM ckMechanism = null;
        if (this.version < 771) {
            params = new CK_SSL3_MASTER_KEY_DERIVE_PARAMS(random, ckVersion);
            ckMechanism = new CK_MECHANISM(this.mechanism, (CK_SSL3_MASTER_KEY_DERIVE_PARAMS)params);
        } else if (this.version == 771) {
            params = new CK_TLS12_MASTER_KEY_DERIVE_PARAMS(random, ckVersion, Functions.getHashMechId(this.spec.getPRFHashAlg()));
            ckMechanism = new CK_MECHANISM(this.mechanism, (CK_TLS12_MASTER_KEY_DERIVE_PARAMS)params);
        }
        Session session = null;
        long p11KeyID = this.p11Key.getKeyID();
        try {
            int minor;
            int major;
            session = this.token.getObjSession();
            CK_ATTRIBUTE[] attributes = this.token.getAttributes("generate", 4L, 16L, new CK_ATTRIBUTE[0]);
            long keyID = this.token.p11.C_DeriveKey(session.id(), ckMechanism, p11KeyID, attributes);
            if (ckVersion == null) {
                major = -1;
                minor = -1;
            } else {
                major = ckVersion.major;
                minor = ckVersion.minor;
            }
            SecretKey secretKey = P11Key.masterSecretKey(session, keyID, "TlsMasterSecret", 384, attributes, major, minor);
            return secretKey;
        }
        catch (Exception e) {
            throw new ProviderException("Could not generate key", e);
        }
        finally {
            this.p11Key.releaseKeyID();
            this.token.releaseSession(session);
        }
    }
}

