/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.posid.remote.PosIDFaceConsumeDeviceCommandRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDDeviceService;
import com.zkteco.zkbiosecurity.posid.service.PosIDFaceConsumeDeviceCommandService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDDeviceItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDFaceConsumeDeviceCommandItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDFaceConsumeDeviceCommandController
extends ExportController
implements PosIDFaceConsumeDeviceCommandRemote {
    @Autowired
    private PosIDFaceConsumeDeviceCommandService posIDFaceConsumeDeviceCommandService;
    @Autowired
    private PosIDDeviceService posIDDeviceService;

    @RequiresPermissions(value={"posid:faceConsumeDevice:getCmd"})
    public ModelAndView index(String deviceId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("deviceId", deviceId);
        return new ModelAndView("posid/faceConsumeDeviceCommand/posIDFaceConsumeDeviceCommand", param);
    }

    @RequiresPermissions(value={"posid:faceConsumeDevice:getCmd"})
    public DxGrid list(String deviceId, PosIDFaceConsumeDeviceCommandItem posIDFaceConsumeDeviceCommandItem) {
        PosIDDeviceItem posIDDeviceItem = this.posIDDeviceService.getItemById(deviceId);
        if (null != posIDDeviceItem) {
            posIDFaceConsumeDeviceCommandItem.setSn(posIDDeviceItem.getSn());
        }
        Pager pager = this.posIDFaceConsumeDeviceCommandService.getItemsByPage((BaseItem)posIDFaceConsumeDeviceCommandItem, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, posIDFaceConsumeDeviceCommandItem.getClass());
    }

    @RequiresPermissions(value={"posid:faceConsumeDevice:getCmd"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", this.posIDFaceConsumeDeviceCommandService.getItemById(id));
        }
        return new ModelAndView("posid/faceConsumeDeviceCommand/editPosIDFaceConsumeDeviceCommand");
    }

    @RequiresPermissions(value={"posid:faceConsumeDevice:cmdDel"})
    public ZKResultMsg delByDeviceId(String deviceId) {
        PosIDDeviceItem posIDDeviceItem = this.posIDDeviceService.getItemById(deviceId);
        if (null == posIDDeviceItem) {
            return ZKResultMsg.failMsg();
        }
        return this.posIDFaceConsumeDeviceCommandService.delByDeviceId(posIDDeviceItem.getSn());
    }
}

