/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.posid.remote.PosIDOpenAccountRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDAccountService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDOpenAccountSelectItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDOpenAccountController
extends BaseController
implements PosIDOpenAccountRemote {
    @Autowired
    private PosIDAccountService posIDAccountService;

    @RequiresPermissions(value={"posid:openAccount:edit"})
    public ModelAndView edit() {
        return new ModelAndView("posid/openAccount/editPosIDOpenAccount");
    }

    @RequiresPermissions(value={"posid:openAccount:edit"})
    public ZKResultMsg save() {
        String personIds = this.request.getParameter("personIds");
        ZKResultMsg res = this.posIDAccountService.openAccount(personIds);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid selectOpemAccountPerson(PosIDOpenAccountSelectItem condition) {
        Pager pager = new Pager();
        if ("noSelected".equals(condition.getType())) {
            pager = this.posIDAccountService.selectOpemAccountPerson(condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        } else if ("selected".equals(condition.getType())) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

