/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.posid.remote.PosIDPersonRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDAccountKindService;
import com.zkteco.zkbiosecurity.posid.service.PosIDAccountService;
import com.zkteco.zkbiosecurity.posid.service.PosIDSystemParamService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDAccountItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDAccountKindItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDPersonController
extends BaseController
implements PosIDPersonRemote {
    @Autowired
    private PosIDAccountService posIDAccountService;
    @Autowired
    private PosIDSystemParamService posIDSystemParamService;
    @Autowired
    private PosIDAccountKindService posIDAccountKindService;

    @RequiresPermissions(value={"posid:person:view"})
    public ModelAndView index() {
        return new ModelAndView("posid/person/posIDPerson");
    }

    @RequiresPermissions(value={"posid:person:edit"})
    public ModelAndView edit(@RequestParam(value="personId", required=false) String personId) {
        if (StringUtils.isNotBlank((CharSequence)personId)) {
            this.request.setAttribute("item", (Object)this.posIDAccountService.getItemByPersonId(personId));
        }
        String cardKindId = ((PosIDAccountKindItem)this.posIDAccountKindService.getByCondition(new PosIDAccountKindItem()).get(0)).getId();
        this.request.setAttribute("posCardKindId", (Object)cardKindId);
        return new ModelAndView("posid/person/editPosIDPerson");
    }

    @RequiresPermissions(value={"posid:person:edit"})
    public ZKResultMsg save(PosIDAccountItem item) {
        ZKResultMsg res = new ZKResultMsg();
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg checkOfflineMode() {
        String offlineMode = (String)this.posIDSystemParamService.getPosParams().get("posid.offlineMode");
        ZKResultMsg res = new ZKResultMsg((Object)offlineMode);
        return res;
    }
}

