/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.constants.PsgConstants;
import com.zkteco.zkbiosecurity.psg.remote.PsgPadRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgBaseDictionaryService;
import com.zkteco.zkbiosecurity.psg.service.PsgDeviceService;
import com.zkteco.zkbiosecurity.psg.service.PsgPadService;
import com.zkteco.zkbiosecurity.psg.service.PsgRTMonitorService;
import com.zkteco.zkbiosecurity.psg.utils.PsgEnumUtil;
import com.zkteco.zkbiosecurity.psg.vo.PsgGateItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgGateOptionItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgTransactionItem;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class PsgPadController
extends BaseController
implements PsgPadRemote {
    private static final Logger log = LoggerFactory.getLogger(PsgPadController.class);
    @Autowired
    private PsgPadService psgPadService;
    @Autowired
    private PsgRTMonitorService psgRTMonitorService;
    @Autowired
    private PsgDeviceService psgDeviceService;
    @Autowired
    private PsgBaseDictionaryService psgBaseDictionaryService;

    public ZKResultMsg logout(@RequestParam(name="access_token") String token) {
        this.psgPadService.logout(token);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public ZKResultMsg getRtMonitorAllGates(@RequestParam(name="access_token") String token, @RequestBody JSONObject data) {
        String areaIds = data.getString("areaIds");
        String gateIds = data.getString("gateIds");
        List authAreaIdList = this.psgPadService.getAuthAreaIds(token, areaIds);
        JSONArray retData = new JSONArray();
        JSONObject dev = null;
        for (String authAreaId : authAreaIdList) {
            JSONObject gateStateJson = new JSONObject();
            JSONArray newGateStates = new JSONArray();
            JSONArray gateState = this.psgPadService.getGateStates(authAreaId, gateIds);
            JSONObject authAreaJson = this.psgPadService.getAuthAreaInfoById(authAreaId);
            if (Objects.nonNull(gateState) && gateState.size() > 0) {
                for (int i = 0; i < gateState.size(); ++i) {
                    JSONObject gate = gateState.getJSONObject(i);
                    dev = this.putGateDataToMonitor(gate);
                    newGateStates.add((Object)dev);
                }
            }
            if (newGateStates.size() <= 0) continue;
            gateStateJson.put("gates", (Object)newGateStates);
            gateStateJson.put("areaId", authAreaJson.get((Object)"id"));
            gateStateJson.put("areaName", authAreaJson.get((Object)"name"));
            int counter = this.psgPadService.countAllGateInCount(areaIds);
            gateStateJson.put("counter", (Object)counter);
            retData.add((Object)gateStateJson);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)retData));
    }

    private JSONObject putGateDataToMonitor(JSONObject gate) {
        JSONObject data = new JSONObject();
        int alarm = gate.getIntValue("alarm");
        data.put("id", (Object)gate.getString("id"));
        data.put("name", (Object)gate.getString("name"));
        data.put("gateType", (Object)gate.getString("gateType"));
        data.put("relay", (Object)gate.getIntValue("relay"));
        data.put("alarm", (Object)PsgEnumUtil.GateImage.getAlarmState(alarm));
        data.put("gateState", (Object)gate.getIntValue("gateState"));
        data.put("connect", (Object)gate.getIntValue("connect"));
        data.put("passMode", (Object)gate.getIntValue("passMode"));
        data.put("inCount", (Object)(Objects.nonNull(gate.getIntValue("inCount")) ? gate.getIntValue("inCount") : 0));
        data.put("outCount", (Object)(Objects.nonNull(gate.getIntValue("outCount")) ? gate.getIntValue("outCount") : 0));
        data.put("alarmCount", (Object)(Objects.nonNull(gate.getIntValue("alarmCount")) ? gate.getIntValue("alarmCount") : 0));
        return data;
    }

    public ZKResultMsg openInGate(@RequestParam String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("openInGate", ids);
        return this.dealResultData(dataMap);
    }

    public ZKResultMsg openOutGate(@RequestParam String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("openOutGate", ids);
        return this.dealResultData(dataMap);
    }

    public ZKResultMsg lockGate(@RequestParam String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("lockGate", ids);
        return this.dealResultData(dataMap);
    }

    public ZKResultMsg unLockGate(@RequestParam String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("unLockGate", ids);
        return this.dealResultData(dataMap);
    }

    public ZKResultMsg normalOpenGate(@RequestParam String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("normalOpenGate", ids);
        return this.dealResultData(dataMap);
    }

    public ZKResultMsg disableNormalOpenGate(@RequestParam String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("disableNormalOpenGate", ids);
        return this.dealResultData(dataMap);
    }

    public ZKResultMsg reboot(@RequestParam String id) {
        ZKResultMsg ret = this.psgPadService.reboot(id);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public ZKResultMsg setGatePassMode(@RequestBody JSONObject data) {
        String id = data.getString("id");
        String passMode = data.getString("passMode");
        ZKResultMsg ret = this.psgPadService.setGatePassMode(id, passMode);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public ZKResultMsg switchPassRule(@RequestBody JSONObject data) {
        String id = data.getString("id");
        String passModeFunOn = data.getString("passModeFunOn");
        ZKResultMsg ret = this.psgPadService.switchPassRule(id, passModeFunOn);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public ZKResultMsg resetCounter(@RequestBody JSONObject data) {
        String id = data.getString("id");
        Integer modeNum = data.getIntValue("mode");
        String mode = (String)PsgConstants.RESET_COUNT_MODE.get(modeNum);
        Map dataMap = this.psgRTMonitorService.operateGate(mode, id);
        return this.dealResultData(dataMap);
    }

    private ZKResultMsg dealResultData(Map<String, String> dataMap) {
        String cmdIdData = dataMap.get("cmdId");
        String msg = "";
        ZKResultMsg resultMsg = new ZKResultMsg();
        if ("true".equals(dataMap.get("notExistDev"))) {
            msg = I18nUtil.i18nCode((String)"common_dev_opFaileAndReason", (Object[])new Object[0]) + I18nUtil.i18nCode((String)"common_dev_notExistDev", (Object[])new Object[0]);
            resultMsg.setMsg(msg);
            return resultMsg;
        }
        if (!"".equals(cmdIdData)) {
            for (String cmdData : cmdIdData.split(",")) {
                String cmdId = cmdData.split("=")[0];
                String doorName = cmdData.split("=")[1];
                Map resultMap = this.psgDeviceService.getCmdResultById(Long.valueOf(cmdId), 20);
                if (Objects.isNull(resultMap)) {
                    msg = msg + doorName + "," + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]);
                    continue;
                }
                Integer ret = Integer.valueOf((String)resultMap.get("result"));
                if (Objects.isNull(ret)) {
                    msg = msg + doorName + "," + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]);
                    continue;
                }
                if (ret >= 0) continue;
                String failedInfo = I18nUtil.i18nCode((String)this.psgBaseDictionaryService.getCommReason(ret.intValue()), (Object[])new Object[0]);
                msg = msg + doorName + "," + I18nUtil.i18nCode((String)"common_dev_opFaileAndReason", (Object[])new Object[0]) + failedInfo;
            }
        }
        if (!"".equals(dataMap.get("offline"))) {
            for (String gateName : dataMap.get("offline").split(",")) {
                msg = msg + gateName + "," + I18nUtil.i18nCode((String)"common_dev_offlinePrompt", (Object[])new Object[0]);
            }
        }
        if (!"".equals(dataMap.get("notSupport"))) {
            for (String gateName : dataMap.get("notSupport").split(",")) {
                msg = msg + gateName + "," + I18nUtil.i18nCode((String)"psg_dev_devNotSupportFunction", (Object[])new Object[0]);
            }
        }
        if (!"".equals(msg)) {
            resultMsg.setRet("400");
            resultMsg.setMsg(msg);
        }
        resultMsg.setData((Object)"");
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg getGateById(@RequestParam String id) {
        ZKResultMsg ret = this.psgPadService.getGateById(id);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public ZKResultMsg saveGateOptions(@RequestBody PsgGateOptionItem psgGateOptionItem) {
        this.psgPadService.saveGateOptions(psgGateOptionItem);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public ZKResultMsg syncGateOptions(@RequestBody PsgGateOptionItem psgGateOptionItem, @RequestParam(name="gateIds") String gateIds) {
        ZKResultMsg ret = this.psgPadService.syncGateOptions(psgGateOptionItem, gateIds);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public ZKResultMsg getLevelPersons(@RequestParam(name="access_token") String token, @RequestBody JSONObject data) {
        String userName = StringUtils.isNotBlank((CharSequence)data.getString("userName")) ? data.getString("userName") : "";
        String pin = StringUtils.isNotBlank((CharSequence)data.getString("pin")) ? data.getString("pin") : "";
        int pageNo = StringUtils.isNotBlank((CharSequence)data.getString("pageNo")) ? data.getIntValue("pageNo") : 0;
        int pageSize = StringUtils.isNotBlank((CharSequence)data.getString("pageSize")) ? data.getIntValue("pageSize") : 50;
        ZKResultMsg ret = this.psgPadService.getLevelPersons(token, userName, pin, pageNo, pageSize);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public ZKResultMsg getTransactions(@RequestParam(name="access_token") String token, @RequestBody JSONObject data) {
        int pageNo = StringUtils.isNotBlank((CharSequence)data.getString("pageNo")) ? data.getIntValue("pageNo") : 0;
        int pageSize = StringUtils.isNotBlank((CharSequence)data.getString("pageSize")) ? data.getIntValue("pageSize") : 50;
        PsgTransactionItem psgTransactionItem = new PsgTransactionItem();
        psgTransactionItem.setStartTime(DateUtil.stringToDate((String)data.getString("startTime"), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS));
        psgTransactionItem.setEndTime(DateUtil.stringToDate((String)data.getString("endTime"), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS));
        psgTransactionItem.setPin(data.getString("pin"));
        psgTransactionItem.setDevAlias(data.getString("devAlias"));
        psgTransactionItem.setEventName(data.getString("eventName"));
        ZKResultMsg ret = this.psgPadService.getTransactions(token, psgTransactionItem, pageNo, pageSize);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public ZKResultMsg getAuthAreaGateList(@RequestParam(name="access_token") String token) {
        ZKResultMsg ret = this.psgPadService.getAuthAreaGateList(token);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public ZKResultMsg getGateSelectList(@RequestParam(name="access_token") String token) {
        List psgGateItemList = this.psgPadService.getGateSelectList(token);
        JSONArray dataArray = new JSONArray();
        if (Objects.nonNull(psgGateItemList) && psgGateItemList.size() > 0) {
            for (PsgGateItem psgGateItem : psgGateItemList) {
                JSONObject gateJson = new JSONObject();
                gateJson.put("id", (Object)psgGateItem.getId());
                gateJson.put("name", (Object)psgGateItem.getName());
                dataArray.add((Object)gateJson);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)dataArray));
    }
}

