/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.monitor;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.constants.PsgConstants;
import com.zkteco.zkbiosecurity.psg.service.PsgGateService;
import com.zkteco.zkbiosecurity.psg.service.PsgMonitorRedirectService;
import com.zkteco.zkbiosecurity.psg.service.PsgPersonService;
import com.zkteco.zkbiosecurity.psg.service.PsgRTMonitorService;
import com.zkteco.zkbiosecurity.psg.utils.PsgEnumUtil;
import com.zkteco.zkbiosecurity.psg.vo.PsgDeviceEventItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgDeviceMonitorItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgGateItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgTransactionItem;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PsgMonitorRedirectServiceImpl
implements PsgMonitorRedirectService {
    @Autowired
    private SimpMessagingTemplate messagingTemplate;
    @Autowired
    private PsgRTMonitorService psgRTMonitorService;
    @Autowired
    private PsgGateService psgGateService;
    @Autowired
    private PsgPersonService psgPersonService;

    public void sendPsgTransaction2RTMonitor(PsgTransactionItem psgTransactionItem, Map<String, String> userData, PsgDeviceEventItem tempDevEvent) {
        PsgGateItem psgGate = this.psgGateService.getItemById(psgTransactionItem.getEventPointId());
        JSONObject ret = new JSONObject();
        JSONArray audios = new JSONArray();
        String tmpAudioPath = "";
        if (psgTransactionItem.getAudioFilePath() != null) {
            audios.add((Object)psgTransactionItem.getAudioFilePath());
        }
        if (!(!Objects.nonNull(psgGate) || Objects.nonNull(psgGate.getIsDisableAudio()) && psgGate.getIsDisableAudio().booleanValue())) {
            tmpAudioPath = this.getAudioPath(tempDevEvent);
        } else if (Objects.isNull(psgGate)) {
            tmpAudioPath = this.getAudioPath(tempDevEvent);
        }
        if (StringUtils.isNotBlank((CharSequence)tmpAudioPath)) {
            audios.add((Object)tmpAudioPath);
        } else if (StringUtils.isBlank((CharSequence)tmpAudioPath) && StringUtils.isBlank((CharSequence)psgTransactionItem.getAudioFilePath())) {
            audios.add(null);
        }
        ret.put("audios", (Object)audios);
        JSONArray rows = new JSONArray();
        JSONObject row = new JSONObject();
        row.put("id", (Object)psgTransactionItem.getUniqueKey());
        JSONObject userdata = this.buildUserDate(psgTransactionItem, userData);
        if (psgTransactionItem.getVidDevices() != null && psgTransactionItem.getVidDevices().size() > 0) {
            row.put("vidDescription", (Object)psgTransactionItem.getDescription());
            row.put("vidDevices", (Object)psgTransactionItem.getVidDevices());
        }
        row.put("userdata", (Object)userdata);
        row.put("style", (Object)(psgTransactionItem.getEventLevel() == 0 ? "color:green" : (psgTransactionItem.getEventLevel() == 1 ? "color:#E57A14" : "color:red")));
        JSONArray data = new JSONArray();
        data.add((Object)DateUtil.dateToString((Date)psgTransactionItem.getEventTime(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS));
        data.add((Object)I18nUtil.i18nCode((String)((String)PsgConstants.PASSAGE_GATE_TYPE.get(psgTransactionItem.getGateType())), (Object[])new Object[0]));
        data.add((Object)psgTransactionItem.getPassageName());
        data.add((Object)psgTransactionItem.getEventPointName());
        data.add((Object)psgTransactionItem.getEventName());
        data.add((Object)psgTransactionItem.getAreaName());
        String name = "";
        if (StringUtils.isNotBlank((CharSequence)psgTransactionItem.getName())) {
            name = psgTransactionItem.getName().trim();
            if (!this.psgRTMonitorService.checkIsChinaLanguage() && StringUtils.isNotBlank((CharSequence)psgTransactionItem.getLastName())) {
                name = (psgTransactionItem.getName() + " " + psgTransactionItem.getLastName()).trim();
            }
            name = "(" + name + ")";
        }
        data.add((Object)(psgTransactionItem.getPin() + name));
        data.add((Object)psgTransactionItem.getCardNo());
        data.add((Object)(psgTransactionItem.getDevAlias() != null ? psgTransactionItem.getDevAlias() + "(" + psgTransactionItem.getDevSn() + ")" : ""));
        data.add((Object)psgTransactionItem.getReaderName());
        data.add((Object)psgTransactionItem.getVerifyModeName());
        data.add((Object)(psgTransactionItem.getDevAlias() != null ? psgTransactionItem.getDevAlias() + "##" + psgTransactionItem.getDevSn() + "##" + psgTransactionItem.getEventPointName() + "##" + psgTransactionItem.getEventPointType() : ""));
        data.add((Object)(Objects.nonNull(psgGate) ? psgGate.getId() : ""));
        data.add((Object)(Objects.nonNull(psgGate) ? psgGate.getEnabled() : true));
        data.add((Object)psgTransactionItem.getPin());
        row.put("data", (Object)data);
        rows.add((Object)row);
        ret.put("rows", (Object)rows);
        this.messagingTemplate.convertAndSend((Object)"/topic/psgRTMonitor/getEventData", (Object)ret);
        this.messagingTemplate.convertAndSend((Object)"/topic/dashboardRTMonitor/getEventData", (Object)ret);
    }

    private JSONObject buildUserDate(PsgTransactionItem psgTransactionItem, Map<String, String> userData) {
        JSONObject userdata = new JSONObject();
        String photoPath = "";
        boolean isExistPerson = StringUtils.isNotBlank((CharSequence)psgTransactionItem.getPin());
        if (isExistPerson) {
            photoPath = this.psgPersonService.getPersPersonPhotoPathByPin(psgTransactionItem.getPin());
        }
        userdata.put("photoPath", (Object)(StringUtils.isNotBlank((CharSequence)photoPath) ? photoPath : userData.get("photoPath")));
        userdata.put("status", (Object)(psgTransactionItem.getEventLevel() == 0 ? "normal" : (psgTransactionItem.getEventLevel() == 1 ? "warning" : "alarm")));
        userdata.put("isExistCardOp", (Object)(psgTransactionItem.getEventNo() == 27 && StringUtils.isNotBlank((CharSequence)psgTransactionItem.getCardNo()) && !StringUtils.isNotBlank((CharSequence)userData.get("photoPath")) ? 1 : 0));
        userdata.put("eventNo", (Object)psgTransactionItem.getEventNo());
        if (StringUtils.isNotBlank((CharSequence)psgTransactionItem.getVidLinkageHandle()) && !psgTransactionItem.getVidLinkageHandle().startsWith("/upload")) {
            JSONObject tranJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)psgTransactionItem));
            userdata.put("globalLinkageEvent", (Object)tranJson);
        }
        return userdata;
    }

    private String getAudioPath(PsgDeviceEventItem psgDeviceEvent) {
        String audioPath = "";
        if (Objects.nonNull(psgDeviceEvent)) {
            audioPath = this.psgRTMonitorService.getAudioPath(psgDeviceEvent.getBaseMediaFileId());
        }
        return audioPath;
    }

    public void sendDeviceGateState2RTMonitor(ZKResultMsg resultMsg) {
        int i;
        JSONObject data = new JSONObject();
        JSONArray stateArray = null;
        JSONArray gateStates = new JSONArray();
        JSONArray auxInStates = new JSONArray();
        JSONObject dev = null;
        JSONObject devState = (JSONObject)resultMsg.getData();
        stateArray = devState.getJSONArray("gateState");
        if (Objects.nonNull(stateArray) && stateArray.size() > 0) {
            for (i = 0; i < stateArray.size(); ++i) {
                JSONObject gate = stateArray.getJSONObject(i);
                dev = this.putGateDataToMonitor(gate);
                gateStates.add((Object)dev);
            }
            data.put("gateStates", (Object)gateStates);
        }
        if (Objects.nonNull(stateArray = devState.getJSONArray("auxInState")) && stateArray.size() > 0) {
            for (i = 0; i < stateArray.size(); ++i) {
                JSONObject auxIn = stateArray.getJSONObject(i);
                int connect = auxIn.getIntValue("connect");
                auxIn.put("image", (Object)PsgEnumUtil.AuxInImage.getValue(connect));
                auxInStates.add((Object)auxIn);
            }
            data.put("auxInStates", (Object)auxInStates);
        }
        this.messagingTemplate.convertAndSend((Object)"/topic/psgRTMonitor/getDevState", (Object)data);
    }

    private JSONObject putGateDataToMonitor(JSONObject gate) {
        JSONObject data = new JSONObject();
        int relay = gate.getIntValue("relay");
        int alarm = gate.getIntValue("alarm");
        int connect = gate.getIntValue("connect");
        int gateState = gate.getIntValue("gateState");
        String alarmValue = PsgEnumUtil.Alarm.getValue(gateState, alarm);
        data.put("id", (Object)gate.getString("id"));
        data.put("areaId", (Object)gate.getString("areaId"));
        data.put("areaName", (Object)gate.getString("areaName"));
        data.put("devAlias", (Object)gate.getString("devAlias"));
        data.put("devSn", (Object)gate.getString("devSn"));
        data.put("no", (Object)gate.getString("no"));
        data.put("name", (Object)gate.getString("name"));
        data.put("passageName", (Object)gate.getString("passageName"));
        data.put("connect", (Object)connect);
        data.put("alarm", (Object)(StringUtils.isNotBlank((CharSequence)alarmValue) ? alarmValue : ""));
        data.put("image", (Object)PsgEnumUtil.GateImage.getValue(gateState, connect, alarm, relay));
        data.put("opDisplay", (Object)(gateState == 1 || gateState == 3 ? "inline" : "none"));
        data.put("iconFolderName", (Object)gate.getString("iconFolderName"));
        if (alarm > 0 && !gate.getBoolean("isDisableAudio").booleanValue()) {
            data.put("audio", (Object)"/public/media/sound/alarm.wav");
        }
        return data;
    }

    public void sendDeviceMonitor(PsgDeviceMonitorItem psgDeviceMonitorItem) {
        JSONObject dxGrid = new JSONObject();
        dxGrid.put("pos", (Object)0);
        ArrayList<JSONObject> rows = new ArrayList<JSONObject>();
        JSONObject row = new JSONObject();
        row.put("id", (Object)psgDeviceMonitorItem.getId());
        JSONObject userData = new JSONObject();
        userData.put("areaId", (Object)psgDeviceMonitorItem.getAreaId());
        userData.put("status", (Object)psgDeviceMonitorItem.getDevStatus());
        row.put("userdata", (Object)userData);
        if ("normal".equals(psgDeviceMonitorItem.getDevStatus())) {
            row.put("style", (Object)"color:green");
        } else if ("disable".equals(psgDeviceMonitorItem.getDevStatus())) {
            row.put("style", (Object)"color:#E57A14");
        } else {
            row.put("style", (Object)"color:red");
        }
        JSONArray data = new JSONArray();
        data.add((Object)psgDeviceMonitorItem.getDevName());
        data.add((Object)psgDeviceMonitorItem.getDevSn());
        data.add((Object)psgDeviceMonitorItem.getAreaName());
        data.add((Object)psgDeviceMonitorItem.getOpState());
        data.add((Object)psgDeviceMonitorItem.getCurState());
        data.add((Object)psgDeviceMonitorItem.getCmdCount());
        data.add((Object)(psgDeviceMonitorItem.getLastError().equals("") ? I18nUtil.i18nCode((String)"common_none", (Object[])new Object[0]) : psgDeviceMonitorItem.getLastError()));
        data.add((Object)"0,1");
        row.put("data", (Object)data);
        rows.add(row);
        dxGrid.put("rows", rows);
        dxGrid.put("total_count", (Object)rows.size());
        this.messagingTemplate.convertAndSend((Object)"/topic/psgDeviceMonitor/getDeviceEvents", (Object)dxGrid);
    }
}

