/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mscapi;

import java.io.ObjectStreamException;
import java.math.BigInteger;
import java.security.KeyException;
import java.security.KeyRep;
import java.security.ProviderException;
import sun.security.mscapi.Key;
import sun.security.rsa.RSAPublicKeyImpl;

class RSAPublicKey
extends Key
implements java.security.interfaces.RSAPublicKey {
    private static final long serialVersionUID = -2289561342425825391L;
    private byte[] publicKeyBlob = null;
    private byte[] encoding = null;
    private BigInteger modulus = null;
    private BigInteger exponent = null;

    RSAPublicKey(long hCryptProv, long hCryptKey, int keyLength) {
        super(new Key.NativeHandles(hCryptProv, hCryptKey), keyLength);
    }

    RSAPublicKey(Key.NativeHandles handles, int keyLength) {
        super(handles, keyLength);
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("RSAPublicKey [size=").append(this.keyLength).append(" bits, type=").append(RSAPublicKey.getKeyType(this.handles.hCryptKey)).append(", container=").append(RSAPublicKey.getContainerName(this.handles.hCryptProv)).append("]\n  modulus: ").append(this.getModulus()).append("\n  public exponent: ").append(this.getPublicExponent());
        return sb.toString();
    }

    @Override
    public BigInteger getPublicExponent() {
        if (this.exponent == null) {
            try {
                this.publicKeyBlob = this.getPublicKeyBlob(this.handles.hCryptKey);
                this.exponent = new BigInteger(1, this.getExponent(this.publicKeyBlob));
            }
            catch (KeyException e) {
                throw new ProviderException(e);
            }
        }
        return this.exponent;
    }

    @Override
    public BigInteger getModulus() {
        if (this.modulus == null) {
            try {
                this.publicKeyBlob = this.getPublicKeyBlob(this.handles.hCryptKey);
                this.modulus = new BigInteger(1, this.getModulus(this.publicKeyBlob));
            }
            catch (KeyException e) {
                throw new ProviderException(e);
            }
        }
        return this.modulus;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        if (this.encoding == null) {
            try {
                this.encoding = new RSAPublicKeyImpl(this.getModulus(), this.getPublicExponent()).getEncoded();
            }
            catch (KeyException keyException) {
                // empty catch block
            }
        }
        return this.encoding;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    private native byte[] getPublicKeyBlob(long var1) throws KeyException;

    private native byte[] getExponent(byte[] var1) throws KeyException;

    private native byte[] getModulus(byte[] var1) throws KeyException;
}

