/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.accessibility.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.IllegalComponentStateException;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import jdk.Exported;

@Exported
public class Translator
extends AccessibleContext
implements Accessible,
AccessibleComponent {
    protected Object source;

    protected static Class getTranslatorClass(Class c) {
        Class<?> t = null;
        if (c == null) {
            return null;
        }
        try {
            t = Class.forName("com.sun.java.accessibility.util." + c.getName() + "Translator");
            return t;
        }
        catch (Exception e) {
            return Translator.getTranslatorClass(c.getSuperclass());
        }
    }

    public static Accessible getAccessible(Object o) {
        Accessible a = null;
        if (o == null) {
            return null;
        }
        if (o instanceof Accessible) {
            a = (Accessible)o;
        } else {
            Class translatorClass = Translator.getTranslatorClass(o.getClass());
            if (translatorClass != null) {
                try {
                    Translator t = (Translator)translatorClass.newInstance();
                    t.setSource(o);
                    a = t;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (a == null) {
            a = new Translator(o);
        }
        return a;
    }

    public Translator() {
    }

    public Translator(Object o) {
        this.source = o;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object o) {
        this.source = o;
    }

    public boolean equals(Object o) {
        return this.source.equals(o);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return this;
    }

    @Override
    public String getAccessibleName() {
        if (this.source instanceof MenuItem) {
            return ((MenuItem)this.source).getLabel();
        }
        if (this.source instanceof Component) {
            return ((Component)this.source).getName();
        }
        return null;
    }

    @Override
    public void setAccessibleName(String s) {
        if (this.source instanceof MenuItem) {
            ((MenuItem)this.source).setLabel(s);
        } else if (this.source instanceof Component) {
            ((Component)this.source).setName(s);
        }
    }

    @Override
    public String getAccessibleDescription() {
        return null;
    }

    @Override
    public void setAccessibleDescription(String s) {
    }

    @Override
    public AccessibleRole getAccessibleRole() {
        return AccessibleRole.UNKNOWN;
    }

    @Override
    public AccessibleStateSet getAccessibleStateSet() {
        AccessibleStateSet states = new AccessibleStateSet();
        if (this.source instanceof Component) {
            Component c = (Component)this.source;
            for (Container p = c.getParent(); p != null; p = p.getParent()) {
                if (!(p instanceof Window) || ((Window)p).getFocusOwner() != c) continue;
                states.add(AccessibleState.FOCUSED);
            }
        }
        if (this.isEnabled()) {
            states.add(AccessibleState.ENABLED);
        }
        if (this.isFocusTraversable()) {
            states.add(AccessibleState.FOCUSABLE);
        }
        if (this.source instanceof MenuItem) {
            states.add(AccessibleState.FOCUSABLE);
        }
        return states;
    }

    @Override
    public Accessible getAccessibleParent() {
        if (this.accessibleParent != null) {
            return this.accessibleParent;
        }
        if (this.source instanceof Component) {
            return Translator.getAccessible(((Component)this.source).getParent());
        }
        return null;
    }

    @Override
    public int getAccessibleIndexInParent() {
        Container parent;
        if (this.source instanceof Component && (parent = ((Component)this.source).getParent()) != null) {
            Component[] ca = parent.getComponents();
            for (int i = 0; i < ca.length; ++i) {
                if (!this.source.equals(ca[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int getAccessibleChildrenCount() {
        if (this.source instanceof Container) {
            Component[] children = ((Container)this.source).getComponents();
            int count = 0;
            for (int i = 0; i < children.length; ++i) {
                Accessible a = Translator.getAccessible(children[i]);
                if (a == null) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    @Override
    public Accessible getAccessibleChild(int i) {
        if (this.source instanceof Container) {
            Component[] children = ((Container)this.source).getComponents();
            int count = 0;
            for (int j = 0; j < children.length; ++j) {
                Accessible a = Translator.getAccessible(children[j]);
                if (a == null) continue;
                if (count == i) {
                    AccessibleContext ac = a.getAccessibleContext();
                    if (ac != null) {
                        ac.setAccessibleParent(this);
                    }
                    return a;
                }
                ++count;
            }
        }
        return null;
    }

    @Override
    public Locale getLocale() throws IllegalComponentStateException {
        if (this.source instanceof Component) {
            return ((Component)this.source).getLocale();
        }
        return null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    @Override
    public Color getBackground() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getBackground();
        }
        return null;
    }

    @Override
    public void setBackground(Color c) {
        if (this.source instanceof Component) {
            ((Component)this.source).setBackground(c);
        }
    }

    @Override
    public Color getForeground() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getForeground();
        }
        return null;
    }

    @Override
    public void setForeground(Color c) {
        if (this.source instanceof Component) {
            ((Component)this.source).setForeground(c);
        }
    }

    @Override
    public Cursor getCursor() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getCursor();
        }
        return null;
    }

    @Override
    public void setCursor(Cursor c) {
        if (this.source instanceof Component) {
            ((Component)this.source).setCursor(c);
        }
    }

    @Override
    public Font getFont() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getFont();
        }
        if (this.source instanceof MenuComponent) {
            return ((MenuComponent)this.source).getFont();
        }
        return null;
    }

    @Override
    public void setFont(Font f) {
        if (this.source instanceof Component) {
            ((Component)this.source).setFont(f);
        } else if (this.source instanceof MenuComponent) {
            ((MenuComponent)this.source).setFont(f);
        }
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        if (this.source instanceof Component) {
            return ((Component)this.source).getFontMetrics(f);
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        if (this.source instanceof Component) {
            return ((Component)this.source).isEnabled();
        }
        if (this.source instanceof MenuItem) {
            return ((MenuItem)this.source).isEnabled();
        }
        return true;
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.source instanceof Component) {
            ((Component)this.source).setEnabled(b);
        } else if (this.source instanceof MenuItem) {
            ((MenuItem)this.source).setEnabled(b);
        }
    }

    @Override
    public boolean isVisible() {
        if (this.source instanceof Component) {
            return ((Component)this.source).isVisible();
        }
        return false;
    }

    @Override
    public void setVisible(boolean b) {
        if (this.source instanceof Component) {
            ((Component)this.source).setVisible(b);
        }
    }

    @Override
    public boolean isShowing() {
        if (this.source instanceof Component) {
            return ((Component)this.source).isShowing();
        }
        return false;
    }

    @Override
    public boolean contains(Point p) {
        if (this.source instanceof Component) {
            return ((Component)this.source).contains(p);
        }
        return false;
    }

    @Override
    public Point getLocationOnScreen() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getLocationOnScreen();
        }
        return null;
    }

    @Override
    public Point getLocation() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getLocation();
        }
        return null;
    }

    @Override
    public void setLocation(Point p) {
        if (this.source instanceof Component) {
            ((Component)this.source).setLocation(p);
        }
    }

    @Override
    public Rectangle getBounds() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getBounds();
        }
        return null;
    }

    @Override
    public void setBounds(Rectangle r) {
        if (this.source instanceof Component) {
            ((Component)this.source).setBounds(r);
        }
    }

    @Override
    public Dimension getSize() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getSize();
        }
        return null;
    }

    @Override
    public void setSize(Dimension d) {
        if (this.source instanceof Component) {
            ((Component)this.source).setSize(d);
        }
    }

    @Override
    public Accessible getAccessibleAt(Point p) {
        Component c;
        if (this.source instanceof Component && (c = ((Component)this.source).getComponentAt(p)) != null) {
            return Translator.getAccessible(c);
        }
        return null;
    }

    @Override
    public boolean isFocusTraversable() {
        if (this.source instanceof Component) {
            return ((Component)this.source).isFocusTraversable();
        }
        return false;
    }

    @Override
    public void requestFocus() {
        if (this.source instanceof Component) {
            ((Component)this.source).requestFocus();
        }
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        if (this.source instanceof Component) {
            ((Component)this.source).addFocusListener(l);
        }
    }

    @Override
    public synchronized void removeFocusListener(FocusListener l) {
        if (this.source instanceof Component) {
            ((Component)this.source).removeFocusListener(l);
        }
    }
}

