/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.freemarker.directives;

import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import com.zkteco.zkbiosecurity.security.SecurityService;
import com.zkteco.zkbiosecurity.ui.web.freemarker.annotation.ZKDirective;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Document;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.HTMLElement;
import com.zkteco.zkbiosecurity.ui.web.freemarker.util.BeanUtil;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@ZKDirective(value="skinStyle")
public class ImportSkinStyle
implements TemplateDirectiveModel {
    @Value(value="${system.skins:default}")
    private String skins;
    @Autowired(required=false)
    private SecurityService securityService;

    public void execute(Environment env, Map arg1, TemplateModel[] arg2, TemplateDirectiveBody arg3) throws TemplateException, IOException {
        Writer out = env.getOut();
        HTMLElement doc = Document.createElement();
        String[] _skins = this.skins.split(",");
        if (this.securityService != null && WebContextUtil.getCurrentSessionId() != null) {
            String rtl;
            SecuritySubject subject = this.securityService.getSecuritySubject(WebContextUtil.getCurrentSessionId());
            if (arg1 == null || arg1.size() == 0) {
                if (subject != null) {
                    for (String s : _skins) {
                        this.addLink(doc, s, "base");
                    }
                } else {
                    for (String s : _skins) {
                        this.addLink(doc, s, "base");
                        this.addLink(doc, s, "login");
                    }
                }
            } else if (arg1.containsKey("rtl") && "true".equals(rtl = arg1.get("rtl").toString()) && BeanUtil.enableRTL()) {
                for (String s : _skins) {
                    if (this.getClass().getResource("/static/public/skins/" + s + "/skin-" + s + "-RTL.css") == null) continue;
                    this.addLink(doc, s, "RTL");
                }
            }
        }
        out.write(doc.toString());
    }

    private void addLink(HTMLElement doc, String skin, String module) {
        doc.link().href("public/skins/" + skin + "/skin-" + skin + "-" + module + ".css").attr("group", "skin").attr("skin", skin);
    }
}

