/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.freemarker.directives;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ui.web.freemarker.annotation.ZKUIDirective;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Document;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.HTMLElement;
import com.zkteco.zkbiosecurity.ui.web.freemarker.util.BeanUtil;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@ZKUIDirective(script="ui/js/ZKInput.js")
public class Input
implements TemplateDirectiveModel {
    @Value(value="${biosecurity.date.sysDateFmt:yyyy-MM-dd}")
    private String dateFmt;
    @Value(value="${biosecurity.date.sysTimeFmt:HH:mm:ss}")
    private String timeFmt;
    @Value(value="${biosecurity.date.sysDateTimeFmt:yyyy-MM-dd HH:mm:ss}")
    private String dateTimeFmt;

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        Writer out = env.getOut();
        JSONObject jsonData = new JSONObject();
        BeanUtil.setParamsToJson(jsonData, params);
        String uuid = BeanUtil.getUUID();
        String id = BeanUtil.getParam(params, "id", "input_" + uuid);
        jsonData.put("id", (Object)id);
        HTMLElement root = Document.createElement();
        if (params.get("hideLabel") == null) {
            String title = I18nUtil.i18nCode((String)BeanUtil.getParam(params, "title", ""), (Object[])new Object[0]);
            if (params.get("required") != null) {
                title = title + "<span class='required'>*</span>";
            }
            HTMLElement label = root.label().text(title).attr("title", title).addClass("search-label");
            if (params.get("labelWidth") != null) {
                label.width(params.get("labelWidth").toString());
            }
        }
        String type = BeanUtil.getParam(params, "type", "text");
        String value = BeanUtil.getParam(params, "value", "");
        if (StringUtils.isNotBlank((CharSequence)value)) {
            // empty if block
        }
        if (type.equals("date") || type.equals("datetime") || type.equals("select") || type.equals("color")) {
            type = "text";
        }
        if (type.equals("ip")) {
            String prefix = BeanUtil.getParam(params, "prefix", "ipv4" + uuid);
            jsonData.put("prefix", (Object)prefix);
            String name = BeanUtil.getParam(params, "name", "ip" + uuid);
            root.div().addAttributes(params).id(id).removeAttr("name").removeAttr("type").addClass("ip_input").style("display:inline-block;");
            root.input().type("hidden").value(value).name(name).id(id + "_hidden");
        } else if (type.equals("checkbox") && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{jsonData.getString("eventCheck")})) {
            String name = BeanUtil.getParam(params, "name", id);
            root.input().addAttributes(params).id(id).removeAttr("name").type("checkbox");
            root.input().type("hidden").name(name).id(id + "_hidden");
        } else {
            HTMLElement input = root.input().addAttributesOnly(params).addClass("search-input").type(type).id(id).value(value);
            if ("select".equals(jsonData.getString("type"))) {
                input.removeAttr("name");
                root.input().type("hidden").value(value).attr("name", jsonData.getString("name")).id(id + "_value");
            }
        }
        jsonData.put("value", (Object)value);
        root.script().appendContent("new ZKUI.Input(" + jsonData.toJSONString() + ")");
        out.write(root.toString());
    }
}

