/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cmd.sec.device;

import com.zkteco.zkbiosecurity.cmd.sec.device.CmdDevice;
import com.zkteco.zkbiosecurity.cmd.sec.utils.CmdSecUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class CmdDeviceConstructor {
    public static String setTime(Date date) {
        return "SET OPTIONS " + String.format("DateTime=%s\r\n", CmdSecUtil.encodeTime(date));
    }

    public static String setTimeZone(CmdDevice cmdDevice, String timeZone) {
        if ("1".equals(cmdDevice.getMachineTZFunOn())) {
            return "SET OPTIONS " + String.format("MachineTZ=%s\r\n", timeZone);
        }
        return null;
    }

    public static String setCommPwd(String commPwd) {
        return "SET OPTIONS " + String.format("ComPwd=%s\r\n", commPwd);
    }

    public static String setMThreshold(Integer mThreshold) {
        return "SET OPTIONS " + String.format("MThreshold=%s\r\n", mThreshold);
    }

    public static String setWGFmtWithSitecodeOn(CmdDevice cmdDevice, boolean isOpen) {
        if ("1".equals(cmdDevice.getAccSupportFunList(6))) {
            return "SET OPTIONS " + String.format("WGFmtWithSitecodeOn=%s\r\n", isOpen ? 1 : 0);
        }
        return null;
    }

    public static String setUserWithMulCardFunOn(CmdDevice cmdDevice, boolean isOpen) {
        if ("1".equals(cmdDevice.getAccSupportFunList(7))) {
            return "SET OPTIONS " + String.format("UserWithMulCardOn=%s\r\n", isOpen ? 1 : 0);
        }
        return null;
    }

    private static String ctrlDevice(CmdDevice cmdDevice, int operate, int param1, int param2, int param3) {
        String cmd = "";
        cmd = cmdDevice.getCommType() == 3 ? String.format("%s%s%s%s\r\n", CmdSecUtil.toHex(operate), CmdSecUtil.toHex(param1), CmdSecUtil.toHex(param2), CmdSecUtil.toHex(param3)) : String.format("%s %s %s %s\r\n", operate, param1, param2, param3);
        return "CONTROL DEVICE " + cmd;
    }

    public static String ctrlDoor(CmdDevice cmdDevice, int doorNo, int type, int interval) {
        if (interval <= 0) {
            interval = 0;
        } else if (interval >= 255) {
            interval = 255;
        }
        return CmdDeviceConstructor.ctrlDevice(cmdDevice, 1, doorNo, type, interval);
    }

    public static String cancelAlarm(CmdDevice cmdDevice, int doorNo) {
        return CmdDeviceConstructor.ctrlDevice(cmdDevice, 2, doorNo, 0, 0);
    }

    public static String reboot(CmdDevice cmdDevice) {
        return CmdDeviceConstructor.ctrlDevice(cmdDevice, 3, 0, 0, 0);
    }

    public static String ctrlNormalOpenTimeZone(CmdDevice cmdDevice, int doorNo, int enabled) {
        return CmdDeviceConstructor.ctrlDevice(cmdDevice, 4, doorNo, enabled, 0);
    }

    public static String ctrlLockDoor(CmdDevice cmdDevice, int doorNo, int lock) {
        return CmdDeviceConstructor.ctrlDevice(cmdDevice, 6, doorNo, lock, 0);
    }

    public static String ctrlWGTest(CmdDevice cmdDevice, int openOrClose) {
        return CmdDeviceConstructor.ctrlDevice(cmdDevice, 9, openOrClose, 0, 0);
    }

    public static String switchNetWorkTest(CmdDevice cmdDevice, int openOrClose) {
        return CmdDeviceConstructor.ctrlDevice(cmdDevice, 11, openOrClose, 0, 0);
    }

    public static String setIDCardRegistrationMode(CmdDevice cmdDevice, int mode, int doorNo, int timeout) {
        return CmdDeviceConstructor.ctrlDevice(cmdDevice, 12, mode, doorNo, timeout);
    }

    public static String getChildDevRTState(CmdDevice cmdDevice) {
        return CmdDeviceConstructor.ctrlDevice(cmdDevice, 13, 0, 0, 0);
    }

    public static String ctrlPsgResetCount(CmdDevice cmdDevice, int mode) {
        return CmdDeviceConstructor.ctrlDevice(cmdDevice, 14, mode, 0, 0);
    }

    public static List<String> setOptions(Map<String, String> optionMap) {
        ArrayList<String> cmdList = new ArrayList<String>();
        int optCount = 0;
        StringBuffer cmdContent = new StringBuffer();
        for (Map.Entry<String, String> entry : optionMap.entrySet()) {
            cmdContent.append(entry.getKey() + "=" + entry.getValue() + ",");
            if (++optCount % 30 != 0) continue;
            optCount = 0;
            String tempCmd = cmdContent.toString();
            cmdList.add("SET OPTIONS " + tempCmd.substring(0, tempCmd.length() - 1) + "\r\n");
            cmdContent = new StringBuffer();
        }
        if (cmdContent.length() > 0) {
            String tempCmd = cmdContent.toString();
            cmdList.add("SET OPTIONS " + tempCmd.substring(0, tempCmd.length() - 1) + "\r\n");
        }
        return cmdList;
    }

    public static List<String> getOptions(List<String> optionList) {
        ArrayList<String> cmdList = new ArrayList<String>();
        int optCount = 1;
        StringBuffer cmdContent = new StringBuffer();
        for (String option : optionList) {
            if (cmdContent.length() == 0) {
                cmdContent.append("~SerialNumber");
            }
            cmdContent.append("," + option);
            if (++optCount % 30 != 0) continue;
            optCount = 1;
            cmdList.add("GET OPTIONS " + cmdContent.toString() + "\r\n");
            cmdContent = new StringBuffer();
        }
        if (cmdContent.length() > 0) {
            cmdList.add("GET OPTIONS " + cmdContent.toString() + "\r\n");
        }
        return cmdList;
    }

    public static String getWifiList(CmdDevice cmdDevice) {
        if ("1".equals(cmdDevice.getAccSupportFunList(24))) {
            return String.format("DATA QUERY tablename=%s,fielddesc=%s,filter=%s\r\n", "[APList]", "*", "*");
        }
        return null;
    }

    public static String setDeviceIP(String ipAddress, String subnetMask, String gateway) {
        return "SET OPTIONS " + String.format("IPAddress=%s,NetMask=%s,GATEIPAddress=%s\r\n", ipAddress, subnetMask, gateway);
    }

    public static String setRS485Addr(Short addr) {
        return "SET OPTIONS " + String.format("DeviceID=%s\r\n", addr);
    }

    @Deprecated
    public static String upgradeFirmware(File file, String url) throws Exception {
        return "UPGRADE " + String.format("checksum=%s,url=%s,size=%s\r\n", CmdSecUtil.getFileMD5String(file), url, file.length());
    }

    @Deprecated
    public static String upgradeChildDevFirmware(File file, String url, String childDevSn) throws Exception {
        return "UPGRADE " + String.format("checksum=%s,url=%s,size=%s,sn=%s\r\n", CmdSecUtil.getFileMD5String(file), url, file.length(), childDevSn);
    }

    public static String upgradeFirmware(CmdDevice cmdDevice, File file, String url, String targetSn) throws Exception {
        String cmdContent = String.format("checksum=%s,url=%s,size=%s", CmdSecUtil.getFileMD5String(file), url, file.length());
        if (targetSn != null && targetSn.trim().length() > 0) {
            cmdContent = cmdContent + String.format(",sn=%s", targetSn);
        }
        if ("1".equals(cmdDevice.getSubcontractingUpgradeFunOn())) {
            cmdContent = cmdContent + ",supportsubcontracting=1";
        }
        cmdContent = cmdContent + "\r\n";
        return "UPGRADE " + cmdContent;
    }

    public static String setDevIOState(int devIOState) {
        return "SET OPTIONS " + String.format("Reader1IOState=%s\r\n", devIOState);
    }

    public static String setReaderIPAndPort(String ip, String port, Short readerNo) {
        return "SET OPTIONS " + String.format("TcpReader%sIP=%s,TcpReader%sPort=%s\r\n", readerNo, ip, readerNo, port);
    }

    public static String setRS485CommType(String devProtocolType) {
        return "SET OPTIONS " + String.format("ExtBoard485CommType=%s\r\n", devProtocolType);
    }
}

