/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.client.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.cloud.sdk.BaseRequest;
import com.zkteco.cloud.sdk.DefaultZKCloudClient;
import com.zkteco.cloud.sdk.ZKCouldClient;
import com.zkteco.cloud.sdk.resp.ObjectResponse;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.posid.api.vo.PosIDApiCloudBarcodePayItem;
import com.zkteco.zkbiosecurity.posid.api.vo.PosIDApiCloudQrcodePayItem;
import com.zkteco.zkbiosecurity.posid.client.request.ApiPosIDCloudBarcodePayRequest;
import com.zkteco.zkbiosecurity.posid.client.request.ApiPosIDCloudQrcodePayRequest;
import com.zkteco.zkbiosecurity.posid.service.PosIDCloudService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDPayOrderItem;
import com.zkteco.zkbiosecurity.system.app.service.BaseAuthCloudMessageSendService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import java.net.InetAddress;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PosIDCloudServiceImpl
implements PosIDCloudService {
    private static final Logger log = LoggerFactory.getLogger(PosIDCloudServiceImpl.class);
    @Autowired
    private BaseLicenseService baseLicenseService;
    @Autowired
    private BaseAuthCloudMessageSendService baseAuthCloudMessageSendService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Value(value="${cloud.server.upload.url:https://zkcloud.xmzkteco.com/BiosecurityApp/router/rest}")
    private String serverUrl;

    public ZKResultMsg cloudBarcodePay(Integer money, String code, String sn) {
        if (StringUtils.isBlank((CharSequence)this.baseLicenseService.getAppId())) {
            return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)code)) {
            try {
                String token = this.baseAuthCloudMessageSendService.createToken();
                log.info("------ upload access_token ------- " + token);
                ZKCouldClient couldClient = this.getSendMsgClient();
                String uuid = UUID.randomUUID().toString().replaceAll("-", "");
                PosIDApiCloudBarcodePayItem posIDApiCloudBarcodePayItem = new PosIDApiCloudBarcodePayItem();
                posIDApiCloudBarcodePayItem.setCode(code);
                posIDApiCloudBarcodePayItem.setPrice(money);
                posIDApiCloudBarcodePayItem.setOrderSn(uuid);
                posIDApiCloudBarcodePayItem.setDeviceSn(sn);
                InetAddress address = InetAddress.getLocalHost();
                String hostAddress = address.getHostAddress();
                posIDApiCloudBarcodePayItem.setIp(hostAddress);
                posIDApiCloudBarcodePayItem.setBody(I18nUtil.i18nCode((String)"posid_module", (Object[])new Object[0]));
                ApiPosIDCloudBarcodePayRequest ppiPosIDCloudBarcodePayRequest = new ApiPosIDCloudBarcodePayRequest();
                ppiPosIDCloudBarcodePayRequest.setPosIDApiCloudBarcodePayItem(posIDApiCloudBarcodePayItem);
                ObjectResponse rsp = (ObjectResponse)couldClient.execute((BaseRequest)ppiPosIDCloudBarcodePayRequest, token);
                Integer ret = Integer.parseInt(rsp.getCode());
                log.info("cloudBarcodePay ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
                if (ret == -27) {
                    token = this.baseAuthCloudMessageSendService.refreshToken();
                    rsp = (ObjectResponse)couldClient.execute((BaseRequest)ppiPosIDCloudBarcodePayRequest, token);
                    ret = Integer.parseInt(rsp.getCode());
                }
                if (ret != 0) {
                    return ZKResultMsg.failMsg((String)rsp.getMsg(), (Object[])new Object[0]);
                }
                JSONObject jsonObject = JSONObject.parseObject((String)rsp.getBody());
                String data = uuid + "=" + jsonObject.getString("data");
                return new ZKResultMsg((Object)data);
            }
            catch (Exception e) {
                e.printStackTrace();
                return ZKResultMsg.failMsg();
            }
        }
        return ZKResultMsg.failMsg();
    }

    public ZKCouldClient getSendMsgClient() {
        String appId = this.baseLicenseService.getAppId();
        String appKey = this.baseSysParamService.getValByName("zkteco:cloud:appkey");
        DefaultZKCloudClient couldClient = new DefaultZKCloudClient(this.serverUrl, appId, appKey, "json", 15000, 45000);
        return couldClient;
    }

    public ZKResultMsg cloudQrcodePay(PosIDPayOrderItem posIDPayOrderItem, String body) {
        if (StringUtils.isBlank((CharSequence)this.baseLicenseService.getAppId())) {
            return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)posIDPayOrderItem.getId())) {
            try {
                String token = this.baseAuthCloudMessageSendService.createToken();
                log.info("------ upload access_token ------- " + token);
                ZKCouldClient couldClient = this.getSendMsgClient();
                PosIDApiCloudQrcodePayItem posIDApiCloudQrcodePayItem = new PosIDApiCloudQrcodePayItem();
                posIDApiCloudQrcodePayItem.setPin(posIDPayOrderItem.getPin());
                posIDApiCloudQrcodePayItem.setType(posIDPayOrderItem.getPayType().toString());
                posIDApiCloudQrcodePayItem.setPrice(posIDPayOrderItem.getAmount());
                posIDApiCloudQrcodePayItem.setOrderSn(posIDPayOrderItem.getId());
                posIDApiCloudQrcodePayItem.setDeviceSn(posIDPayOrderItem.getSn());
                posIDApiCloudQrcodePayItem.setIp(posIDPayOrderItem.getClientIp());
                posIDApiCloudQrcodePayItem.setBody(body);
                ApiPosIDCloudQrcodePayRequest apiPosIDCloudQrcodePayRequest = new ApiPosIDCloudQrcodePayRequest();
                apiPosIDCloudQrcodePayRequest.setPosIDApiCloudQrcodePayItem(posIDApiCloudQrcodePayItem);
                ObjectResponse rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDCloudQrcodePayRequest, token);
                Integer ret = Integer.parseInt(rsp.getCode());
                log.info("cloudQrcodePay ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
                if (ret == -27) {
                    token = this.baseAuthCloudMessageSendService.refreshToken();
                    rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPosIDCloudQrcodePayRequest, token);
                    ret = Integer.parseInt(rsp.getCode());
                }
                if (ret != 0) {
                    return ZKResultMsg.failMsg((String)rsp.getMsg(), (Object[])new Object[0]);
                }
                JSONObject jsonObject = JSONObject.parseObject((String)rsp.getBody());
                String data = jsonObject.getString("data");
                return new ZKResultMsg((Object)data);
            }
            catch (Exception e) {
                e.printStackTrace();
                return ZKResultMsg.failMsg();
            }
        }
        return ZKResultMsg.failMsg();
    }
}

