/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.api.controller;

import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.vis.api.vo.VisApiReservationItem;
import com.zkteco.zkbiosecurity.vis.service.VisReservationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/visReservation"})
@Api(tags={"VisReservation"}, description="visitor reservation")
public class VisApiReservationController {
    private static final Logger log = LoggerFactory.getLogger(VisApiReservationController.class);
    @Autowired
    private VisReservationService visReservationService;

    @ResponseBody
    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Add Visitor Reservation", notes="Return Result Object", response=ApiResultMessage.class)
    public ApiResultMessage addVisitorReservation(@RequestBody VisApiReservationItem visReservationItem) {
        ApiResultMessage rs = null;
        try {
            if (StringUtils.isBlank((CharSequence)visReservationItem.getCertType())) {
                return ApiResultMessage.message((int)-241, (String)I18nUtil.i18nCode((String)"vis_api_certTypeNotNull", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)visReservationItem.getCertNum())) {
                return ApiResultMessage.message((int)-242, (String)I18nUtil.i18nCode((String)"vis_api_certNumNotNull", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)visReservationItem.getPersPersonPin())) {
                return ApiResultMessage.message((int)-240, (String)I18nUtil.i18nCode((String)"vis_api_persPersonPinNotNull", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)visReservationItem.getVisitEmpName())) {
                return ApiResultMessage.message((int)-243, (String)I18nUtil.i18nCode((String)"vis_api_visitEmpNameNotNull", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)visReservationItem.getVisitReason())) {
                return ApiResultMessage.message((int)-246, (String)I18nUtil.i18nCode((String)"vis_api_visitReasonNotNull", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)visReservationItem.getVisitDate())) {
                return ApiResultMessage.message((int)-247, (String)I18nUtil.i18nCode((String)"vis_api_visitDateNotNull", (Object[])new Object[0]));
            }
            rs = this.visReservationService.addApiReservation(visReservationItem);
        }
        catch (ZKBusinessException e) {
            if ("vis_message_registrationed".equals(e.getMessage())) {
                rs = ApiResultMessage.message((int)-245, (String)I18nUtil.i18nCode((String)"vis_message_registrationed", (Object[])new Object[0]));
            } else if ("vis_message_reservated".equals(e.getMessage())) {
                rs = ApiResultMessage.message((int)-244, (String)I18nUtil.i18nCode((String)"vis_message_reservated", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            log.error("api visReservation/add error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }

    @ResponseBody
    @RequestMapping(value={"/del"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Delete Visitor Reservation", notes="Return Result Object", response=ApiResultMessage.class)
    public ApiResultMessage deleteVisitorReservation(@RequestParam String certType, @RequestParam String certNum, @RequestParam String visitDate) {
        ApiResultMessage rs = null;
        try {
            if (StringUtils.isBlank((CharSequence)certType)) {
                return ApiResultMessage.message((int)-241, (String)I18nUtil.i18nCode((String)"vis_api_certTypeNotNull", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)certNum)) {
                return ApiResultMessage.message((int)-242, (String)I18nUtil.i18nCode((String)"vis_api_certNumNotNull", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)visitDate)) {
                return ApiResultMessage.message((int)-247, (String)I18nUtil.i18nCode((String)"vis_api_visitDateNotNull", (Object[])new Object[0]));
            }
            rs = this.visReservationService.deleteApiReservation(certType, certNum, visitDate);
        }
        catch (Exception e) {
            log.error("api visReservation/del error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"api_common_programError", (Object[])new Object[0]));
        }
        return rs;
    }
}

