/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisPCRegistrationRemote;
import com.zkteco.zkbiosecurity.vis.service.VisAttributeService;
import com.zkteco.zkbiosecurity.vis.service.VisBioTemplateService;
import com.zkteco.zkbiosecurity.vis.service.VisLevelService;
import com.zkteco.zkbiosecurity.vis.service.VisParamsService;
import com.zkteco.zkbiosecurity.vis.service.VisPlaceService;
import com.zkteco.zkbiosecurity.vis.service.VisPrintTemplateService;
import com.zkteco.zkbiosecurity.vis.service.VisTransactionService;
import com.zkteco.zkbiosecurity.vis.service.VisVisitorService;
import com.zkteco.zkbiosecurity.vis.service.VisWatchListCategoryService;
import com.zkteco.zkbiosecurity.vis.service.VisWatchListService;
import com.zkteco.zkbiosecurity.vis.vo.VisAttributeItem;
import com.zkteco.zkbiosecurity.vis.vo.VisPlaceItem;
import com.zkteco.zkbiosecurity.vis.vo.VisRegistrationItem;
import com.zkteco.zkbiosecurity.vis.vo.VisTranBackFillItem;
import com.zkteco.zkbiosecurity.vis.vo.VisTransactionItem;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitorItem;
import com.zkteco.zkbiosecurity.vis.vo.VisWatchListItem;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisPCRegistrationController
extends BaseController
implements VisPCRegistrationRemote {
    @Autowired
    private VisTransactionService visTransactionService;
    @Autowired
    private VisPlaceService visPlaceService;
    @Autowired
    private VisParamsService visParamsService;
    @Autowired
    private VisAttributeService visAttributeService;
    @Autowired
    private VisVisitorService visVisitorService;
    @Autowired
    private VisBioTemplateService visBioTemplateService;
    @Autowired
    private VisPrintTemplateService visPrintTemplateService;
    @Autowired
    private VisWatchListCategoryService visWatchListCategoryService;
    @Autowired
    private VisWatchListService visWatchListService;
    @Autowired
    private VisLevelService visLevelService;

    @RequiresPermissions(value={"vis:registration"})
    public ModelAndView index() {
        String openExit = this.visPrintTemplateService.getValByName("vis.openExit");
        this.request.setAttribute("openExit", (Object)openExit);
        return new ModelAndView("vis/registration/visRegistration");
    }

    @RequiresPermissions(value={"vis:registration:edit", "vis:registration:add", "vis:registration:clone"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id, @RequestParam(value="clone", required=false) boolean clone) {
        Map visParams = this.visParamsService.getVisParams();
        this.request.setAttribute("visParams", (Object)visParams);
        Map palceDataMap = new HashMap();
        String cpuData = this.request.getParameter("cpuData");
        String macData = this.request.getParameter("macData");
        VisPlaceItem visPlaceItem = null;
        if (StringUtils.isNotBlank((CharSequence)macData)) {
            String[] macDatas;
            for (String mac : macDatas = macData.split(",")) {
                visPlaceItem = this.visPlaceService.getItemByPhysicalKey(cpuData + mac);
                if (visPlaceItem == null) continue;
                palceDataMap = this.visPlaceService.getVisDefaultData(visPlaceItem);
                break;
            }
        }
        String bioTemplateJson = "";
        VisRegistrationItem visRegistrationItem = new VisRegistrationItem();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            visRegistrationItem = this.visTransactionService.getRegistrationItemById(id);
            String levelIds = this.visTransactionService.getVisLevelIdsByTransactionId(id);
            visRegistrationItem.setLevelIds(levelIds);
            if (!clone) {
                Map valueMap = this.visVisitorService.getVisitorAttributeValues(visRegistrationItem.getVisEmpId());
                this.request.setAttribute("map1", (Object)valueMap);
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{visRegistrationItem.getVisEmpId()})) {
                    bioTemplateJson = JSON.toJSONString((Object)this.visBioTemplateService.getItemMapByVisitorId(visRegistrationItem.getVisEmpId()));
                }
            }
            if ((visPlaceItem = this.visPlaceService.getItemByName(visRegistrationItem.getEnterPlace())) != null) {
                palceDataMap = this.visPlaceService.getVisDefaultData(visPlaceItem);
                visRegistrationItem.setEnterPlace(visPlaceItem.getId());
            }
        }
        if (StringUtils.isBlank((CharSequence)id) || clone) {
            String carPlateProvince;
            Map licenseMap = this.visTransactionService.checkTransactionLicense();
            if (!((String)licenseMap.get("licenseState")).equals("success")) {
                if (((String)licenseMap.get("license")).equals("vis_message_maxLicenseCount")) {
                    licenseMap.put("license", I18nUtil.i18nCode((String)((String)licenseMap.get("license")), (Object[])new Object[]{licenseMap.get("errorCount"), licenseMap.get("deviceCount")}));
                } else if (((String)licenseMap.get("license")).equals("vis_message_maxCount")) {
                    licenseMap.put("license", I18nUtil.i18nCode((String)((String)licenseMap.get("license")), (Object[])new Object[]{licenseMap.get("warningCount"), licenseMap.get("deviceCount")}));
                } else {
                    String licenseMsg = I18nUtil.i18nCode((String)((String)licenseMap.get("license")), (Object[])new Object[0]);
                    licenseMap.put("license", licenseMsg);
                }
            }
            for (Map.Entry entry : licenseMap.entrySet()) {
                this.request.setAttribute((String)entry.getKey(), entry.getValue());
            }
            if (palceDataMap.get("placeId") != null) {
                visRegistrationItem.setEnterPlace(palceDataMap.get("placeId").toString());
            }
            if (StringUtils.isNotBlank((CharSequence)(carPlateProvince = this.visTransactionService.getDefaultCarPlateProvince()))) {
                visRegistrationItem.setCarPlateProvince(carPlateProvince);
            }
        }
        String visSCParam = (String)visParams.get("vis.isNeedSC");
        if (StringUtils.isBlank((CharSequence)visRegistrationItem.getCardNo()) && "1".equals(visSCParam)) {
            String serialNo = this.visTransactionService.getUniqCardNo();
            visRegistrationItem.setCardNo(serialNo);
        }
        if (clone) {
            VisRegistrationItem cloneItem = new VisRegistrationItem();
            cloneItem.setVisitedEmpName(visRegistrationItem.getVisitedEmpName());
            cloneItem.setVisitedEmpLastName(visRegistrationItem.getVisitedEmpLastName());
            cloneItem.setVisitedEmpId(visRegistrationItem.getVisitedEmpId());
            cloneItem.setVisitedEmpPin(visRegistrationItem.getVisitedEmpPin());
            cloneItem.setVisitedEmpDeptId(visRegistrationItem.getVisitedEmpDeptId());
            cloneItem.setVisitedEmpDept(visRegistrationItem.getVisitedEmpDept());
            cloneItem.setVisitReason(visRegistrationItem.getVisitReason());
            cloneItem.setCompany(visRegistrationItem.getCompany());
            cloneItem.setNationality(visRegistrationItem.getNationality());
            cloneItem.setLevelIds(visRegistrationItem.getLevelIds());
            cloneItem.setEnterPlace("" + palceDataMap.get("placeId"));
            cloneItem.setValidStartTime(visRegistrationItem.getValidStartTime());
            cloneItem.setValidEndTime(visRegistrationItem.getValidEndTime());
            visRegistrationItem = cloneItem;
            this.request.setAttribute("clone", (Object)true);
        }
        this.request.setAttribute("palceDataMap", palceDataMap);
        this.request.setAttribute("item", (Object)visRegistrationItem);
        List attributes = this.visAttributeService.getByCondition(new VisAttributeItem());
        this.getAttribute(attributes);
        this.request.setAttribute("bioTemplateJson", (Object)bioTemplateJson);
        this.request.setAttribute("showSignature", (Object)this.visTransactionService.isShowSignature());
        return new ModelAndView("vis/registration/editVisPCRegistration");
    }

    @RequiresPermissions(value={"vis:registration:edit", "vis:registration:add"})
    @LogRequest(module="vis_module", object="vis_leftMenu_enterRegistration", opType="common_op_edit", requestParams={"visEmpCertNumber", "visEmpName"}, opContent="pers_person_name")
    public ZKResultMsg save(VisRegistrationItem item, @RequestParam Map<String, String> attrMap) {
        ZKResultMsg res = new ZKResultMsg();
        Map retMap = this.visTransactionService.saveVisRegistrationItem(item, attrMap);
        res.setData((Object)retMap);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"vis:registration:refresh"})
    public DxGrid list(VisRegistrationItem condition) {
        String visitStateStr = this.request.getParameter("visVisitState");
        if ("0".equals(visitStateStr)) {
            condition.setFilterVisitState(Short.valueOf((short)1));
        } else if ("1".equals(visitStateStr)) {
            condition.setFilterBeginEnterTime(DateUtil.getTodayBeginTime());
        }
        Pager pager = this.visTransactionService.getItemsByPageByCondition((BaseItem)condition, this.getPageNo(), this.getPageSize(), visitStateStr);
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:registration:del"})
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.visTransactionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"vis:registration:exit"})
    public ModelAndView editVisPCExit(@RequestParam(value="id") String id) {
        String pin = "";
        VisWatchListItem visWatchListItem = null;
        Map visParams = this.visParamsService.getVisParams();
        this.request.setAttribute("visParams", (Object)visParams);
        VisTransactionItem item = new VisTransactionItem();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            item = this.visTransactionService.getItemById(id);
            Map valueMap = this.visVisitorService.getVisitorAttributeValues(item.getVisEmpId());
            this.request.setAttribute("map1", (Object)valueMap);
            pin = item.getVisEmpPin();
            VisVisitorItem visVisitorItem = this.visVisitorService.getItemByPin(pin);
            if (visVisitorItem != null && (visWatchListItem = this.visWatchListService.findByCert(visVisitorItem.getCertType(), visVisitorItem.getCertNumber())) != null && visWatchListItem.getEnabled() != null && visWatchListItem.getEnabled() == 1) {
                this.request.setAttribute("watchList", (Object)visWatchListItem);
            }
        }
        String cpuData = this.request.getParameter("cpuData");
        String macData = this.request.getParameter("macData");
        VisPlaceItem visPlaceItem = null;
        if (StringUtils.isNotBlank((CharSequence)macData)) {
            String[] macDatas;
            for (String mac : macDatas = macData.split(",")) {
                visPlaceItem = this.visPlaceService.getItemByPhysicalKey(cpuData + mac);
                if (visPlaceItem == null) continue;
                item.setExitPlace(visPlaceItem.getId());
                Map palceDataMap = this.visPlaceService.getVisDefaultData(visPlaceItem);
                this.request.setAttribute("palceDataMap", (Object)palceDataMap);
                break;
            }
        }
        this.request.setAttribute("item", (Object)item);
        List attributes = this.visAttributeService.getByCondition(new VisAttributeItem());
        this.getAttribute(attributes);
        if (this.visWatchListService.checkLicense()) {
            this.request.setAttribute("advancedLicense", (Object)true);
        }
        return new ModelAndView("vis/exit/editVisPCExit");
    }

    @RequiresPermissions(value={"vis:registration:exit"})
    @LogRequest(module="vis_module", object="vis_op_exit", opType="vis_op_exit", requestParams={"visEmpName"}, opContent="pers_person_name")
    public ZKResultMsg exit(VisRegistrationItem item, @RequestParam Map<String, String> attrMap) {
        ZKResultMsg res = new ZKResultMsg();
        VisWatchListItem visWatchListItem = new VisWatchListItem();
        this.visTransactionService.applyVisitorExit(item, attrMap);
        visWatchListItem.setWatchListType("1");
        visWatchListItem.setCertType(item.getVisEmpCertType());
        visWatchListItem.setCertNumber(item.getVisEmpCertNumber());
        if (StringUtils.isNotBlank((CharSequence)attrMap.get("addToWatchList")) && attrMap.get("addToWatchList").equals("on")) {
            visWatchListItem.setEnabled(Integer.valueOf(1));
            visWatchListItem.setName(item.getVisEmpName());
            visWatchListItem.setLastName(item.getVisEmpLastName());
            visWatchListItem.setCategory(attrMap.get("addCategory"));
            visWatchListItem.setRemark(attrMap.get("remark"));
            if (StringUtils.isNotBlank((CharSequence)attrMap.get("addWatchListTime")) && attrMap.get("addWatchListTime").equals("on")) {
                visWatchListItem.setSetWatchTime(Boolean.valueOf(true));
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    visWatchListItem.setStartWatchTime(sdf.parse(attrMap.get("startWatchTime")));
                    visWatchListItem.setEndWatchTime(sdf.parse(attrMap.get("endWatchTime")));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            this.visWatchListService.addList(visWatchListItem);
        } else {
            VisWatchListItem item1 = this.visWatchListService.findByCerTypeAndCerNum(visWatchListItem.getCertType(), visWatchListItem.getCertNumber());
            if (!Objects.isNull(item1) && item1.getEnabled() == 1) {
                this.visWatchListService.deleteWatchListMess(visWatchListItem);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg saveInfoLoad(@RequestParam(value="certNumber") String certNumber, @RequestParam(value="certType") String certType) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        if (StringUtils.isBlank((CharSequence)certType) || StringUtils.isBlank((CharSequence)certNumber)) {
            return zkResultMsg;
        }
        zkResultMsg = this.visTransactionService.loadEnterInfo(certNumber, certType);
        String ret = zkResultMsg.getRet();
        if ("-1".equals(ret)) {
            zkResultMsg.setMsg(I18nUtil.i18nCode((String)"vis_message_cardSent", (Object[])new Object[0]));
        } else if ("-2".equals(ret)) {
            zkResultMsg.setMsg(I18nUtil.i18nCode((String)"vis_message_disabledEmp", (Object[])new Object[0]));
        } else if ("-6".equals(ret)) {
            zkResultMsg.setMsg(I18nUtil.i18nCode((String)"vis_message_employeeDeleted", (Object[])new Object[0]));
        } else {
            zkResultMsg.setRet("ok");
            zkResultMsg.setMsg(I18nUtil.i18nCode((String)"vis_message_certInputSuccess", (Object[])new Object[0]));
        }
        return zkResultMsg;
    }

    private void getAttribute(List<VisAttributeItem> attributeItems) {
        ArrayList rows = new ArrayList();
        ArrayList<Integer> rowInts = new ArrayList<Integer>();
        HashMap<String, ArrayList<Integer>> maxTds = new HashMap<String, ArrayList<Integer>>();
        HashMap<String, VisAttributeItem> attrs = new HashMap<String, VisAttributeItem>();
        for (VisAttributeItem attributeItem : attributeItems) {
            ArrayList<Integer> colList;
            Integer row = attributeItem.getPositionX();
            Integer col = attributeItem.getPositionY();
            if (!rowInts.contains(row)) {
                rowInts.add(row);
            }
            if ((colList = (ArrayList<Integer>)maxTds.get("" + row)) == null) {
                colList = new ArrayList<Integer>();
            }
            colList.add(col);
            Collections.sort(colList);
            maxTds.put("" + row, colList);
            attrs.put("" + row + col, attributeItem);
        }
        Collections.sort(rowInts);
        CollectionUtils.collect(rowInts, (Transformer)new Transformer(){

            public Object transform(Object o) {
                return o.toString();
            }
        }, rows);
        this.request.setAttribute("attrs", attrs);
        this.request.setAttribute("tds", maxTds);
        this.request.setAttribute("trs", rows);
    }

    public ZKResultMsg exitInfoLoad() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String certNumber = this.request.getParameter("certNumber");
        String certType = this.request.getParameter("certType");
        String cardNo = this.request.getParameter("cardNo");
        String visitNumber = this.request.getParameter("visitNumber");
        zkResultMsg.setMsg(I18nUtil.i18nCode((String)"vis_message_certInputSuccess", (Object[])new Object[0]));
        if (StringUtils.isNotBlank((CharSequence)visitNumber) && visitNumber.length() > 9) {
            zkResultMsg = this.visTransactionService.loadExitInfoByVisitNumber(visitNumber);
        } else if (StringUtils.isNotBlank((CharSequence)visitNumber) && visitNumber.length() <= 9) {
            zkResultMsg = this.visTransactionService.loadExitInfoByCardNo(visitNumber);
        } else if (StringUtils.isNotBlank((CharSequence)cardNo)) {
            zkResultMsg = this.visTransactionService.loadExitInfoByCardNo(cardNo);
        } else if (StringUtils.isNotBlank((CharSequence)certNumber)) {
            if (StringUtils.isBlank((CharSequence)certType)) {
                zkResultMsg.setRet("fail");
                zkResultMsg.setMsg(I18nUtil.i18nCode((String)"vis_message_certTypeRequired", (Object[])new Object[0]));
            } else {
                zkResultMsg = this.visTransactionService.loadExitInfoByCertNo(certNumber, certType);
            }
        }
        if ("-4".equals(zkResultMsg.getRet())) {
            zkResultMsg.setMsg(I18nUtil.i18nCode((String)"vis_message_noVisitRecord", (Object[])new Object[0]));
        } else {
            zkResultMsg.setRet("ok");
        }
        return zkResultMsg;
    }

    public String checkCardBit(@RequestParam(value="cardNo") String cardNo) {
        return String.valueOf(this.visTransactionService.checkCardBit(cardNo));
    }

    public String isCardExist(@RequestParam(value="cardNo") String cardNo, @RequestParam(value="pin") String pin) {
        return String.valueOf(!this.visTransactionService.isExistByCardNoAndPin(cardNo, pin));
    }

    public String checkPwd(@RequestParam(value="personPwd") String personPwd, @RequestParam(value="pin") String pin) {
        return String.valueOf(!this.visTransactionService.checkPwd(personPwd, pin));
    }

    public ModelAndView getVisInfoByCertNumber(@RequestParam(value="certType") String certType, @RequestParam(value="certNumber") String certNumber) {
        VisTranBackFillItem item = new VisTranBackFillItem();
        VisVisitorItem visVisitorItem = this.visVisitorService.getItemByCertTypeAndCertNumber(Short.valueOf(Short.parseShort(certType)), certNumber);
        if (visVisitorItem != null) {
            visVisitorItem.setCertName(this.visTransactionService.getCertNameByCertCode(certType));
            if (StringUtils.isNotBlank((CharSequence)visVisitorItem.getGender())) {
                switch (visVisitorItem.getGender()) {
                    case "M": {
                        visVisitorItem.setGender(I18nUtil.i18nCode((String)"pers_person_male", (Object[])new Object[0]));
                        break;
                    }
                    case "F": {
                        visVisitorItem.setGender(I18nUtil.i18nCode((String)"pers_person_female", (Object[])new Object[0]));
                    }
                }
            }
        }
        item.setVisVisitorItem(visVisitorItem);
        List visTransactions = this.visTransactionService.getLast5VisTransaction(certType, certNumber);
        item.setVisTransactionItemList(visTransactions);
        this.request.setAttribute("item", (Object)item);
        return new ModelAndView("vis/registration/editBackFillInfo");
    }

    public ZKResultMsg visitorExist(@RequestParam(value="certType") String certType, @RequestParam(value="certNumber") String certNumber) {
        VisVisitorItem visVisitorItem = this.visVisitorService.getItemByCertTypeAndCertNumber(Short.valueOf(Short.parseShort(certType)), certNumber);
        List visTransactions = this.visTransactionService.getLast5VisTransaction(certType, certNumber);
        if (visVisitorItem != null && visTransactions != null && visTransactions.size() > 0) {
            return new ZKResultMsg((Object)visVisitorItem);
        }
        return new ZKResultMsg();
    }

    public ZKResultMsg getRegistrationItemById(@RequestParam(value="id") String id) {
        ZKResultMsg res = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            JSONObject jsonObject = new JSONObject();
            VisRegistrationItem item = this.visTransactionService.getRegistrationItemById(id);
            String levelIds = this.visTransactionService.getVisLevelIdsByTransactionId(id);
            item.setLevelIds(levelIds);
            jsonObject.put("item", (Object)item);
            String bioTemplateJson = JSON.toJSONString((Object)this.visBioTemplateService.getItemMapByVisitorId(item.getVisEmpId()));
            jsonObject.put("bioTemplateJson", (Object)bioTemplateJson);
            res.setData((Object)jsonObject);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public String checkMaxVisitorForDay(@RequestParam(value="maxVisitorForDay") String maxVisitorForDay) {
        long visitorForDay = this.visTransactionService.countTodayVisitor();
        boolean rs = Long.parseLong(maxVisitorForDay) > visitorForDay;
        return rs + "";
    }

    public String checkMaxVisitorForPerson(@RequestParam(value="openMaxVisitorForPerson") String openMaxVisitorForPerson, @RequestParam(value="visitedEmpId") String visitedEmpId) {
        if (StringUtils.isNotBlank((CharSequence)visitedEmpId)) {
            long maxVisitorForPerson = this.visTransactionService.countTodayVisitedEmp(visitedEmpId);
            boolean rs = Long.parseLong(openMaxVisitorForPerson) > maxVisitorForPerson;
            return rs + "";
        }
        return "true";
    }
}

