/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.guard;

import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.guard.LicenseUtil;
import com.zkteco.zkbiosecurity.guard.license.bean.Country;
import com.zkteco.zkbiosecurity.guard.license.bean.Module;
import com.zkteco.zkbiosecurity.guard.license.bean.ModuleBean;
import com.zkteco.zkbiosecurity.guard.license.bean.ModuleCode;
import com.zkteco.zkbiosecurity.guard.license.bean.SystemFunction;
import com.zkteco.zkbiosecurity.license.vo.bean.ResultCode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class LicenseCheckUtil {
    private static final Logger log = LoggerFactory.getLogger(LicenseCheckUtil.class);

    public static ResultCode isSupportFunction(SystemFunction function) {
        Assert.notNull((Object)((Object)function), (String)"license function can not be empty");
        Module functionModule = function.getModule();
        return LicenseUtil.getLicenseContext().isSupportFunction(functionModule);
    }

    public static int getDeviceCount(LicenseModule module) {
        Assert.notNull((Object)((Object)module), (String)"module can not be empty");
        return LicenseUtil.getLicenseContext().getControlCount(module.getModule());
    }

    public static ResultCode isCountOutRangeAcc(LicenseModule module, Map<String, Integer> countParams) {
        Assert.isTrue((countParams != null ? 1 : 0) != 0, (String)"countParams must not be null!");
        Assert.isTrue((module == LicenseModule.PULL || module == LicenseModule.PUSH ? 1 : 0) != 0, (String)"module must be LicenseModule.PULL or LicenseModule.PUSH");
        Integer pullGateCount = countParams.get("pullGateCount");
        Integer pullDevCount = countParams.get("pullDevCount");
        Integer pushGateCount = countParams.get("pushGateCount");
        Integer pushDevCount = countParams.get("pushDevCount");
        Assert.isTrue((pullGateCount != null ? 1 : 0) != 0, (String)"countParams must contains pullGateCount param >=0 ");
        Assert.isTrue((pullDevCount != null ? 1 : 0) != 0, (String)"countParams must contains pullDevCount param >=0");
        Assert.isTrue((pushGateCount != null ? 1 : 0) != 0, (String)"countParams must contain pushGateCount param >=0");
        Assert.isTrue((pushDevCount != null ? 1 : 0) != 0, (String)"countParams must contains pushDevCount param >=0");
        ResultCode result = LicenseUtil.getLicenseContext().supportModule(module.getModule());
        if (result != ResultCode.SUCCESS) {
            return result;
        }
        int controlCount = LicenseCheckUtil.getControlCount(module.getModule());
        boolean noOverLimit = false;
        if (LicenseUtil.isLocal()) {
            noOverLimit = module == LicenseModule.PULL ? controlCount >= pullDevCount : controlCount >= pushDevCount;
        } else if (module == LicenseModule.PULL) {
            noOverLimit = controlCount >= pullDevCount;
        } else {
            boolean bl = noOverLimit = controlCount >= pushGateCount + pullGateCount;
        }
        if (noOverLimit) {
            return ResultCode.SUCCESS;
        }
        return ResultCode.OVER;
    }

    public static ResultCode isCountOutRange(LicenseModule module, int controlCount) {
        Assert.notNull((Object)((Object)module), (String)"module can not be empty");
        Assert.isTrue((module != LicenseModule.PULL ? 1 : 0) != 0, (String)"module can not be LicenseModule.PULL");
        Assert.isTrue((module != LicenseModule.PUSH ? 1 : 0) != 0, (String)"module can not be LicenseModule.PUSH");
        ResultCode result = LicenseUtil.getLicenseContext().supportModule(module.getModule());
        if (result != ResultCode.SUCCESS) {
            return result;
        }
        int licenseCount = LicenseCheckUtil.getControlCount(module.getModule());
        if (licenseCount >= controlCount) {
            return ResultCode.SUCCESS;
        }
        return ResultCode.OVER;
    }

    private static ResultCode isCountOutOfflineEleRange(LicenseModule module, int controlCount) {
        Assert.notNull((Object)((Object)module), (String)"module can not be empty");
        Assert.isTrue((module != LicenseModule.PULL ? 1 : 0) != 0, (String)"module can not be LicenseModule.PULL");
        Assert.isTrue((module != LicenseModule.PUSH ? 1 : 0) != 0, (String)"module can not be LicenseModule.PUSH");
        ResultCode result = LicenseUtil.getLicenseContext().supportModule(module.getModule());
        if (result != ResultCode.SUCCESS) {
            return result;
        }
        int licenseCount = LicenseCheckUtil.getControlOfflineEleCount(module.getModule());
        if (licenseCount >= controlCount) {
            return ResultCode.SUCCESS;
        }
        return ResultCode.OVER;
    }

    public static boolean isSupportOnvif() {
        ResultCode result = LicenseUtil.getLicenseContext().supportModule(LicenseModule.VID.getModule());
        if (result == ResultCode.SUCCESS) {
            ModuleBean module = LicenseUtil.getLicenseContext().getLicenseModule(LicenseModule.VID.getCode());
            return module.getMajor() == 1;
        }
        return false;
    }

    public static boolean isVmsSupportOnvif() {
        ResultCode result = LicenseUtil.getLicenseContext().supportModule(LicenseModule.VMS.getModule());
        if (result == ResultCode.SUCCESS) {
            ModuleBean module = LicenseUtil.getLicenseContext().getLicenseModule(LicenseModule.VMS.getCode());
            return module.getMajor() == 1;
        }
        return false;
    }

    public static ResultCode isCountOutRangeVis(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.VIS, controlCount);
    }

    public static ResultCode isCountOutRangePers(int controlCount) {
        ModuleBean moduleBean = LicenseUtil.getLicenseContext().getLicenseModule("systempers");
        ResultCode resultCode = ResultCode.UNAUTH;
        int count = 0;
        if (moduleBean.licenseAvaiable()) {
            count = LicenseUtil.getLicenseContext().getControlCount(Module.MODULE_SYSTEM_PERS);
            if (controlCount <= count) {
                resultCode = ResultCode.SUCCESS;
            }
        } else {
            count = LicenseUtil.getTrialControlCount("systempers");
            if (controlCount <= count) {
                resultCode = ResultCode.SUCCESS;
            }
        }
        return resultCode;
    }

    public static ResultCode isCountOutRangeIns(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.INS, controlCount);
    }

    public static ResultCode isCountOutRangeInsAtt(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.INSATT, controlCount);
    }

    public static ResultCode isCountOutRangeDep(int controlCount) {
        ModuleBean moduleBean = LicenseUtil.getLicenseContext().getLicenseModule("systemdepartment");
        ResultCode resultCode = ResultCode.UNAUTH;
        int count = 0;
        if (moduleBean.licenseAvaiable()) {
            count = LicenseUtil.getLicenseContext().getControlCount(Module.MODULE_SYSTEM_DEPARTMENT);
            if (controlCount <= count) {
                resultCode = ResultCode.SUCCESS;
            }
        } else {
            count = LicenseUtil.getTrialControlCount("systemdepartment");
            if (controlCount <= count) {
                resultCode = ResultCode.SUCCESS;
            }
        }
        return resultCode;
    }

    public static ResultCode isCountOutRangeArea(int controlCount) {
        ModuleBean moduleBean = LicenseUtil.getLicenseContext().getLicenseModule("systemarea");
        ResultCode resultCode = ResultCode.UNAUTH;
        int count = 0;
        if (moduleBean.licenseAvaiable()) {
            count = LicenseUtil.getLicenseContext().getControlCount(Module.MODULE_SYSTEM_AREA);
            if (controlCount <= count) {
                resultCode = ResultCode.SUCCESS;
            }
        } else {
            count = LicenseUtil.getTrialControlCount("systemarea");
            if (controlCount <= count) {
                resultCode = ResultCode.SUCCESS;
            }
        }
        return resultCode;
    }

    public static ResultCode isCountOutRangeVisPlace(int controlCount) {
        ResultCode result = LicenseUtil.getLicenseContext().supportModule(LicenseModule.VIS.module);
        if (result != ResultCode.SUCCESS) {
            return result;
        }
        int licenseCount = LicenseUtil.getLicenseContext().getVisPlaceControlCount();
        if (licenseCount >= controlCount) {
            return ResultCode.SUCCESS;
        }
        return ResultCode.OVER;
    }

    public static ResultCode isCountOutRangeVid(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.VID, controlCount);
    }

    public static ResultCode isCountOutRangePos(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.POS, controlCount);
    }

    public static ResultCode isCountOutRangeEle(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.ELE, controlCount);
    }

    public static ResultCode isCountOutRangeOfflineEle(int controlCount) {
        return LicenseCheckUtil.isCountOutOfflineEleRange(LicenseModule.ELE, controlCount);
    }

    public static ResultCode isCountOutRangeLed(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.LED, controlCount);
    }

    public static ResultCode isCountOutRangePersIdReader(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.PERSIDREADER, controlCount);
    }

    public static ResultCode isCountOutRangeVisOcr(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.VISOCR, controlCount);
    }

    public static ResultCode isCountOutRangeVisIdReader(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.VISIDREADER, controlCount);
    }

    public static ResultCode isCountOutRangeVisPrintCard(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.VISPRINTCARD, controlCount);
    }

    public static ResultCode isCountOutRangePat(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.PAT, controlCount);
    }

    public static ResultCode isCountOutRangePark(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.PARK, controlCount);
    }

    public static ResultCode isCountOutRangeC2p(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.C2P, controlCount);
    }

    public static ResultCode isCountOutRangeArteco(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.ARTECO, controlCount);
    }

    public static ResultCode isCountOutRangeOcr(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.OCR, controlCount);
    }

    public static ResultCode isCountOutRangeApp(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.APP, controlCount);
    }

    public static ResultCode isCountOutRangeAtt(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.ATT, controlCount);
    }

    public static ResultCode isCountOutRangeAccAtt(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.ACCATT, controlCount);
    }

    public static ResultCode isCountOutRangeHotelOcr(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.HOTELOCR, controlCount);
    }

    public static ResultCode isCountOutRangeHotelIdReader(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.HOTELIDREADER, controlCount);
    }

    public static ResultCode isCountOutRangeSystemPers(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.SYSTEMPERS, controlCount);
    }

    public static ResultCode isCountOutRangeSystemDepartment(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.SYSTEMDEPARTMENT, controlCount);
    }

    public static ResultCode isCountOutRangeSystemArea(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.SYSTEMAREA, controlCount);
    }

    public static ResultCode isCountOutRangeHotelPrintCard(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.HOTELPRINTCARD, controlCount);
    }

    public static ResultCode isCountOutRangeHotel(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.HOTEL, controlCount);
    }

    public static ResultCode isCountOutParkingLprCamera(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.PARKINGLPRCAMERA, controlCount);
    }

    public static ResultCode isCountOutAccessControlDoor(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.ACCESSCONTROLDOOR, controlCount);
    }

    public static ResultCode isCountOutPidAtt(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.PIDATT, controlCount);
    }

    public static ResultCode isCountOutAI(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.AI, controlCount);
    }

    public static ModuleBean getModuleInfo(LicenseModule module) {
        if (LicenseUtil.getLicenseContext() == null) {
            log.error("get LicenseContext is null ,please wait LicenseContext init");
            return null;
        }
        ModuleBean moduleBean = LicenseUtil.getLicenseContext().getLicenseModule(module.getCode());
        return moduleBean;
    }

    public static List<String> getActiveModuleLIist() {
        ArrayList<String> list = new ArrayList<String>();
        for (LicenseModule licenseModule : LicenseModule.values()) {
            ModuleBean moduleBean = LicenseUtil.getLicenseContext().getLicenseModule(licenseModule.getCode());
            if (moduleBean == null || moduleBean.isTrial()) continue;
            list.add(moduleBean.getCode());
        }
        return list;
    }

    public static String getCountry(String code) {
        ArrayList countries = Lists.newArrayList((Object[])Country.values());
        HashMap<String, String> map = new HashMap<String, String>();
        for (Country country : countries) {
            map.put(country.getNewCode(), country.name());
        }
        return (String)map.get(code);
    }

    public static Map<String, Object> getIDType(LicenseModule module) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ModuleBean moduleBean = LicenseUtil.getLicenseContext().getLicenseModule(module.getCode());
        String idType = Integer.toBinaryString(moduleBean.getMajor());
        char id = idType.charAt(idType.length() - 1);
        if (idType.length() == 1) {
            map.put("id", Character.valueOf(id));
            map.put("driving", Character.valueOf('0'));
            map.put("passport", Character.valueOf('0'));
        } else if (idType.length() == 2) {
            map.put("id", Character.valueOf(idType.charAt(idType.length() - 1)));
            map.put("driving", Character.valueOf(idType.charAt(idType.length() - 2)));
            map.put("passport", Character.valueOf('0'));
        } else if (idType.length() == 3) {
            map.put("id", Character.valueOf(idType.charAt(idType.length() - 1)));
            map.put("driving", Character.valueOf(idType.charAt(idType.length() - 2)));
            map.put("passport", Character.valueOf(idType.charAt(idType.length() - 3)));
        } else {
            map.put("id", Character.valueOf('0'));
            map.put("driving", Character.valueOf('0'));
            map.put("passport", Character.valueOf('0'));
        }
        if (moduleBean != null && !moduleBean.isTrial()) {
            return map;
        }
        return null;
    }

    public static Map<String, Object> getDeviceRegisterType(LicenseModule module) {
        String idType;
        HashMap<String, Object> map = new HashMap<String, Object>();
        ModuleBean moduleBean = LicenseUtil.getLicenseContext().getLicenseModule(module.getCode());
        String registerType = idType = Integer.toBinaryString(moduleBean.getMajor());
        if (idType.length() < 4) {
            for (int i = 0; i < 4 - idType.length(); ++i) {
                registerType = "0" + registerType;
            }
        }
        map.put("1", Character.valueOf(registerType.charAt(registerType.length() - 1)));
        map.put("3", Character.valueOf(registerType.charAt(registerType.length() - 3)));
        map.put("4", Character.valueOf(registerType.charAt(registerType.length() - 4)));
        if (moduleBean != null && !moduleBean.isTrial()) {
            return map;
        }
        return null;
    }

    public static Map<String, Object> getAccPushDeviceType() {
        String idType;
        HashMap<String, Object> map = new HashMap<String, Object>();
        ModuleBean moduleBean = LicenseUtil.getLicenseContext().getLicenseModule(LicenseModule.PUSH.getCode());
        String registerType = idType = Integer.toBinaryString(moduleBean.getMajor());
        if (idType.length() < 4) {
            for (int i = 0; i < 4 - idType.length(); ++i) {
                registerType = "0" + registerType;
            }
        }
        map.put("1", Character.valueOf(registerType.charAt(registerType.length() - 1)));
        map.put("0", Character.valueOf(registerType.charAt(registerType.length() - 3)));
        map.put("3", Character.valueOf(registerType.charAt(registerType.length() - 4)));
        if (moduleBean != null && !moduleBean.isTrial()) {
            return map;
        }
        if ("ZKBioAccess".equals(ModuleCode.productCode)) {
            map.put("0", Character.valueOf('1'));
            map.put("1", Character.valueOf('0'));
            map.put("3", Character.valueOf('1'));
        } else {
            map.put("1", Character.valueOf('1'));
            map.put("3", Character.valueOf('1'));
            map.put("0", Character.valueOf('0'));
        }
        return map;
    }

    public static int getControlCount(Module module) {
        return LicenseUtil.getLicenseContext().getControlCount(module.getCode());
    }

    private static int getControlOfflineEleCount(Module module) {
        return LicenseUtil.getLicenseContext().getControlOfflineEleCount(module.getCode());
    }

    public static int getLanguagePack() {
        return LicenseUtil.getLanguagePack();
    }

    public static ResultCode isCountOutRangePsg(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.PSG, controlCount);
    }

    public static ResultCode isCountOutRangeVisSignature(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.VISSIGNATURE, controlCount);
    }

    public static ResultCode isCountOutRangeVms(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.VMS, controlCount);
    }

    public static ResultCode isCountOutRangePosID(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.POSID, controlCount);
    }

    public static ResultCode isCountOutRangeIcm(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.ICM, controlCount);
    }

    public static ResultCode isCountOutVmsAtt(int controlCount) {
        return LicenseCheckUtil.isCountOutRange(LicenseModule.VMSATT, controlCount);
    }

    public static enum LicenseModule {
        PULL(Module.MODULE_ACC_PULL),
        PUSH(Module.MODULE_ACC_PUSH),
        VIS(Module.MODULE_VIS),
        ELE(Module.MODULE_ELE),
        VID(Module.MODULE_VID),
        POS(Module.MODULE_POS),
        PAT(Module.MODULE_PAT),
        HOTEL(Module.MODULE_HOTEL),
        LED(Module.MODULE_LED),
        PARK(Module.MODULE_PARK),
        ATT(Module.MODULE_ATT),
        ACCATT(Module.MODULE_ACC_ATT),
        ARTECO(Module.MODULE_ARTECO),
        C2P(Module.MODULE_C2P),
        OCR(Module.MODULE_OCR),
        AD(Module.MODULE_AD),
        PRINTCARD(Module.MODULE_PRINTCARD),
        API(Module.MODULE_API),
        APP(Module.MODULE_APP),
        PERSIDREADER(Module.MODULE_PERS_ID_READER),
        VISOCR(Module.MODULE_VIS_OCR),
        VISIDREADER(Module.MODULE_VIS_ID_READER),
        VISPRINTCARD(Module.MODULE_VIS_PRINT_CARD),
        HOTELOCR(Module.MODULE_HOTEL_OCR),
        HOTELIDREADER(Module.MODULE_HOTEL_ID_READER),
        HOTELPRINTCARD(Module.MODULE_HOTEL_PRINT_CARD),
        SYSTEMPERS(Module.MODULE_SYSTEM_PERS),
        SYSTEMDEPARTMENT(Module.MODULE_SYSTEM_DEPARTMENT),
        SYSTEMAREA(Module.MODULE_SYSTEM_AREA),
        PARKINGLPRCAMERA(Module.MODULE_PARKING_LPR_CAMERA),
        ACCESSCONTROLDOOR(Module.MODULE_ACCESS_CONTROL_DOOR),
        LCD(Module.MODULE_LCD),
        PID(Module.MODULE_PID),
        PSG(Module.MODULE_PSG),
        INS(Module.MODULE_INS),
        INSATT(Module.MODULE_INS_ATT),
        CARDCONTROL(Module.MODULE_CARD_CONTROL),
        PIDATT(Module.MODULE_PID_ATT),
        AI(Module.MODULE_AI),
        HOTELSIGNATURE(Module.MODULE_HOTEL_SIGNATURE),
        VISSIGNATURE(Module.MODULE_VIS_SIGNATURE),
        MIDDLETABLE(Module.MODULE_MIDDLE_TABLE),
        VMS(Module.MODULE_VMS),
        POSID(Module.MODULE_POSID),
        OA(Module.MODULE_OA),
        ICM(Module.MODULE_ICM),
        VMSATT(Module.MODULE_VMS_ATT),
        VISADVANCED(Module.MODULE_VIS_ADVANCED),
        GSMGPRSMODEM(Module.MODULE_GSMGPRSMODEM),
        LINE(Module.MODULE_LINE),
        ASSETS(Module.MODULE_ASSETS),
        FENCE(Module.MODULE_FENCE),
        DIGIFORT(Module.MODULE_DIGIFORT);

        private Module module;

        public Module getModule() {
            return this.module;
        }

        private LicenseModule(Module module) {
            this.module = module;
        }

        public String getCode() {
            return this.module.getCode();
        }
    }
}

