/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.guard.license.util;

import com.google.common.collect.Maps;
import com.zkteco.zkbiosecurity.guard.license.bean.LicModule;
import com.zkteco.zkbiosecurity.guard.license.bean.ModuleBean;
import com.zkteco.zkbiosecurity.guard.license.util.Crc32Util;
import com.zkteco.zkbiosecurity.guard.license.util.RSAUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jni.zklicense2.zklicclient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicCheckUtil2 {
    private static final Logger log = LoggerFactory.getLogger(LicCheckUtil2.class);

    public static void initRSA() {
        try {
            RSAUtil.InitializeRSA();
            int nRet = zklicclient.ZKInitialize(RSAUtil.getModulus(), RSAUtil.getExponent());
            if (nRet < 0) {
                log.error("\u521d\u59cb\u5316\u52a0\u5bc6\u516c\u94a5\u5931\u8d25:" + nRet);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int getCrcFromLicense(String licenseNum) {
        ModuleBean moduleBean = LicCheckUtil2.getLicenseModuleBean(licenseNum);
        if (moduleBean != null) {
            return moduleBean.getCompanyNameCrc16();
        }
        return 0;
    }

    public static int getCrcFromSn(String sn) {
        ModuleBean moduleBean = LicCheckUtil2.getSnModuleBean(sn);
        if (moduleBean != null) {
            return moduleBean.getCompanyNameCrc16();
        }
        return 0;
    }

    public static String createUPK(String serialNum) {
        String strTemp;
        String sn = LicCheckUtil2.proccessLicenseStr(serialNum);
        int nRet = 0;
        byte[] upk = new byte[2048];
        nRet = zklicclient.ZKCheckLicense(sn, upk, 2048);
        if (nRet < 0) {
            log.error("\u751f\u6210\u6fc0\u6d3b\u7801\u5931\u8d25\uff0c\u8fd4\u56de\u503c:" + nRet);
            strTemp = "";
        } else {
            strTemp = new String(upk);
        }
        return strTemp;
    }

    public static boolean checkLicenseLegal(String licenseStr) {
        String licenseStr_ = LicCheckUtil2.proccessLicenseStr(licenseStr);
        int nRet = 0;
        byte[] upk = new byte[2048];
        nRet = zklicclient.ZKCheckLicense(licenseStr_, upk, 2048);
        if (nRet < 0) {
            log.debug("\u6821\u9a8c\u6fc0\u6388\u6743\u5931\u8d25\uff0c\u8fd4\u56de\u503c:" + nRet);
            return false;
        }
        return true;
    }

    public static Map<String, Integer> getLicenseInfoEx(String licenseNumber) {
        String licenseStr = LicCheckUtil2.proccessLicenseStr(licenseNumber);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        LicCheckUtil2.initRSA();
        String strTemp = null;
        byte[] desc = new byte[2048];
        int nRet = zklicclient.ZKGetLicenseInfoEx(licenseStr, desc, 2048);
        if (nRet >= 0) {
            strTemp = new String(desc);
            strTemp = strTemp.trim();
            String strLicDesc = null;
            try {
                strLicDesc = RSAUtil.DecryptZKlicense(strTemp);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            log.debug("\u89e3\u5bc6\u6388\u6743\u63cf\u8ff0\uff1a" + strLicDesc);
            String[] arrayKeyvalue = strLicDesc.split("\t");
            int nCount = arrayKeyvalue.length;
            strTemp = arrayKeyvalue[nCount - 2];
            int nCrc = Integer.parseInt(strTemp.split("=")[1]);
            String strCheck = RSAUtil.getModulus();
            for (int i = 0; i < nCount; ++i) {
                strTemp = arrayKeyvalue[i];
                if (strTemp.startsWith("LicCrc")) {
                    nCrc = Integer.parseInt(strTemp.split("=")[1]);
                    break;
                }
                strCheck = strCheck + "|";
                strCheck = strCheck + strTemp.split("=")[1];
            }
            if (nCrc == Crc32Util.getCRC32(strCheck)) {
                for (String param : arrayKeyvalue) {
                    String[] arr = param.split("=");
                    map.put(arr[0], Integer.parseInt(arr[1]));
                }
            } else {
                log.debug("\u6821\u9a8c\u5931\u8d25");
            }
        } else {
            log.debug("\u89e3\u6790\u6fc0\u6388\u6743\u5931\u8d25\uff0c\u8fd4\u56de\u503c:" + nRet);
        }
        return map;
    }

    public static Map<String, Integer> getSnInfoEx(String sn) {
        String snStr = LicCheckUtil2.proccessLicenseStr(sn);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        LicCheckUtil2.initRSA();
        String strTemp = null;
        byte[] desc = new byte[2048];
        int nRet = zklicclient.ZKGetSequenceInfoEx(snStr, desc, 2048);
        if (nRet >= 0) {
            strTemp = new String(desc);
            strTemp = strTemp.trim();
            String strLicDesc = null;
            try {
                strLicDesc = RSAUtil.DecryptZKlicense(strTemp);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            log.debug("\u89e3\u5bc6\u5e8f\u5217\u53f7\u63cf\u8ff0\uff1a" + strLicDesc);
            String[] arrayKeyvalue = strLicDesc.split("\t");
            int nCount = arrayKeyvalue.length;
            strTemp = arrayKeyvalue[nCount - 2];
            int nCrc = Integer.parseInt(strTemp.split("=")[1]);
            String strCheck = RSAUtil.getModulus();
            for (int i = 0; i < nCount; ++i) {
                strTemp = arrayKeyvalue[i];
                if (strTemp.startsWith("LicCrc")) {
                    nCrc = Integer.parseInt(strTemp.split("=")[1]);
                    break;
                }
                strCheck = strCheck + "|";
                strCheck = strCheck + strTemp.split("=")[1];
            }
            if (nCrc == Crc32Util.getCRC32(strCheck)) {
                for (String param : arrayKeyvalue) {
                    String[] arr = param.split("=");
                    map.put(arr[0], Integer.parseInt(arr[1]));
                }
            } else {
                log.debug("\u6821\u9a8c\u5931\u8d25");
            }
        } else {
            log.debug("\u89e3\u6790\u5e8f\u5217\u53f7\u5931\u8d25\uff0c\u8fd4\u56de\u503c:" + nRet);
        }
        return map;
    }

    public static Map<String, ModuleBean> getSnModuleBeans(List<LicModule> modules) {
        HashMap resultMap = Maps.newHashMap();
        for (LicModule module : modules) {
            String sn = module.getSerialNumber();
            resultMap.put(module.getId(), LicCheckUtil2.getLicenseModuleBean(sn));
        }
        return resultMap;
    }

    public static Map<String, ModuleBean> getLicenseModuleBeans(List<LicModule> modules) {
        HashMap resultMap = Maps.newHashMap();
        for (LicModule module : modules) {
            String licenseNumber = module.getLicenseNumber();
            resultMap.put(module.getId(), LicCheckUtil2.getLicenseModuleBean(licenseNumber));
        }
        return resultMap;
    }

    public static ModuleBean getSnModuleBean(String sn) {
        return LicCheckUtil2.getModuleBeanByNum(sn, true);
    }

    public static ModuleBean getLicenseModuleBean(String licenseNum) {
        return LicCheckUtil2.getModuleBeanByNum(licenseNum, false);
    }

    public static ModuleBean getModuleBeanByNum(String num, boolean isSn) {
        Map<String, Integer> moduleLicCheckMap = null;
        moduleLicCheckMap = !isSn ? LicCheckUtil2.getLicenseInfoEx(LicCheckUtil2.proccessLicenseStr(num)) : LicCheckUtil2.getSnInfoEx(LicCheckUtil2.proccessLicenseStr(num));
        if (moduleLicCheckMap != null && !moduleLicCheckMap.isEmpty()) {
            int licenseType = moduleLicCheckMap.get("LicenseType");
            int major = moduleLicCheckMap.get("Major");
            int countModule = moduleLicCheckMap.get("CountModule");
            int productCode = moduleLicCheckMap.get("ProductCode");
            int minor = moduleLicCheckMap.get("Minor");
            int limitNumberOfDays = moduleLicCheckMap.get("LimitNumberOfDays");
            int languagePack = moduleLicCheckMap.get("LanguagePack");
            int licenseID = moduleLicCheckMap.get("LicenseID");
            int module = moduleLicCheckMap.get("Module");
            int companyNameCrc16 = moduleLicCheckMap.get("CompanyNameCrc16");
            Integer extCode = moduleLicCheckMap.get("ExtCode");
            if (extCode == null) {
                extCode = 0;
            }
            ModuleBean ModuleBean2 = new ModuleBean(licenseID, countModule, limitNumberOfDays, languagePack, companyNameCrc16, licenseType, major, minor, module, productCode, false, null, null, extCode);
            return ModuleBean2;
        }
        return null;
    }

    private static String proccessLicenseStr(String licenseStr) {
        return StringUtils.defaultString((String)licenseStr).replace("-", "");
    }

    public static void main(String[] args) {
        String sn = "FAB3E19680D94C6A5DA1F53640E45DD4387C78C4884A2A5B8AB826";
        String licenseNum = "FAB072-40BD27-F1CD68-60379D-1B756E-66B525-81E1E3-BCD773-74C396";
        Map<String, Integer> info = LicCheckUtil2.getLicenseInfoEx(licenseNum);
        System.out.println("license info:");
        for (Map.Entry<String, Integer> entry : info.entrySet()) {
            System.out.println(entry.getKey() + "=" + entry.getValue());
        }
    }
}

