/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;

public abstract class Process {
    public abstract OutputStream getOutputStream();

    public abstract InputStream getInputStream();

    public abstract InputStream getErrorStream();

    public abstract int waitFor() throws InterruptedException;

    public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        long startTime = System.nanoTime();
        long rem = unit.toNanos(timeout);
        while (true) {
            try {
                this.exitValue();
                return true;
            }
            catch (IllegalThreadStateException ex) {
                if (rem <= 0L) continue;
                Thread.sleep(Math.min(TimeUnit.NANOSECONDS.toMillis(rem) + 1L, 100L));
                if ((rem = unit.toNanos(timeout) - (System.nanoTime() - startTime)) > 0L) continue;
                return false;
            }
            break;
        }
    }

    public abstract int exitValue();

    public abstract void destroy();

    public Process destroyForcibly() {
        this.destroy();
        return this;
    }

    public boolean isAlive() {
        try {
            this.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }
}

