/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.model;

import com.zkteco.zkbiosecurity.auth.model.AuthRole;
import com.zkteco.zkbiosecurity.core.model.BaseModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="AUTH_PERMISSION", indexes={@Index(name="AUTH_PERMISSION_CRT_TIME_IDX", columnList="CREATE_TIME"), @Index(name="AUTH_PERMISSION_UPT_TIME_IDX", columnList="UPDATE_TIME")})
public class AuthPermission
extends BaseModel
implements Serializable {
    private static final long serialVersionUID = -6529352169327057548L;
    @Column(name="CODE", length=50, unique=true)
    private String code;
    @Column(name="NAME", length=50)
    private String name;
    @Column(name="PERMISSION", length=128)
    private String permission;
    @Column(name="RESOURCE_TYPE")
    private String resourceType;
    @Column(name="AVAILABLE", length=10)
    private String available;
    @Column(name="ACTION_LINK")
    private String actionLink;
    @Column(name="ORDER_NO")
    private Integer orderNo;
    @Column(name="IMG", length=120)
    private String img;
    @Column(name="IMG_HOVER", length=150)
    private String imgHover;
    @ManyToMany(targetEntity=AuthRole.class)
    @JoinTable(name="AUTH_ROLE_PERMISSION", joinColumns={@JoinColumn(name="AUTH_PERMISSION_ID", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="AUTH_ROLE_ID", referencedColumnName="ID")})
    private Set<AuthRole> roles = new HashSet<AuthRole>();
    @ManyToOne
    @JoinColumn(name="AUTH_PERMISSION_PARENT_ID")
    private AuthPermission parent;
    @OneToMany(mappedBy="parent")
    private List<AuthPermission> children = new ArrayList<AuthPermission>();

    public AuthPermission() {
    }

    public AuthPermission(String code, String name, String permission, String resourceType, String available, String actionLink, Integer orderNo, AuthPermission parent) {
        this.code = code;
        this.name = name;
        this.permission = permission;
        this.resourceType = resourceType;
        this.available = available;
        this.actionLink = actionLink;
        this.orderNo = orderNo;
        this.parent = parent;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getPermission() {
        return this.permission;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getAvailable() {
        return this.available;
    }

    public String getActionLink() {
        return this.actionLink;
    }

    public Integer getOrderNo() {
        return this.orderNo;
    }

    public String getImg() {
        return this.img;
    }

    public String getImgHover() {
        return this.imgHover;
    }

    public Set<AuthRole> getRoles() {
        return this.roles;
    }

    public AuthPermission getParent() {
        return this.parent;
    }

    public List<AuthPermission> getChildren() {
        return this.children;
    }

    public AuthPermission setCode(String code) {
        this.code = code;
        return this;
    }

    public AuthPermission setName(String name) {
        this.name = name;
        return this;
    }

    public AuthPermission setPermission(String permission) {
        this.permission = permission;
        return this;
    }

    public AuthPermission setResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public AuthPermission setAvailable(String available) {
        this.available = available;
        return this;
    }

    public AuthPermission setActionLink(String actionLink) {
        this.actionLink = actionLink;
        return this;
    }

    public AuthPermission setOrderNo(Integer orderNo) {
        this.orderNo = orderNo;
        return this;
    }

    public AuthPermission setImg(String img) {
        this.img = img;
        return this;
    }

    public AuthPermission setImgHover(String imgHover) {
        this.imgHover = imgHover;
        return this;
    }

    public AuthPermission setRoles(Set<AuthRole> roles) {
        this.roles = roles;
        return this;
    }

    public AuthPermission setParent(AuthPermission parent) {
        this.parent = parent;
        return this;
    }

    public AuthPermission setChildren(List<AuthPermission> children) {
        this.children = children;
        return this;
    }
}

