/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.annotation.Where;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="PSG_TRANSACTION t ")
@Where(after="AND (t.EVENT_NO >= 20 and t.EVENT_NO < 200 OR t.EVENT_NO >= 500) ")
@OrderBy(after="t.EVENT_TIME DESC")
@GridConfig
public class PsgAlarmTransactionItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(width="0", sortNo=0)
    private String id;
    @Column(name="t.EVENT_TIME")
    @GridColumn(label="common_time", width="125")
    private Date eventTime;
    @Column(name="t.EVENT_NAME", equalTag="in")
    @GridColumn(label="common_eventDescription", width="125", i18n=true)
    private String eventName;
    @Column(name="t.EVENT_POINT_NAME")
    @GridColumn(label="common_eventPoint", width="125")
    private String eventPointName;
    @Column(name="t.DEV_ALIAS")
    @GridColumn(label="common_dev_name", width="110")
    private String devAlias;
    @Column(name="t.GATE_TYPE")
    @GridColumn(label="psg_device_gateType", format="0=,1=psg_device_threeRollerGate,2=psg_device_wingGate,3=psg_device_swingGate", width="125")
    private Short gateType;
    @Column(name="t.PASSAGE_NAME")
    @GridColumn(label="psg_passage_name", width="125")
    private String passageName;
    @Column(name="t.VID_LINKAGE_HANDLE")
    @GridColumn(label="common_mediaFile", width="100", columnType="custom", convert="convertPsgVidLinkage", isExportExcel=false)
    private String vidLinkageHandle;
    @Column(name="t.CARD_NO")
    @GridColumn(label="pers_card_cardNo", width="100")
    private String cardNo;
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin", width="100")
    private String pin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", width="100")
    private String name;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'")
    private String lastName;
    @Column(name="t.DEPT_CODE")
    private String deptCode;
    @Column(name="t.DEPT_NAME")
    @GridColumn(label="pers_dept_deptName", width="100")
    private String deptName;
    @Column(name="t.READER_NAME")
    @GridColumn(label="psg_readerDefine_readerName", width="100")
    private String readerName;
    @Column(name="t.VERIFY_MODE_NAME", equalTag="in")
    @GridColumn(label="common_verifyMode_entiy", width="100", i18n=true)
    private String verifyModeName;
    @Column(name="t.DESCRIPTION")
    @GridColumn(label="common_remark", width="50")
    private String description;
    @Column(name="t.DEV_ID")
    private String devId;
    @Column(name="t.DEV_SN")
    private String devSn;
    @Column(name="t.VERIFY_MODE_NO")
    private Short verifyModeNo;
    @Column(name="t.EVENT_NO")
    private Short eventNo;
    @Column(name="t.EVENT_POINT_TYPE")
    private Short eventPointType;
    @Column(name="t.EVENT_POINT_ID")
    private String eventPointId;
    @Column(name="t.READER_STATE")
    private Short readerState;
    @Column(name="t.TRIGGER_COND")
    private Short triggerCond;
    @Column(name="t.EVENT_ADDR")
    private Short eventAddr;
    @Column(name="t.UNIQUE_KEY")
    private String uniqueKey;
    @Condition(value="t.EVENT_TIME", equalTag=">=")
    private Date startTime;
    @Condition(value="t.EVENT_TIME", equalTag="<=")
    private Date endTime;
    @Condition(value="(t.DEPT_CODE in (%s) or t.DEPT_CODE is null or t.DEPT_CODE = '')", formatType="quote")
    private String deptCodeIn;

    public String getId() {
        return this.id;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getEventPointName() {
        return this.eventPointName;
    }

    public String getDevAlias() {
        return this.devAlias;
    }

    public Short getGateType() {
        return this.gateType;
    }

    public String getPassageName() {
        return this.passageName;
    }

    public String getVidLinkageHandle() {
        return this.vidLinkageHandle;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getReaderName() {
        return this.readerName;
    }

    public String getVerifyModeName() {
        return this.verifyModeName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDevId() {
        return this.devId;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public Short getVerifyModeNo() {
        return this.verifyModeNo;
    }

    public Short getEventNo() {
        return this.eventNo;
    }

    public Short getEventPointType() {
        return this.eventPointType;
    }

    public String getEventPointId() {
        return this.eventPointId;
    }

    public Short getReaderState() {
        return this.readerState;
    }

    public Short getTriggerCond() {
        return this.triggerCond;
    }

    public Short getEventAddr() {
        return this.eventAddr;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getDeptCodeIn() {
        return this.deptCodeIn;
    }

    public PsgAlarmTransactionItem setId(String id) {
        this.id = id;
        return this;
    }

    public PsgAlarmTransactionItem setEventTime(Date eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    public PsgAlarmTransactionItem setEventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    public PsgAlarmTransactionItem setEventPointName(String eventPointName) {
        this.eventPointName = eventPointName;
        return this;
    }

    public PsgAlarmTransactionItem setDevAlias(String devAlias) {
        this.devAlias = devAlias;
        return this;
    }

    public PsgAlarmTransactionItem setGateType(Short gateType) {
        this.gateType = gateType;
        return this;
    }

    public PsgAlarmTransactionItem setPassageName(String passageName) {
        this.passageName = passageName;
        return this;
    }

    public PsgAlarmTransactionItem setVidLinkageHandle(String vidLinkageHandle) {
        this.vidLinkageHandle = vidLinkageHandle;
        return this;
    }

    public PsgAlarmTransactionItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public PsgAlarmTransactionItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public PsgAlarmTransactionItem setName(String name) {
        this.name = name;
        return this;
    }

    public PsgAlarmTransactionItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public PsgAlarmTransactionItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public PsgAlarmTransactionItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PsgAlarmTransactionItem setReaderName(String readerName) {
        this.readerName = readerName;
        return this;
    }

    public PsgAlarmTransactionItem setVerifyModeName(String verifyModeName) {
        this.verifyModeName = verifyModeName;
        return this;
    }

    public PsgAlarmTransactionItem setDescription(String description) {
        this.description = description;
        return this;
    }

    public PsgAlarmTransactionItem setDevId(String devId) {
        this.devId = devId;
        return this;
    }

    public PsgAlarmTransactionItem setDevSn(String devSn) {
        this.devSn = devSn;
        return this;
    }

    public PsgAlarmTransactionItem setVerifyModeNo(Short verifyModeNo) {
        this.verifyModeNo = verifyModeNo;
        return this;
    }

    public PsgAlarmTransactionItem setEventNo(Short eventNo) {
        this.eventNo = eventNo;
        return this;
    }

    public PsgAlarmTransactionItem setEventPointType(Short eventPointType) {
        this.eventPointType = eventPointType;
        return this;
    }

    public PsgAlarmTransactionItem setEventPointId(String eventPointId) {
        this.eventPointId = eventPointId;
        return this;
    }

    public PsgAlarmTransactionItem setReaderState(Short readerState) {
        this.readerState = readerState;
        return this;
    }

    public PsgAlarmTransactionItem setTriggerCond(Short triggerCond) {
        this.triggerCond = triggerCond;
        return this;
    }

    public PsgAlarmTransactionItem setEventAddr(Short eventAddr) {
        this.eventAddr = eventAddr;
        return this;
    }

    public PsgAlarmTransactionItem setUniqueKey(String uniqueKey) {
        this.uniqueKey = uniqueKey;
        return this;
    }

    public PsgAlarmTransactionItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public PsgAlarmTransactionItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public PsgAlarmTransactionItem setDeptCodeIn(String deptCodeIn) {
        this.deptCodeIn = deptCodeIn;
        return this;
    }
}

