/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.redis.configuration;

import com.zkteco.zkbiosecurity.base.bean.CacheTime;
import com.zkteco.zkbiosecurity.base.trait.CacheExpireFunction;
import com.zkteco.zkbiosecurity.redis.configuration.FastJson2JsonRedisSerializer;
import com.zkteco.zkbiosecurity.redis.configuration.RedisPrefix;
import com.zkteco.zkbiosecurity.redis.constants.RedisConstant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCachePrefix;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@EnableCaching
public class RedisTemplateConfiguration {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, Long> ttlMap = new HashMap<String, Long>();
    @Autowired(required=false)
    private CacheExpireFunction[] cacheTtl;
    private List<String> flushCache = new ArrayList<String>();

    @Bean
    @Primary
    public RedisTemplate redisTemplate(JedisConnectionFactory jedisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)jedisConnectionFactory);
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        FastJson2JsonRedisSerializer<Object> fastJson2JsonRedisSerializer = new FastJson2JsonRedisSerializer<Object>(Object.class);
        redisTemplate.setKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.setValueSerializer(fastJson2JsonRedisSerializer);
        redisTemplate.setHashValueSerializer(fastJson2JsonRedisSerializer);
        try {
            this.logger.debug("redis ping:{}", (Object)redisTemplate.getConnectionFactory().getConnection().ping());
        }
        catch (Exception e) {
            this.logger.error("redis connection fail", (Throwable)e);
        }
        return redisTemplate;
    }

    @Bean
    public KeyGenerator KeyGenerator() {
        return (target, method, params) -> {
            StringBuilder sb = new StringBuilder();
            sb.append(target.getClass().getName());
            sb.append(method.getName());
            for (Object obj : params) {
                sb.append(obj.toString());
            }
            return sb.toString();
        };
    }

    @PostConstruct
    public void init() {
        if (this.cacheTtl != null) {
            this.ttlMap = Stream.of(this.cacheTtl).map(CacheExpireFunction::addExpires).peek(cacheTime -> {
                if (cacheTime.getNeedFlush().booleanValue()) {
                    this.flushCache.add(cacheTime.getName());
                }
            }).collect(Collectors.toMap(CacheTime::getName, cacheTime -> cacheTime.getExpire().getSeconds()));
        }
    }

    @Bean
    public CacheManager cacheManager(RedisTemplate redisTemplate) {
        RedisCacheManager manager = new RedisCacheManager((RedisOperations)redisTemplate);
        manager.setUsePrefix(true);
        RedisPrefix cachePrefix = new RedisPrefix("cache:");
        manager.setCachePrefix((RedisCachePrefix)cachePrefix);
        manager.setDefaultExpiration(RedisConstant.DEFAULT_EXPIRATION.longValue());
        manager.setExpires(this.ttlMap);
        return manager;
    }
}

