/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.api.controller;

import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.api.vo.PersApiDepartmentItem;
import com.zkteco.zkbiosecurity.pers.service.PersApiDepartmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/department"})
@Api(tags={"PersDepartment "}, description="person department")
public class PersApiDepartmentController {
    private static final Logger log = LoggerFactory.getLogger(PersApiDepartmentController.class);
    @Autowired
    private PersApiDepartmentService persApiDepartmentService;

    @ApiOperation(value="Add Department", notes="Create Or Update Department", response=ApiResultMessage.class)
    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage add(@RequestBody PersApiDepartmentItem department) {
        ApiResultMessage rs = null;
        try {
            rs = this.persApiDepartmentService.updateDepartment(department);
        }
        catch (Exception e) {
            log.error("api department/add error ", (Throwable)e);
            rs = ApiResultMessage.failedMessage((int)-1);
        }
        return rs;
    }

    @ApiOperation(value="Delete Department", notes="Delete Department By Code", response=ApiResultMessage.class)
    @RequestMapping(value={"/delete/{code}"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage deleteByCode(@PathVariable String code) {
        ApiResultMessage rs = null;
        try {
            rs = this.persApiDepartmentService.deleteDeptByCode(code);
        }
        catch (ZKBusinessException e) {
            rs = ApiResultMessage.message((int)-15, (String)MessageFormat.format(I18nUtil.i18nCode((String)e.getMessage(), (Object[])new Object[0]), e.getObjects()));
        }
        catch (Exception e) {
            log.error("api department/delete error ", (Throwable)e);
            rs = ApiResultMessage.failedMessage((int)-1);
        }
        return rs;
    }

    @ApiOperation(value="Get Department", notes="Get Department By Code", response=ApiResultMessage.class)
    @RequestMapping(value={"/get/{code}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getByCode(@PathVariable String code) {
        ApiResultMessage rs = null;
        try {
            rs = this.persApiDepartmentService.getDeptByCode(code);
        }
        catch (Exception e) {
            log.error("api department/get error ", (Throwable)e);
            rs = ApiResultMessage.failedMessage((int)-1);
        }
        return rs;
    }
}

