/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.remote.PersCardRemote;
import com.zkteco.zkbiosecurity.pers.service.PersCardService;
import com.zkteco.zkbiosecurity.pers.vo.PersCardItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PersCardController
extends BaseController
implements PersCardRemote {
    @Autowired
    private PersCardService persCardService;

    @RequiresPermissions(value={"pers:card"})
    public ModelAndView index() {
        return new ModelAndView("pers/card/persCard");
    }

    @RequiresPermissions(value={"pers:card:refresh"})
    public DxGrid list(PersCardItem condition) {
        Pager pager = this.persCardService.loadPagerByAuthUserFilter(this.request.getSession().getId(), (BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"pers:card:batchIssueCard"})
    public ZKResultMsg batchIssueCard() {
        return null;
    }

    @RequiresPermissions(value={"pers:card:batchCardLoss"})
    public ZKResultMsg batchCardLoss(@RequestParam(value="ids") String ids) {
        this.persCardService.batchCardLoss(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"pers:card:batchCardRevert"})
    public ZKResultMsg batchCardRevert(@RequestParam(value="ids") String ids) {
        this.persCardService.batchCardRevert(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String isExist(@RequestParam(value="cardNo") String cardNo, @RequestParam(value="pin", required=false) String pin) {
        return String.valueOf(!this.persCardService.isExistByCardNoAndPin(cardNo, pin));
    }

    public String checkCardBit(String cardNo) {
        return String.valueOf(this.persCardService.checkCardBit(cardNo));
    }

    public Map<String, String> cardVerification(String cardNo) {
        return this.persCardService.cardVerification(cardNo);
    }
}

