/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.util;

import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.util.ExportReadUtil;
import com.zkteco.zkbiosecurity.pers.vo.PersAttributeRuleItem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.DocumentFactoryHelper;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class PersExportUtil {
    private static final Logger log = LoggerFactory.getLogger(PersExportUtil.class);
    private static int maxCount = 30002;

    public static Workbook getImportWorkBook(InputStream inputStream) throws IOException {
        HSSFWorkbook workbook = null;
        if (!inputStream.markSupported()) {
            inputStream = new PushbackInputStream(inputStream, 8);
        }
        if (POIFSFileSystem.hasPOIFSHeader((InputStream)inputStream)) {
            workbook = new HSSFWorkbook(inputStream);
        } else if (DocumentFactoryHelper.hasOOXMLHeader((InputStream)inputStream)) {
            int len;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) > -1) {
                byteArrayOutputStream.write(buffer, 0, len);
            }
            byteArrayOutputStream.flush();
            ByteArrayInputStream processStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ByteArrayInputStream stream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ExportReadUtil exportReadUtil = new ExportReadUtil();
            int rowCount = exportReadUtil.processOneSheet(processStream);
            ((InputStream)processStream).close();
            processStream = null;
            byteArrayOutputStream.close();
            byteArrayOutputStream = null;
            if (rowCount > maxCount) {
                throw ZKBusinessException.errorException((String)"common_report_maxCount", (Object[])new Object[0]);
            }
            workbook = new XSSFWorkbook((InputStream)stream);
            ((InputStream)stream).close();
            stream = null;
        }
        return workbook;
    }

    public static Workbook createImportWorkBook(InputStream inputStream) {
        Workbook workbook = null;
        try {
            workbook = PersExportUtil.getImportWorkBook(inputStream);
        }
        catch (Exception ex) {
            if (ex instanceof ZKBusinessException) {
                throw ZKBusinessException.errorException((String)ex.getMessage(), (Object[])new Object[0]);
            }
            throw new ZKBusinessException("Open the EXCEL file flow failure!", (Throwable)ex);
        }
        return workbook;
    }

    public static <T> List<T> excelImport(InputStream inputStream, Class<T> cls) {
        Workbook workbook = PersExportUtil.createImportWorkBook(inputStream);
        Sheet sheet = workbook.getSheetAt(0);
        if (sheet.getLastRowNum() >= maxCount) {
            throw ZKBusinessException.errorException((String)"common_report_maxCount", (Object[])new Object[0]);
        }
        Field[] fields = cls.getDeclaredFields();
        List fieldList = Arrays.stream(fields).filter(f -> f.getAnnotation(GridColumn.class) != null || f.getType() == Map.class).collect(Collectors.toList());
        Row columnNames = sheet.getRow(1);
        ArrayList<T> list = new ArrayList<T>();
        String key = null;
        PersAttributeRuleItem fieldAttr = null;
        HashMap<Integer, PersAttributeRuleItem> fieldAttrs = new HashMap<Integer, PersAttributeRuleItem>();
        HashMap uniques = new HashMap();
        HashSet<String> clunms = new HashSet<String>();
        String[] mustFields = new String[]{"pin:pers_person_pin", "deptCode:pers_dept_deptNo"};
        String text = null;
        Field field = null;
        Date date = null;
        Field fieldStr = null;
        try {
            for (Row row : sheet) {
                int rowNum = row.getRowNum();
                if (rowNum == 1) {
                    int columnIndex = 0;
                    for (Cell cell : row) {
                        columnIndex = cell.getColumnIndex();
                        fieldAttr = (PersAttributeRuleItem)fieldAttrs.get(columnIndex);
                        Cell columnNameCell = columnNames.getCell(columnIndex);
                        columnNameCell.setCellType(1);
                        if (StringUtils.isEmpty((Object)columnNameCell.getStringCellValue())) {
                            throw new ZKBusinessException(I18nUtil.i18nCode((String)"pers_import_noComment", (Object[])new Object[]{rowNum + 1, columnIndex + 1}));
                        }
                        Comment comment = columnNameCell.getCellComment();
                        if (StringUtils.isEmpty((Object)comment)) {
                            throw new ZKBusinessException(I18nUtil.i18nCode((String)"pers_import_noComment", (Object[])new Object[]{rowNum + 1, columnIndex + 1}));
                        }
                        text = comment.getString().getString();
                        fieldAttr = new PersAttributeRuleItem(text, rowNum, columnIndex);
                        fieldAttrs.put(columnIndex, fieldAttr);
                        if (fieldAttr.getPrimaryKey() || fieldAttr.getUniqueKey()) {
                            uniques.put(fieldAttr.getName(), new HashSet());
                            if (fieldAttr.getPrimaryKey()) {
                                key = fieldAttr.getName();
                            }
                        }
                        if (clunms.add(fieldAttr.getName())) continue;
                        throw new ZKBusinessException(I18nUtil.i18nCode((String)"pers_import_fieldRepeat", (Object[])new Object[]{rowNum + 1, columnIndex + 1, fieldAttr.getName()}));
                    }
                    if (key == null) {
                        throw new ZKBusinessException(I18nUtil.i18nCode((String)"pers_import_primaryKey", (Object[])new Object[0]));
                    }
                    for (String mustField : mustFields) {
                        String[] split = mustField.split(":");
                        if (clunms.contains(split[0])) continue;
                        throw new ZKBusinessException(I18nUtil.i18nCode((String)"pers_import_mustField", (Object[])new Object[]{I18nUtil.i18nCode((String)split[1], (Object[])new Object[0])}));
                    }
                    continue;
                }
                if (rowNum <= 1) continue;
                T t = cls.newInstance();
                HashMap<String, String> attrMap = new HashMap<String, String>();
                for (Cell cell : row) {
                    Cell columnNameCell = columnNames.getCell(cell.getColumnIndex());
                    columnNameCell.setCellType(1);
                    if (StringUtils.isEmpty((Object)columnNameCell.getStringCellValue())) {
                        new ZKBusinessException("common_report_columnError");
                    }
                    if (columnNameCell == null) continue;
                    String columnName = columnNameCell.getStringCellValue();
                    fieldAttr = (PersAttributeRuleItem)fieldAttrs.get(cell.getColumnIndex());
                    field = fieldAttr.getName().contains("attrMap") ? fieldList.stream().filter(f -> f.getAnnotation(GridColumn.class) == null && f.getType() == Map.class).findFirst().orElseThrow(() -> new ZKBusinessException("common_report_columnError")) : fieldList.stream().filter(f -> f.getAnnotation(GridColumn.class) != null && columnName.equals(I18nUtil.i18nCode((String)f.getAnnotation(GridColumn.class).label(), (Object[])new Object[0]))).findFirst().orElseThrow(() -> new ZKBusinessException("common_report_columnError"));
                    field.setAccessible(true);
                    if (field.getType() == Date.class || field.getType() == Timestamp.class) {
                        DateType dateType = field.getAnnotation(DateType.class);
                        String format = PersExportUtil.getDateFormt(dateType);
                        if (cell.getCellType() == 0) {
                            if (!(cell.getNumericCellValue() > 0.0)) continue;
                            date = org.apache.poi.ss.usermodel.DateUtil.getJavaDate((double)cell.getNumericCellValue());
                            if (date == null) {
                                fieldStr = cls.getDeclaredField(field.getName() + "Str");
                                fieldStr.setAccessible(true);
                                fieldStr.set(t, "-1");
                                continue;
                            }
                            field.set(t, date);
                            continue;
                        }
                        cell.setCellType(1);
                        if (StringUtils.isEmpty((Object)cell.getStringCellValue())) continue;
                        date = DateUtil.stringToDate((String)cell.getStringCellValue(), (String)format);
                        if (date == null) {
                            fieldStr = cls.getDeclaredField(field.getName() + "Str");
                            fieldStr.setAccessible(true);
                            fieldStr.set(t, "-1");
                            continue;
                        }
                        field.set(t, date);
                        continue;
                    }
                    if (field.getType() == Map.class) {
                        cell.setCellType(1);
                        attrMap.put(fieldAttr.getName(), cell.getStringCellValue().replaceAll("&", ","));
                        field.set(t, ConvertUtils.convert(attrMap, field.getType()));
                        continue;
                    }
                    cell.setCellType(1);
                    if (StringUtils.isEmpty((Object)cell.getStringCellValue())) continue;
                    field.set(t, ConvertUtils.convert((String)cell.getStringCellValue(), field.getType()));
                }
                field = cls.getDeclaredField("rowNum");
                field.setAccessible(true);
                field.set(t, ConvertUtils.convert((Object)(rowNum + 1), Integer.class));
                list.add(t);
            }
        }
        catch (ZKBusinessException e) {
            log.error("import business error", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("import error", (Throwable)e);
            throw new ZKBusinessException("common_op_failed");
        }
        return list;
    }

    public static String getDateFormt(DateType dateType) {
        String format = "yyyy-MM-dd HH:mm:ss";
        if (dateType != null) {
            switch (dateType.type()) {
                case "date": {
                    format = "yyyy-MM-dd";
                    break;
                }
                case "time": {
                    format = "HH:mm:ss";
                    break;
                }
                case "timestamp": {
                    format = "yyyy-MM-dd HH:mm:ss";
                }
            }
        }
        return format;
    }
}

