/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.base.format;

import com.zkteco.zkbiosecurity.base.format.TreeFormat;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class TreeBuilder<T extends TreeFormat<T, PK>, PK extends Serializable> {
    public static <E extends TreeFormat<E, P>, P extends Serializable> TreeBuilder<E, P> newTreeBuilder(Class<E> clazz, Class<P> pk) {
        return new TreeBuilder();
    }

    public Set<T> buildToTreeSet(Collection<T> origin) {
        HashSet target = new HashSet();
        this.toTreeFormat(origin, target);
        return target;
    }

    public List<T> buildToTreeList(Collection<T> origin) {
        ArrayList target = new ArrayList();
        this.toTreeFormat(origin, target);
        return target;
    }

    private void toTreeFormat(Collection<T> origin, Collection<T> target) {
        LinkedList<TreeFormat> queue = new LinkedList<TreeFormat>();
        HashMap cache = new HashMap();
        for (TreeFormat data : origin) {
            if (data.getParent() == null) {
                target.add(data);
            } else {
                queue.add(data);
            }
            cache.put(data.getId(), data);
        }
        while (queue != null && !queue.isEmpty()) {
            int i;
            int queueSize = queue.size();
            for (i = 0; i < queueSize; ++i) {
                TreeFormat data = (TreeFormat)queue.poll();
                TreeFormat parent = (TreeFormat)cache.get(((TreeFormat)data.getParent()).getId());
                if (parent != null) {
                    parent.addChildren(data);
                    continue;
                }
                queue.add(data);
            }
            if (queue.size() != queueSize) continue;
            for (i = 0; i < queueSize; ++i) {
                target.add(queue.poll());
            }
        }
    }
}

